/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource.authentication;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.resource.authentication.CertificateCache;
import com.huawei.ism.drm.openstack.sdk.bo.TokenBo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.service.IAuthenticationService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IAuthenticationService", Desc="", Interface=IAuthenticationService.class)
public class AuthenticationServiceImpl
extends BaseService
implements IAuthenticationService {
    private static final String PROJECT_ID = "{project_id}";
    private static final String PATTERN = ".*";
    private static final String SPLIT_ROLE = ",";
    private static final String SPLIT_URI = "/";
    private static final String REPLACE_PATTERN = "\\{[^}]*\\}";
    private static final String QUOTAS_URL = "/ws/csha/{project_id}/quotas";
    private static final String ADMIN_ROLE = "admin,op_service";
    private static final int ZERO = 0;
    private static final Log logger = LogFactory.getInstance(AuthenticationServiceImpl.class);

    public TokenBo decodeToken(String token) {
        String tokenJson;
        AuthenticationHelper helper = AuthenticationHelper.getInstance();
        OpenstackInfo open = helper.getOpenstackInfo();
        if (open.isUseIAM()) {
            CertificateCache certificateCache = CertificateCache.getInstance();
            String certificate = certificateCache.getCertificate();
            if (VerifyUtil.isEmpty((String)certificate)) {
                logger.error((Object)"certificate is empty.");
                throw new LegoCheckedException(1073947691L);
            }
            tokenJson = helper.decodeIAMToken(token, certificate);
        } else {
            tokenJson = helper.decodeKeystoneToken(token);
        }
        if (VerifyUtil.isEmpty((String)tokenJson)) {
            logger.error((Object)"tokenJson is empty.");
            throw new LegoCheckedException(1073947691L);
        }
        JSONObject obj = JSONObject.fromObject((Object)tokenJson).getJSONObject("token");
        TokenBo info = (TokenBo)JSONObject.toBean((JSONObject)obj, TokenBo.class);
        Calendar expiresAt = info.getExpiresAt();
        if (expiresAt.getTimeInMillis() <= System.currentTimeMillis()) {
            logger.error((Object)"token is expired.");
            throw new LegoCheckedException(1073947691L);
        }
        return info;
    }

    public boolean checkAuth(TokenBo token, String uri, String method) {
        if (VerifyUtil.isEmpty((Object)token) || VerifyUtil.isEmpty((String)uri) || VerifyUtil.isEmpty((String)method)) {
            logger.error((Object)("Invalid parameter. uri:" + uri + ",method:" + method));
            return false;
        }
        try {
            List roles = token.getRoles();
            List<AuthenticationHelper.PolicyMapping> list = AuthenticationHelper.getInstance().getPolicyMappingList();
            for (AuthenticationHelper.PolicyMapping policyMapping : list) {
                if (!this.matchRequest(policyMapping, uri, method) || !this.checkScope(policyMapping, uri, token)) continue;
                List<String> policyRoles = Arrays.asList(policyMapping.getRole().split(SPLIT_ROLE));
                for (TokenBo.TokenRole role : roles) {
                    if (!policyRoles.contains(role.getName())) continue;
                    return true;
                }
            }
            logger.error((Object)("checkAuth not authorized. uri=" + uri + ",method=" + method));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("checkAuth exception. {uri:" + uri + ",method:" + method + "}" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    public String getOperationName(String uri, String method) {
        try {
            List<AuthenticationHelper.PolicyMapping> list = AuthenticationHelper.getInstance().getPolicyMappingList();
            for (AuthenticationHelper.PolicyMapping policyMapping : list) {
                if (!this.matchRequest(policyMapping, uri, method)) continue;
                return policyMapping.getOperationName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("getOperationName failed. {uri:" + uri + ",method:" + method + "}" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        logger.error((Object)("getOperationName failed. uri=" + uri + ",method=" + method));
        return null;
    }

    public Integer getLogLevel(String uri, String method) {
        try {
            List<AuthenticationHelper.PolicyMapping> list = AuthenticationHelper.getInstance().getPolicyMappingList();
            for (AuthenticationHelper.PolicyMapping policyMapping : list) {
                if (!this.matchRequest(policyMapping, uri, method)) continue;
                return Integer.valueOf(policyMapping.getLogLevel());
            }
        }
        catch (Exception e) {
            logger.error((Object)("getLogLevel failed. {uri:" + uri + ",method:" + method + "}" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        logger.error((Object)("getLogLevel failed. uri=" + uri + ",method=" + method));
        return null;
    }

    private boolean checkScope(AuthenticationHelper.PolicyMapping policyMapping, String uri, TokenBo bo) {
        TokenBo.TokenProject project;
        if (!policyMapping.isNeedCheckScope()) {
            return true;
        }
        if (this.matchSpeiclRequest(uri)) {
            List roles = bo.getRoles();
            List<String> policyRoles = Arrays.asList(ADMIN_ROLE.split(SPLIT_ROLE));
            for (TokenBo.TokenRole role : roles) {
                if (!policyRoles.contains(role.getName())) continue;
                return true;
            }
        }
        if ((project = bo.getProject()) == null) {
            logger.error((Object)"Project can not be null .");
            return false;
        }
        boolean needCheckScope = true;
        String projectId = project.getId();
        String[] tmpArray = policyMapping.getUriPattern().split(SPLIT_URI);
        for (int i = 0; i < tmpArray.length; ++i) {
            if (!PROJECT_ID.equalsIgnoreCase(tmpArray[i])) continue;
            needCheckScope = false;
            String id = uri.split(SPLIT_URI)[i];
            if (!Objects.equals(projectId, id)) continue;
            return true;
        }
        return needCheckScope;
    }

    private boolean matchRequest(AuthenticationHelper.PolicyMapping policyMapping, String uri, String method) {
        String pattern = policyMapping.getUriPattern().replaceAll(REPLACE_PATTERN, PATTERN);
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(Normalizer.normalize(this.getValidUrl(uri), Normalizer.Form.NFKC));
        return m.matches() && method.equalsIgnoreCase(policyMapping.getMethod());
    }

    private boolean matchSpeiclRequest(String uri) {
        String pattern = QUOTAS_URL.replaceAll(REPLACE_PATTERN, PATTERN);
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(Normalizer.normalize(this.getValidUrl(uri), Normalizer.Form.NFKC));
        return m.matches();
    }

    private String getValidUrl(String url) {
        if (url.endsWith(SPLIT_URI)) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }
}

