/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.ServiceInstanceBackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceCreateImpl;
import com.huawei.ism.drm.openstack.serviceinstance.task.DowngradeInstanceTask;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractServiceInstanceModifyImpl
extends AbstractServiceInstanceCreateImpl {
    private static final Log logger = LogFactory.getInstance(AbstractServiceInstanceModifyImpl.class);
    private static final List<String> VHA_REPLICATION_ALLOWDOWNGRADE_STATUS = Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_MODIFY_TYPE.getValue());
    private static final List<String> VHA_REPLICATION_ALLOWDOWNGRADE_REPLICATIONSTATUS = Arrays.asList(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue());

    public String downgradeServiceInstance(String projectId, String instanceId, ExtendParamInfo extendParam, String productId) {
        this.checkEmptyParam(projectId, instanceId, extendParam);
        List<String> allowedDownGradeInstanceTypes = Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue());
        String reservedInsType = extendParam.getReservedInsType();
        if (!allowedDownGradeInstanceTypes.contains(extendParam.getReservedInsType())) {
            logger.error((Object)("not support downgrade to instance type:" + reservedInsType + ", instanceId=" + instanceId));
            throw new LegoCheckedException(1073947393L);
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        this.checkInstanceProjectId(projectId, instance);
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        String projUuid = (String)pg.getProps().get("projectId");
        String regionUuid = (String)pg.getProps().get("regionId");
        this.checkSharedVolums(regionUuid, projUuid, pg.getPolist(), pg.getPolist(), false);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(serviceType)) {
            logger.error((Object)("instance type is not allow downgrade,type: " + serviceType + ", instanceId=" + instanceId));
            throw new LegoCheckedException(1073947393L);
        }
        List<String> allowdList = VHA_REPLICATION_ALLOWDOWNGRADE_STATUS;
        if (!allowdList.contains(instance.getStatus())) {
            logger.error((Object)("instance status is not allow delete,statu: " + instance.getStatus() + ", instanceId=" + instanceId));
            throw new LegoCheckedException(1073948693L, "delete instance(" + instanceId + ") error, because its status is " + instance.getStatus() + ".");
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue().equals(reservedInsType)) {
            this.checkReplicationParam(pg);
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue().equals(reservedInsType)) {
            this.checkVHAParam(pg);
        }
        if (extendParam.isCheck()) {
            return null;
        }
        Map newProps = pg.getProps();
        newProps.put("before_delete_instance_status", instance.getStatus());
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(pg.getUuid(), newProps);
        String type = instance.getType();
        DowngradeInstanceTask task = new DowngradeInstanceTask(projectId, type, instance.getId(), instance.getName(), reservedInsType);
        OrderInstanceInfo inst = this.createOrderInstanceInfo(instanceId, pg.getName(), reservedInsType, projectId, (String)pg.getProps().get("regionId"));
        inst.setProductId(productId);
        this.updateTaskInfo(ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DOWNGRADE_INSTANCE, extendParam, task, inst, instance);
        long taskId = ServiceInstanceBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    private void checkVHAParam(ProtectGroup pg) {
        if (OpenStackBasicUtil.isCsdrVhaMode(pg)) {
            logger.error((Object)"Downgrading to VHA instance after reprotected is not supported");
            throw new LegoCheckedException(1073948144L);
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        this.checkOriginalAvaliableRegion(pg, regionUuid);
        String projectUuid = (String)pg.getProps().get("projectId");
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String hyperMetroCgUuid = (String)pg.getProps().get("hyperProCgUuid");
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(openStackUuid);
        VolumeReplicationCgInfo cgInfo = this.checkHyperMetroNotChange(projectUuid, regionUuid, tokenId, drExtendManager, hyperMetroCgUuid, true);
        List<String> allowes = Arrays.asList(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue());
        if (!allowes.contains(cgInfo.getReplicationStatus())) {
            logger.error((Object)("status is not allow downgrade to vha. " + new JSONObject().set((Object)"project", (Object)projectUuid).set((Object)"region", (Object)regionUuid).set((Object)"cg", (Object)hyperMetroCgUuid).set((Object)"status", (Object)cgInfo.getReplicationStatus()).toString()));
            throw new LegoCheckedException(1073948149L, new String[]{ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue()});
        }
    }

    private void checkEmptyParam(String projectId, String instanceId, ExtendParamInfo extendParam) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)("param is empty.instanceId: " + instanceId + " projectId: " + projectId));
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)extendParam)) {
            logger.error((Object)"extendParam is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)extendParam.getReservedInsType())) {
            logger.error((Object)"extendParam ReservedInsType is empty.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkReplicationParam(ProtectGroup pg) {
        String projUuid = (String)pg.getProps().get("projectId");
        String regionUuid = (String)pg.getProps().get("regionId");
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        String cgReplicationRemoteUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        String cgReplicationDrRemoteUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        IDrExtendManager drExtendManager = ManagerFactory.getInstance().getDrExtendManager(openstackUuid);
        this.checkOriginalAvaliableRegion(pg, regionUuid);
        VolumeReplicationCgInfo cgInfo = drExtendManager.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, cgUuid, new int[0]);
        VolumeReplicationCgInfo cgReplicationRemoteInfo = drExtendManager.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, cgReplicationRemoteUuid, new int[0]);
        String replicaStatus = null;
        String remoteReplicaStatus = null;
        if (null != cgInfo && null != cgReplicationRemoteInfo) {
            replicaStatus = this.queryReplicaStatus(cgInfo.getReplicationStatus(), pg, drExtendManager, drCgUuid);
            remoteReplicaStatus = this.queryReplicaStatus(cgReplicationRemoteInfo.getReplicationStatus(), pg, drExtendManager, cgReplicationDrRemoteUuid);
            if (VHA_REPLICATION_ALLOWDOWNGRADE_REPLICATIONSTATUS.contains(replicaStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(remoteReplicaStatus)) {
                String hypermetroCgUuid = (String)pg.getProps().get("hyperProCgUuid");
                this.checkHyperMetroNotChange(projUuid, regionUuid, tokenId, drExtendManager, hypermetroCgUuid, false);
                return;
            }
            if (VHA_REPLICATION_ALLOWDOWNGRADE_REPLICATIONSTATUS.contains(remoteReplicaStatus) && OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
                String hypermetroDrCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
                this.checkHyperMetroNotChange(projUuid, regionUuid, tokenId, drExtendManager, hypermetroDrCgUuid, false);
                return;
            }
        } else if (null != cgInfo && null == cgReplicationRemoteInfo) {
            replicaStatus = this.queryReplicaStatus(cgInfo.getReplicationStatus(), pg, drExtendManager, drCgUuid);
            if (VHA_REPLICATION_ALLOWDOWNGRADE_REPLICATIONSTATUS.contains(replicaStatus)) {
                String hypermetroCgUuid = (String)pg.getProps().get("hyperProCgUuid");
                this.checkHyperMetroNotChange(projUuid, regionUuid, tokenId, drExtendManager, hypermetroCgUuid, false);
                return;
            }
        } else if (null == cgInfo && null != cgReplicationRemoteInfo && VHA_REPLICATION_ALLOWDOWNGRADE_REPLICATIONSTATUS.contains(remoteReplicaStatus = this.queryReplicaStatus(cgReplicationRemoteInfo.getReplicationStatus(), pg, drExtendManager, cgReplicationDrRemoteUuid))) {
            String hypermetroDrCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
            this.checkHyperMetroNotChange(projUuid, regionUuid, tokenId, drExtendManager, hypermetroDrCgUuid, false);
            return;
        }
        logger.error((Object)("replicaStatus is error.replicaStatus:" + replicaStatus + " remoteReplicaStatus:" + remoteReplicaStatus + ", protectGroupName=" + pg.getName()));
        throw new LegoCheckedException(1073948924L);
    }

    private VolumeReplicationCgInfo checkHyperMetroNotChange(String projectUuid, String regionUuid, String tokenId, IDrExtendManager drExtendManager, String hyperMetroCgUuid, boolean isCheckNull) {
        VolumeReplicationCgInfo cgHyperMetroInfo = drExtendManager.queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projectUuid, hyperMetroCgUuid, new int[0]);
        if (null == cgHyperMetroInfo) {
            if (!isCheckNull) {
                logger.debug((Object)"downgrade to csdr, HyperMetro has been null");
                return null;
            }
            logger.error((Object)("not find HperMetro. " + new JSONObject().set((Object)"CG uuid", (Object)hyperMetroCgUuid).set((Object)"project uuid", (Object)projectUuid).set((Object)"region uuid", (Object)regionUuid).toString()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!cgHyperMetroInfo.isMasterFlag()) {
            logger.error((Object)("The primary end of the asynchronous replication is not the primary end of the HyperMetro.hyperMetroCgUuid=" + hyperMetroCgUuid));
            throw new LegoCheckedException(1073948925L);
        }
        return cgHyperMetroInfo;
    }

    private void checkOriginalAvaliableRegion(ProtectGroup pg, String currenRegionUuid) {
        String initialRegion = (String)pg.getProps().get("originalAvailableRegion");
        if (!currenRegionUuid.equals(initialRegion)) {
            logger.error((Object)"The current service is at the DR site and cannot be downgraded.");
            throw new LegoCheckedException(1073948923L);
        }
    }

    private String queryReplicaStatus(String primaryReplicaStatus, ProtectGroup pg, IDrExtendManager drExtendManager, String id) {
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue().equals(primaryReplicaStatus)) {
            pg.getProps().put("replicaCgRepStatus", primaryReplicaStatus);
            return primaryReplicaStatus;
        }
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        VolumeReplicationCgInfo cgInfo = drExtendManager.queryRealtimeVolumeReplicationCG(drRegionUuid, drTokenId, drProjUuid, id, new int[0]);
        if (null == cgInfo) {
            logger.error((Object)("the VolumeReplicationCgInfo is null: remoteCGID=" + id));
            pg.getProps().put("replicaCgRepStatus", OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ERROR.getValue());
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ERROR.getValue();
        }
        return cgInfo.getReplicationStatus();
    }
}

