/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteLogBO;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteLogsBO;
import com.huawei.ism.drm.openstack.sdk.bo.ExecuteProcessesBO;
import com.huawei.ism.drm.openstack.sdk.bo.PageForExecuteLogs;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceQueryImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class AbstractServiceInstanceReplicationQueryImpl
extends AbstractServiceInstanceQueryImpl {
    private static final Log logger = LogFactory.getInstance(AbstractServiceInstanceReplicationQueryImpl.class);

    public ExecuteLogBO queryReplicationLog(String projectId, String instanceId, String logId) {
        logger.debug((Object)("query ServiceInstances by projectId , the project id is " + projectId + ", instanceId : " + instanceId + ", logId : " + logId));
        this.validateParams(instanceId, projectId);
        if (VerifyUtil.isEmpty((String)logId)) {
            logger.error((Object)"Failed to query serviceInstances.log_id is empty.");
            throw new LegoCheckedException(1073947393L, "log_id is empty.");
        }
        ServiceInstance serviceInstance = AbstractServiceInstanceReplicationQueryImpl.queryServiceInstance(instanceId);
        if (null == serviceInstance) {
            logger.error((Object)("Failed to query serviceInstances.serviceInstance is null,instanceId=" + instanceId));
            throw new LegoCheckedException(2117645L, "instance(" + instanceId + ") is not a replication.");
        }
        this.checkInstanceProjectId(projectId, serviceInstance);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceInstance.getType())) {
            throw new LegoCheckedException(1073947393L, "instance(" + instanceId + ")'type is not replication.");
        }
        int pgLogId = -1;
        try {
            pgLogId = Integer.parseInt(logId);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"logId is not a number", (Throwable)e);
        }
        if (pgLogId < 0) {
            throw new LegoCheckedException(201L, "replication log is not found.");
        }
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgLogs = service.queryHistoryLogDetailFromAll(pgLogId, serviceInstance.getProtectGroupId());
        if (VerifyUtil.isEmpty((Collection)pgLogs)) {
            logger.error((Object)("Failed to query serviceInstances.replication log is not found,instanceId=" + instanceId + ",instanceName=" + serviceInstance.getName()));
            throw new LegoCheckedException(201L, "replication log is not found.");
        }
        return this.configReplicationLog(logId, pgLogs);
    }

    private ExecuteLogBO configReplicationLog(String logId, List<ProtectGroupLogDetail> pgLogs) {
        ExecuteLogBO replicationLog = new ExecuteLogBO();
        replicationLog.setId(logId);
        replicationLog.setProcesses(new ArrayList());
        boolean needCalResult = true;
        for (int index = 0; index < pgLogs.size(); ++index) {
            ProtectGroupLogDetail detail = pgLogs.get(index);
            ExecuteProcessesBO proc = this.initReplicationProc(detail);
            this.updateChildProcInfo(proc, detail.getChildDetails());
            replicationLog.getProcesses().add(proc);
            if (0 == index) {
                replicationLog.setStartTime(proc.getStartTime());
            }
            if ("success".equals(proc.getStatus()) && index == pgLogs.size() - 1) {
                replicationLog.setStatus(proc.getStatus());
                replicationLog.setEndTime(proc.getEndTime());
            }
            if (!"failed".equals(proc.getStatus()) && !"running".equals(proc.getStatus()) || !needCalResult) continue;
            replicationLog.setStatus(proc.getStatus());
            replicationLog.setEndTime(proc.getEndTime());
            needCalResult = false;
        }
        return replicationLog;
    }

    private void updateChildProcInfo(ExecuteProcessesBO proc, List<ProtectGroupLogDetail> pgLogs) {
        proc.setChildProc(new ArrayList());
        if (null == pgLogs) {
            return;
        }
        for (ProtectGroupLogDetail detail : pgLogs) {
            ExecuteProcessesBO childProc = this.initReplicationProc(detail);
            this.updateChildProcInfo(childProc, detail.getChildDetails());
            proc.getChildProc().add(childProc);
        }
    }

    private ExecuteProcessesBO initReplicationProc(ProtectGroupLogDetail detail) {
        ExecuteProcessesBO proc = new ExecuteProcessesBO();
        proc.setChildProc(new ArrayList());
        proc.setProcId(detail.getDetailId());
        proc.setName(detail.getTitle());
        proc.setNameParam((Object[])(null == detail.getTitleParams() ? new String[]{} : detail.getTitleParams().split(";")));
        proc.setStartTime(this.formatUTCTime(detail.getStartTime()));
        proc.setEndTime(this.formatUTCTime(detail.getEndTime()));
        proc.setNote(this.parseProcDetails(detail.getInfo()));
        proc.setNoteParam((Object[])(null == detail.getInfoParams() ? new String[]{} : detail.getInfoParams().split(";")));
        proc.setStatus(this.parseReplicationProcStatus(detail));
        return proc;
    }

    private String formatUTCTime(String timeStr) {
        if (VerifyUtil.isEmpty((String)timeStr) || "--".equals(timeStr)) {
            return "--";
        }
        if (timeStr.contains("UTC")) {
            return timeStr;
        }
        return CommUtil.formatDate((Date)new Date(NumberUtil.convertToLong((Object)timeStr)));
    }

    private String parseReplicationProcStatus(ProtectGroupLogDetail detail) {
        String s = "--";
        long detailResult = detail.getResult();
        if (1L == detailResult) {
            s = "success";
        } else if (0L == detailResult) {
            s = "failed";
        } else if (2L == detailResult) {
            s = "running";
        }
        return s;
    }

    public PageForExecuteLogs queryReplicationLogs(String projectId, String instanceId, int marker, int limit) {
        ServiceInstance serviceInstance;
        logger.info((Object)("query ServiceInstances by projectId , the project id is " + projectId + ", marker : " + marker + ", limit : " + limit));
        this.validateParams(instanceId, projectId);
        if (512 < limit || limit <= 0) {
            limit = 512;
        }
        if (null == (serviceInstance = AbstractServiceInstanceReplicationQueryImpl.queryServiceInstance(instanceId))) {
            logger.error((Object)("Failed to query ServiceInstances by projectId ,serviceInstance is null, instanceId=" + instanceId));
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        this.checkInstanceProjectId(projectId, serviceInstance);
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceInstance.getType())) {
            throw new LegoCheckedException(1073947393L, "instance(" + instanceId + ")'type is not replication.");
        }
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        Page pgLogs = service.pageQueryHistoryLogFromAll(marker / limit, limit, "starttime", false, serviceInstance.getProtectGroupId());
        List replicationLogs = (List)pgLogs.getResult();
        if (VerifyUtil.isEmpty((Collection)replicationLogs)) {
            return new PageForExecuteLogs();
        }
        PageForExecuteLogs pageForReplicationLogs = new PageForExecuteLogs();
        pageForReplicationLogs.setTotalCount((int)pgLogs.getTotalCount());
        pageForReplicationLogs.setLogs(this.buildReplicationLogs(replicationLogs));
        return pageForReplicationLogs;
    }

    private List<ExecuteLogsBO> buildReplicationLogs(List<ProtectGroupLog> replicationLogs) {
        ArrayList<ExecuteLogsBO> logsList = new ArrayList<ExecuteLogsBO>();
        for (ProtectGroupLog replicationLog : replicationLogs) {
            ExecuteLogsBO logBO = new ExecuteLogsBO();
            logBO.setId(replicationLog.getHistoryLogId().toString());
            logBO.setEndTime(OpenStackCommonUtil.formatDate(this.strFormatDate(replicationLog.getEndTime())));
            logBO.setStartTime(OpenStackCommonUtil.formatDate(this.strFormatDate(replicationLog.getStartTime())));
            if (replicationLog.getResult() == 1L) {
                logBO.setStatus("success");
            } else if (replicationLog.getResult() == 0L) {
                logBO.setStatus("failed");
            }
            logsList.add(logBO);
        }
        return logsList;
    }
}

