/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.galax.constant.cloudenum.HostStatusEnum;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PageForVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.FixedIp;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceReplicationQueryImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractServiceInstanceServerQueryImpl
extends AbstractServiceInstanceReplicationQueryImpl {
    private static final Log logger = LogFactory.getInstance(AbstractServiceInstanceServerQueryImpl.class);

    public VmInfoBO queryServer(String projectId, String instanceId, String serverId, boolean queryPhVmInterface) {
        logger.debug((Object)"Query VM by Server Id, the project id is %s the instanceId is %s the server id is %s", new Object[]{projectId, instanceId, serverId});
        this.validateParams(instanceId, projectId);
        if (VerifyUtil.isEmpty((String)serverId)) {
            logger.error((Object)"serverId Id is null");
            throw new LegoCheckedException(1073947393L, "serverId is empty.");
        }
        ServiceInstance instance = AbstractServiceInstanceServerQueryImpl.queryServiceInstance(instanceId);
        this.checkInstanceIsNull(instance, instanceId);
        this.checkInstanceProjectId(projectId, instance);
        FusionSphereOpenStack openstack = this.getOpenstack();
        String moUuid = OpenStackCommonUtil.getObjectUuid(openstack.getUuid(), serverId);
        IProtectGroupService pgServie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectObject protectObject = pgServie.getProtectObjectByMoUUID(instance.getProtectGroupId(), moUuid);
        if (null == protectObject) {
            logger.error((Object)"protectObject is null.");
            throw new LegoCheckedException(201L, "server(" + serverId + ") is not found.");
        }
        VmInfoBO vmTemp = new VmInfoBO();
        vmTemp.setName(protectObject.getName());
        vmTemp.setServerId(serverId);
        if (ProtectObjectStatusEnum.VALID.getValue() == protectObject.getPoStatus()) {
            vmTemp.setStatus(HostStatusEnum.NORMAL.getValue());
        } else {
            vmTemp.setStatus(HostStatusEnum.INVALID.getValue());
        }
        boolean queryInterface = false;
        if (queryPhVmInterface && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instance.getType())) {
            queryInterface = true;
        }
        this.buildRecoverySetting(queryInterface, protectObject.getProtectGroup(), instance, vmTemp, protectObject.getUuid());
        return vmTemp;
    }

    private void checkInstanceIsNull(ServiceInstance instance, String instanceId) {
        if (null == instance) {
            logger.error((Object)"Failed to query serviceInstance.instance is null.instanceId=%s", new Object[]{instanceId});
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
    }

    private void buildRecoverySetting(boolean queryInterface, ProtectGroup pg, ServiceInstance instanceInDB, VmInfoBO vmHostTemp, String poUuid) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instanceInDB.getType())) {
            return;
        }
        if (VerifyUtil.isEmpty((String)instanceInDB.getRecoveryPlanId())) {
            this.getVmRecoverySetting(queryInterface, pg, poUuid, new HashSet<RecoverySetting>(), vmHostTemp);
            return;
        }
        RecoveryPlan recoveryPlan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(instanceInDB.getRecoveryPlanId());
        if (null == recoveryPlan) {
            this.getVmRecoverySetting(queryInterface, pg, poUuid, new HashSet<RecoverySetting>(), vmHostTemp);
            return;
        }
        this.getVmRecoverySetting(queryInterface, pg, poUuid, recoveryPlan.getRecoverySettings(), vmHostTemp);
    }

    private void getVmRecoverySetting(boolean queryInterface, ProtectGroup pg, String poUuid, Set<RecoverySetting> settings, VmInfoBO vmHostTemp) {
        JSONObject jsonObject = new JSONObject();
        String defaultStartPri = "1";
        JSONObject phVmInfo = new JSONObject();
        JSONArray interfaceSet = new JSONArray();
        String startDelayTime = "0";
        for (RecoverySetting rs : settings) {
            if (!poUuid.equals(rs.getOwnerId())) continue;
            if ("PLACEHOLDVM".equals(rs.getName())) {
                phVmInfo.put((Object)"server_id", (Object)OpenStackCommonUtil.getIdFromUuid(rs.getValue()));
                this.constructInterfaces(queryInterface, pg, phVmInfo, rs);
                continue;
            }
            if ("PLACEHOLDVMNAME".equals(rs.getName())) {
                phVmInfo.put((Object)"name", (Object)rs.getValue());
                continue;
            }
            if ("startOrder".equals(rs.getName())) {
                defaultStartPri = rs.getValue();
                continue;
            }
            if ("interface_setting".equals(rs.getName())) {
                interfaceSet = JSONArray.fromObject((Object)rs.getValue());
                continue;
            }
            if (!"start_delay_time".equals(rs.getName())) continue;
            startDelayTime = rs.getValue();
        }
        this.setCshaCSDRPhVMInfo(pg, poUuid, jsonObject);
        jsonObject.put((Object)"occupied_vm", (Object)phVmInfo);
        jsonObject.put((Object)"start_priority", (Object)Integer.parseInt(defaultStartPri));
        jsonObject.put((Object)"start_delay_time", (Object)Integer.parseInt(startDelayTime));
        jsonObject.put((Object)"interface_setting", (Object)interfaceSet);
        vmHostTemp.setRecoverySetting((Object)jsonObject);
    }

    private void constructInterfaces(boolean queryInterface, ProtectGroup pg, JSONObject phVmInfo, RecoverySetting rs) {
        if (null == pg || !queryInterface) {
            return;
        }
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        NovaManager novaMgr = new NovaManager();
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjectUuid);
        List<VMInterface> interfaces = novaMgr.getVmInterfaces(drRegionUuid, drTokenId, drProjectUuid, rs.getValue());
        if (VerifyUtil.isEmpty(interfaces)) {
            return;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        List<OpenStackPort> portList = neutronManager.getPorts(openstackUuid, drRegionUuid, drTokenId, drProjectUuid);
        JSONArray vMInterfaceArray = new JSONArray();
        for (VMInterface vMInterface : interfaces) {
            vMInterface.setPrimaryInterface(OpenStackRecoveryTool.isPrimaryInterfacePort(portList, vMInterface.getPortId()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"mac_addr", (Object)vMInterface.getMacAddr());
            jsonObject.put((Object)"port_id", (Object)vMInterface.getPortId());
            jsonObject.put((Object)"primaryInterface", (Object)vMInterface.isPrimaryInterface());
            JSONArray fixedIpsArray = new JSONArray();
            List fixedIps = vMInterface.getFixedIps();
            if (!VerifyUtil.isEmpty((Collection)fixedIps)) {
                for (FixedIp fixedIp : fixedIps) {
                    JSONObject fixedIpObject = new JSONObject();
                    fixedIpObject.put((Object)"ip_address", (Object)fixedIp.getIpAddress());
                    fixedIpsArray.add((Object)fixedIpObject);
                }
            }
            jsonObject.put((Object)"fixed_ips", (Object)fixedIpsArray);
            vMInterfaceArray.add((Object)jsonObject);
        }
        phVmInfo.put((Object)"interfaces", (Object)vMInterfaceArray);
    }

    private void setCshaCSDRPhVMInfo(ProtectGroup pg, String poUuid, JSONObject jsonObject) {
        if (pg.getTemplate().getType() == 37) {
            for (ProtectObject po : pg.getPolist()) {
                String replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
                if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
                    logger.error((Object)"setCshaCSDRPhVMInfo failed.the vm has no replica info:vmName=%s", new Object[]{po.getName()});
                    continue;
                }
                PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
                if (null == replicaInfo) {
                    logger.error((Object)"setCshaCSDRPhVMInfo failed.the vm has no replica info:vmName=%s", new Object[]{po.getName()});
                    continue;
                }
                if (!po.getUuid().equals(poUuid)) continue;
                PhVmInfo vmInfo = replicaInfo.getPhVmInfo();
                if (VerifyUtil.isEmpty((Object)vmInfo)) {
                    logger.error((Object)"setCshaCSDRPhVMInfo failed.the vm has no placehold vm info:vmName=%s", new Object[]{po.getName()});
                    continue;
                }
                JSONObject cshaPhVmInfo = new JSONObject();
                cshaPhVmInfo.put((Object)"server_id", (Object)OpenStackCommonUtil.getIdFromUuid(vmInfo.getVmUuid()));
                cshaPhVmInfo.put((Object)"name", (Object)vmInfo.getName());
                jsonObject.put((Object)"csha_occupied_vm", (Object)cshaPhVmInfo);
                break;
            }
        }
    }

    public PageForVmInfo queryServers(String projectId, String instanceId, int marker, int limit) {
        logger.info((Object)("query VMList by instance id , the project id is " + projectId + " the instanceId is " + instanceId));
        this.validateParams(instanceId, projectId);
        ServiceInstance instance = AbstractServiceInstanceServerQueryImpl.queryServiceInstance(instanceId);
        if (null == instance) {
            logger.error((Object)"Failed to query servers by instanceID.instance is null.");
            throw new LegoCheckedException(201L, "instance(" + instanceId + ") is not found.");
        }
        this.checkInstanceProjectId(projectId, instance);
        return this.buildVmList(instance, marker, limit);
    }

    private PageForVmInfo buildVmList(ServiceInstance instanceInDB, int marker, int limit) {
        PageForVmInfo pageServers = new PageForVmInfo();
        if (512 < limit || limit <= 0) {
            limit = 512;
        }
        ArrayList<VmInfoBO> vmHostList = new ArrayList<VmInfoBO>();
        if (null == instanceInDB || VerifyUtil.isEmpty((String)instanceInDB.getProtectGroupId())) {
            return pageServers;
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupBasicInfo(instanceInDB.getProtectGroupId(), true);
        if (null == pg || VerifyUtil.isEmpty((Collection)pg.getPolist()) || pg.getPolist().size() <= marker) {
            return pageServers;
        }
        ArrayList sortedPos = new ArrayList();
        sortedPos.addAll(pg.getPolist());
        Collections.sort(sortedPos, Comparator.comparing(ProtectObject::getName));
        List<ProtectObject> objectVMHosts = this.getSubList(marker, limit, sortedPos);
        if (null == objectVMHosts || objectVMHosts.isEmpty()) {
            return pageServers;
        }
        RecoveryPlan recoveryPlan = null;
        if (!VerifyUtil.isEmpty((String)instanceInDB.getRecoveryPlanId())) {
            recoveryPlan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(instanceInDB.getRecoveryPlanId());
        }
        HashSet<RecoverySetting> settings = null == recoveryPlan ? new HashSet() : recoveryPlan.getRecoverySettings();
        List<String> vms = this.buildVmsList(instanceInDB, vmHostList, pg, objectVMHosts, settings);
        this.dealVmsName(instanceInDB, vmHostList, pg, vms);
        pageServers.setServers(vmHostList);
        pageServers.setTotalCount(sortedPos.size());
        return pageServers;
    }

    private List<String> buildVmsList(ServiceInstance instanceInDB, List<VmInfoBO> vmHostList, ProtectGroup pg, List<ProtectObject> objectVMHosts, Set<RecoverySetting> settings) {
        ArrayList<String> vms = new ArrayList<String>();
        for (ProtectObject protectObject : objectVMHosts) {
            JSONObject cshaOccupiedVmObj;
            VmInfoBO vmHostTemp = new VmInfoBO();
            vmHostTemp.setName(protectObject.getName());
            vmHostTemp.setServerId(OpenStackCommonUtil.getIdFromUuid(protectObject.getMoUuid()));
            vmHostTemp.setStatus(ProtectObjectStatusEnum.VALID.getValue() == protectObject.getPoStatus() ? HostStatusEnum.NORMAL.getValue() : HostStatusEnum.INVALID.getValue());
            if (!VerifyUtil.isEmpty((String)((String)protectObject.getProps().get("vm_type")))) {
                vmHostTemp.setVmType((String)protectObject.getProps().get("vm_type"));
            }
            this.buildRecoverySetting(false, pg, instanceInDB, vmHostTemp, protectObject.getUuid());
            vmHostList.add(vmHostTemp);
            vms.add(vmHostTemp.getServerId());
            if (VerifyUtil.isEmpty(settings)) continue;
            JSONObject jsonObject = (JSONObject)vmHostTemp.getRecoverySetting();
            JSONObject occupiedVmObj = jsonObject.getJSONObject("occupied_vm");
            if (!VerifyUtil.isEmpty((Map)occupiedVmObj)) {
                vms.add(occupiedVmObj.getString("server_id"));
            }
            if (VerifyUtil.isEmpty((Map)(cshaOccupiedVmObj = jsonObject.getJSONObject("csha_occupied_vm")))) continue;
            vms.add(cshaOccupiedVmObj.getString("server_id"));
        }
        return vms;
    }

    private void dealVmsName(ServiceInstance instanceInDB, List<VmInfoBO> vmHostList, ProtectGroup pg, List<String> vms) {
        Map<String, String> drVmNameMap;
        if (VerifyUtil.isEmpty(vmHostList) || VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty(vms) || !OpenStackCommonUtil.checkDrNovaStatus(pg)) {
            return;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        Map<String, String> vmNameMap = this.getVmNameMap(vms, vmList);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instanceInDB.getType())) {
            drVmNameMap = vmNameMap;
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instanceInDB.getType())) {
            drVmNameMap = new HashMap<String, String>();
        } else {
            String drRegionUuid = (String)pg.getProps().get("drRegionId");
            String drProjectUuid = (String)pg.getProps().get("drProjectId");
            String drTokenId = TokenUtil.getInstance().getTokenId(drProjectUuid);
            List<OpenStackVM> drVmList = novaMgr.getVms(drRegionUuid, drTokenId, drProjectUuid);
            drVmNameMap = this.getVmNameMap(vms, drVmList);
        }
        this.configVmInfos(vmHostList, vmNameMap, drVmNameMap);
    }

    private Map<String, String> getVmNameMap(List<String> vms, List<OpenStackVM> vmList) {
        HashMap<String, String> vmNameMap = new HashMap<String, String>();
        for (OpenStackVM vm : vmList) {
            if (!vms.contains(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()))) continue;
            vmNameMap.put(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()), vm.getName());
        }
        return vmNameMap;
    }

    private void configVmInfos(List<VmInfoBO> vmHostList, Map<String, String> vmNameMap, Map<String, String> drVmNameMap) {
        for (VmInfoBO vmInfoBO : vmHostList) {
            String cshaOccupiedVmObjName;
            JSONObject cshaOccupiedVmObj;
            String occupiedVmObjName;
            String newName = vmNameMap.get(vmInfoBO.getServerId());
            if (null != newName) {
                vmInfoBO.setName(newName);
            }
            if (VerifyUtil.isEmpty((Object)vmInfoBO.getRecoverySetting())) continue;
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.putAll(vmNameMap);
            nameMap.putAll(drVmNameMap);
            JSONObject jsonObject = (JSONObject)vmInfoBO.getRecoverySetting();
            JSONObject occupiedVmObj = jsonObject.getJSONObject("occupied_vm");
            if (!VerifyUtil.isEmpty((Map)occupiedVmObj) && null != (occupiedVmObjName = (String)nameMap.get(occupiedVmObj.getString("server_id")))) {
                occupiedVmObj.put((Object)"name", (Object)occupiedVmObjName);
            }
            if (VerifyUtil.isEmpty((Map)(cshaOccupiedVmObj = jsonObject.getJSONObject("csha_occupied_vm"))) || null == (cshaOccupiedVmObjName = (String)nameMap.get(cshaOccupiedVmObj.getString("server_id")))) continue;
            cshaOccupiedVmObj.put((Object)"name", (Object)cshaOccupiedVmObjName);
        }
    }
}

