/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.serviceinstance.task.CheckInstanceConfigTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CheckIntanceConfig
extends TimerTask {
    private final Log logger = LogFactory.getInstance(CheckIntanceConfig.class);

    @Override
    public void run() {
        List serviceInsList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ServiceInstance", new Object[0]);
        OpenstackCache.getCacheMap().put(OpenstackCache.CacheType.OPENSTACK_VM_LIST, (Cache<String, Object>)CacheBuilder.newBuilder().expireAfterWrite(1800L, TimeUnit.SECONDS).build());
        OpenstackCache.getCacheMap().put(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, (Cache<String, Object>)CacheBuilder.newBuilder().expireAfterWrite(1800L, TimeUnit.SECONDS).build());
        CountDownLatch cdl = new CountDownLatch(serviceInsList.size());
        for (ServiceInstance one : serviceInsList) {
            if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(one.getStatus())) {
                cdl.countDown();
                this.logger.error((Object)("The inst status is not normal: " + one.getName() + ", " + one.getStatus()));
                continue;
            }
            CheckInstanceConfigTask task = new CheckInstanceConfigTask(one, cdl, false);
            long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
            this.logger.info((Object)("The inst in check: " + taskId));
        }
        try {
            if (cdl.await(1800L, TimeUnit.SECONDS)) {
                this.logger.info((Object)"All auto refresh tasks complete.");
            } else {
                this.logger.info((Object)"Some auto refresh tasks timed out.");
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"Thread interrupted error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(0x200909L);
        }
        OpenstackCache.getCacheMap().remove((Object)OpenstackCache.CacheType.OPENSTACK_VM_LIST);
        OpenstackCache.getCacheMap().remove((Object)OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST);
    }
}

