/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.meter.model.MeterRecord;
import com.huawei.ism.drm.meter.model.SDRRegion;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICeiloMeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.MeterInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VMFlavor;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.serviceinstance.dao.IMeterDao;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class MeterServiceImpl
implements IMeterService {
    private static final Log logger = LogFactory.getInstance(MeterServiceImpl.class);
    private static final String VOLUMES_STATUS_PROTECTED = "PROTECTED";
    private static final String VOLUMES_STATUS_REMOVED = "REMOVED";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.ms";
    private static final String CSDR = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue();
    private static final String CSHA = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue();
    private static final String VHA = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue();
    private static final Set<String> REPORT_CACHE = new HashSet<String>();
    private static final int CACHE_MAX_SIZE = 10;
    private static final long ONE_YEAR_INTERVAL = 31536000000L;
    private IMeterDao meterDao;

    public IMeterDao getMeterDao() {
        return this.meterDao;
    }

    public void setMeterDao(IMeterDao meterDao) {
        this.meterDao = meterDao;
    }

    public void reportAllMeterInfo(String openstackUuid) {
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            if (VerifyUtil.isEmpty((String)openstackUuid)) {
                logger.error((Object)("param is empty, openstackUuid is: " + openstackUuid));
                throw new LegoCheckedException(1073947393L);
            }
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                this.reportAllMeterInfoAfter63(openstackUuid, nameList);
                return;
            }
            this.reportAllMeterInfoBefore63(openstackUuid, nameList);
        }
        catch (Exception e) {
            logger.error((Object)("timer report meterinfo fail, the uuid is " + openstackUuid + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784257L);
            String errMsg = String.join((CharSequence)",", nameList);
            String[] params = new String[]{openstackUuid, errMsg.substring(0, Math.min(errMsg.length(), 1000))};
            AlarmReporter.sendLicenseAlarmForNoRepeat((long)52625473L, (String)openstackUuid, (String)FaultEnum.AlarmResourceType.UNDEFINED.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])params);
        }
    }

    public void reportChangedMeterInfo(String regionId, ServiceInstance instance, String openstackUuid, Map<String, Object> meterInfo) {
        try {
            if (VerifyUtil.isEmpty((Object)instance) || VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)openstackUuid)) {
                logger.error((Object)("param is null ,instance: " + instance + "\uff0cregionId: " + regionId + " ,openstackUuid: " + openstackUuid + "\uff0cupdateProjectInfo failed"));
                throw new LegoCheckedException(1073947393L);
            }
            this.recordChange(instance, meterInfo);
            if (this.checkRegisterOverdue(regionId)) {
                return;
            }
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63() && !ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instance.getType())) {
                logger.debug((Object)("FusionCloud vison is illegal and instance type is: " + instance.getType()));
                return;
            }
            ArrayList<ServiceInstance> instList = new ArrayList<ServiceInstance>();
            instList.add(instance);
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            List pgs = pgService.getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, true);
            if (VerifyUtil.isEmpty((Collection)pgs)) {
                logger.info((Object)("query result is null\uff0c pgs\uff1a" + pgs));
                return;
            }
            HashMap<String, ProtectGroup> pgMap = new HashMap<String, ProtectGroup>();
            for (ProtectGroup pg : pgs) {
                pgMap.put(pg.getUuid(), pg);
            }
            HashMap<String, List<ServiceInstance>> projectMap = new HashMap<String, List<ServiceInstance>>();
            projectMap.put(instance.getProjectId(), instList);
            this.reportProjectInfo(regionId, projectMap, openstackUuid, pgMap);
            AlarmReporter.restoreAlarm((long)52625473L, (String[])new String[]{instance.getId()});
        }
        catch (Exception e) {
            logger.error((Object)("update info to meter fail, id is " + instance.getId() + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            String[] params = new String[]{instance.getId(), instance.getName()};
            AlarmReporter.sendLicenseAlarmForNoRepeat((long)52625473L, (String)instance.getId(), (String)FaultEnum.AlarmResourceType.UNDEFINED.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])params);
        }
    }

    private void recordChange(ServiceInstance instance, Map<String, Object> meterInfo) {
        String reportTime = this.getMapValue(meterInfo, "meter_report_time", String.class);
        if (!REPORT_CACHE.contains(reportTime)) {
            if (REPORT_CACHE.size() > 10) {
                REPORT_CACHE.clear();
            }
            REPORT_CACHE.add(reportTime);
            this.recordInstanceChange(instance, meterInfo);
        }
    }

    public Map<String, Object> calculateMeterInfos(ProtectGroup pg) {
        float instanceNum = 1.0f;
        float volumesSize = 0.0f;
        HashMap<String, Integer> volidMap = new HashMap<String, Integer>();
        if (!VerifyUtil.isEmpty((Object)pg)) {
            for (ProtectObject po : pg.getPolist()) {
                Map<String, Float> volumesMap = this.getVolumesSize(po, volidMap);
                volumesSize += volumesMap.get("csha.vol.size").floatValue();
            }
        }
        HashMap<String, Object> meterInfo = new HashMap<String, Object>();
        meterInfo.put("csha.instance.num", String.valueOf(instanceNum));
        meterInfo.put("csha.vol.size", String.valueOf(volumesSize));
        return meterInfo;
    }

    public void deleteOverdueMeter() {
        this.meterDao.deleteOverdueMeter();
    }

    public void checkInstanceMeterRecords() {
        logger.info((Object)"Begin checkInstanceMeterRecords.");
        List<MeterRecord> recordList = this.meterDao.queryAllMeterRecord();
        HashSet instIdSet = new HashSet();
        recordList.forEach(record -> instIdSet.add(record.getInstanceId()));
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgs = pgService.getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, true);
        HashMap pgMap = new HashMap();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            return;
        }
        pgs.forEach(pg -> pgMap.put(pg.getUuid(), pg));
        HashSet<ServiceInstance> instanceSet = new HashSet<ServiceInstance>(this.queryServiceInstances(null));
        int recordCount = 0;
        for (ServiceInstance instance : instanceSet) {
            ProtectGroup pg2;
            if (instIdSet.contains(instance.getId()) || VerifyUtil.isEmpty((Object)(pg2 = (ProtectGroup)pgMap.get(instance.getProtectGroupId())))) continue;
            ++recordCount;
            Map<String, Object> meterInfos = this.calculateMeterInfos(pg2);
            meterInfos.put("change_type", "inst_create");
            this.recordInstanceChange(instance, meterInfos);
        }
        logger.info((Object)"End checkInstanceMeterRecords. Total instances: %s, recordCount: %s", new Object[]{String.valueOf(pgs.size()), String.valueOf(recordCount)});
    }

    private void reportProjectInfo(String regionId, Map<String, List<ServiceInstance>> projectMap, String openstackUuid, Map<String, ProtectGroup> pgMap) {
        ICeiloMeterManager celio = ManagerFactory.getInstance().getMeterManager(openstackUuid);
        INovaManager nova = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        for (Map.Entry<String, List<ServiceInstance>> entry : projectMap.entrySet()) {
            Map<String, Float> instances;
            HashMap<String, List<MeterInfo>> meterInfoMap = new HashMap<String, List<MeterInfo>>();
            String proId = entry.getKey();
            List<ServiceInstance> instList = entry.getValue();
            String tokenId = TokenUtil.getInstance().getTokenId(openstackUuid + ":" + proId);
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                Map<String, Map<String, Float>> vmFlavorMap = this.constructVmFlavor(nova, regionId, tokenId, proId);
                for (ServiceInstance serviceInstance : instList) {
                    instances = this.buildInstanceFlavorInfo(serviceInstance, vmFlavorMap, pgMap);
                    this.updateMeterInfoMap(meterInfoMap, instances, serviceInstance.getId(), serviceInstance.getName(), proId);
                }
            } else {
                for (ServiceInstance instanceDBInfo : instList) {
                    ProtectGroup protectGroup = pgMap.get(instanceDBInfo.getProtectGroupId());
                    instances = this.buildInstanceInfo(instanceDBInfo, protectGroup, true);
                    this.updateMeterInfoMap(meterInfoMap, instances, instanceDBInfo.getId(), instanceDBInfo.getName(), proId);
                }
            }
            boolean checkRegister = this.checkRegister(regionId);
            for (Map.Entry entry2 : meterInfoMap.entrySet()) {
                String meterName = (String)entry2.getKey();
                try {
                    AsyncTaskResponse response = celio.reportMeterInfo((List)meterInfoMap.get(meterName), meterName, regionId, tokenId);
                    this.handleRequestResult(response.isSuccess(), checkRegister);
                }
                catch (Exception e) {
                    this.handleRequestResult(false, checkRegister);
                }
            }
        }
    }

    private void updateMeterInfoMap(Map<String, List<MeterInfo>> meterInfoMap, Map<String, Float> instances, String instId, String instName, String proId) {
        for (Map.Entry<String, Float> entryMeter : instances.entrySet()) {
            String meterName = entryMeter.getKey();
            if (VerifyUtil.isEmpty((Collection)meterInfoMap.get(meterName))) {
                meterInfoMap.put(meterName, new ArrayList());
            }
            List<MeterInfo> list = meterInfoMap.get(meterName);
            MeterInfo meterInfo = this.createMeterInfo(meterName, instId, instName, instances.get(meterName).floatValue(), proId);
            list.add(meterInfo);
            meterInfoMap.put(meterName, list);
        }
    }

    private Map<String, Map<String, Float>> constructVmFlavor(INovaManager nova, String regionId, String tokenId, String proId) {
        List<OpenStackVM> vmList = nova.getVms(regionId, tokenId, proId);
        List<VMFlavor> vmFlavor = nova.getVmFlavors(regionId, tokenId, proId);
        HashMap<String, Map<String, Float>> vmFlavorMap = new HashMap<String, Map<String, Float>>();
        HashMap flavorMap = new HashMap();
        for (VMFlavor flavor : vmFlavor) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            map.put("csha.cpu.core.num", Float.valueOf(flavor.getVcpus()));
            map.put("csha.mem.size", Float.valueOf(flavor.getRam()));
            flavorMap.put(flavor.getId(), map);
        }
        for (OpenStackVM vm : vmList) {
            String serverID = OpenStackCommonUtil.getIdFromUuid(vm.getUuid());
            vmFlavorMap.put(serverID, (Map<String, Float>)flavorMap.get(vm.getFlavorId()));
        }
        return vmFlavorMap;
    }

    private List<ServiceInstance> queryServiceInstances(String type) {
        List instList;
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getMoDao().getHibernateTemplate();
        try {
            if (null != type) {
                String hql = "from ServiceInstance where type = ?";
                instList = hibernateTemplate.find(hql, (Object[])new String[]{type});
            } else {
                String hql = "from ServiceInstance";
                instList = hibernateTemplate.find(hql, new Object[0]);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to query instance.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return instList;
    }

    private MeterInfo createMeterInfo(String meterName, String instanceId, String instName, float size, String projectId) {
        String projectUuid = OpenStackCommonUtil.getIdFromUuid(projectId);
        String meterUnit = "Number";
        String[] meterInfo = meterName.split("\\.");
        if ("size".equals(meterInfo[meterInfo.length - 1])) {
            meterUnit = "GB";
        }
        MeterInfo metersObj = new MeterInfo();
        metersObj.setCounterName(meterName);
        metersObj.setCounterType("cumulative");
        metersObj.setCounterUnit(meterUnit);
        metersObj.setCounterVolume(size);
        metersObj.setResourceId(instanceId);
        metersObj.setProjectId(projectUuid);
        metersObj.setUserId(projectUuid);
        JSONObject resourceMetadata = new JSONObject();
        resourceMetadata.put((Object)"resource_name", (Object)instName);
        metersObj.setResourceMetadata(resourceMetadata);
        metersObj.setTimestamp(this.getReportTime(DATE_FORMAT));
        return metersObj;
    }

    private String getReportTime(String format) {
        Calendar cal = Calendar.getInstance();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        String date = new SimpleDateFormat(format).format(cal.getTime());
        return date.replace(' ', 'T');
    }

    private Map<String, Float> buildInstanceFlavorInfo(ServiceInstance instanceDBInfo, Map<String, Map<String, Float>> vmFlavorMap, Map<String, ProtectGroup> pgMap) {
        HashMap<String, Float> instances = new HashMap<String, Float>();
        float instanceNum = 0.0f;
        float serverCpuNum = 0.0f;
        float serverRam = 0.0f;
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        ProtectGroup pg = pgMap.get(instanceDBInfo.getProtectGroupId());
        HashMap<String, Integer> volidMap = new HashMap<String, Integer>();
        if (null != pg) {
            for (ProtectObject po : pg.getPolist()) {
                String serverId = OpenStackCommonUtil.getIdFromUuid(po.getMoUuid());
                Map<String, Float> volumesMap = this.getVolumesSize(po, volidMap);
                if (null == vmFlavorMap.get(serverId)) continue;
                serverCpuNum = vmFlavorMap.get(serverId).get("csha.cpu.core.num").floatValue() + serverCpuNum;
                serverRam = vmFlavorMap.get(serverId).get("csha.mem.size").floatValue() + serverRam;
                volumesSize += volumesMap.get("csha.vol.size").floatValue();
                volumesNumber += volumesMap.get("csha.vol.num").floatValue();
            }
            instanceNum = 1.0f;
        }
        instances.put("csha.instance.num", Float.valueOf(instanceNum));
        instances.put("csha.cpu.core.num", Float.valueOf(serverCpuNum));
        instances.put("csha.mem.size", Float.valueOf(serverRam / 1024.0f));
        instances.put("csha.vol.size", Float.valueOf(volumesSize));
        instances.put("csha.vol.num", Float.valueOf(volumesNumber));
        return instances;
    }

    private Map<String, Float> buildInstanceInfo(ServiceInstance instanceDBInfo, ProtectGroup pg, boolean isProductRegion) {
        HashMap<String, Float> instances = new HashMap<String, Float>();
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.debug((Object)("Don't has any protectGroup. serviceInstance name  is" + instanceDBInfo.getName()));
            return instances;
        }
        float volumesSize = 0.0f;
        HashMap<String, Integer> volidMap = new HashMap<String, Integer>();
        for (ProtectObject po : pg.getPolist()) {
            Map<String, Float> volumesMap = this.getVolumesSize(po, volidMap);
            volumesSize += volumesMap.get("csha.vol.size").floatValue();
        }
        float instanceNum = 1.0f;
        String serviceType = instanceDBInfo.getType();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceType)) {
            instances.put("csdr.instance.num", Float.valueOf(instanceNum));
            instances.put("csdr.vol.size", Float.valueOf(volumesSize));
            String regionId = (String)pg.getProps().get("regionId");
            String originalRegionUuid = (String)pg.getProps().get("originalAvailableRegion");
            boolean isOriginalRegion = regionId.equals(originalRegionUuid);
            if (this.isProductOrDisaster(isProductRegion, isOriginalRegion) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue().equals(instanceDBInfo.getProtectType())) {
                instances.put("vha.instance.num", Float.valueOf(instanceNum));
                instances.put("vha.vol.size", Float.valueOf(volumesSize));
            } else if (this.isProductOrDisaster(isProductRegion, isOriginalRegion) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue().equals(instanceDBInfo.getProtectType())) {
                instances.put("csha.instance.num", Float.valueOf(instanceNum));
                instances.put("csha.vol.size", Float.valueOf(volumesSize));
            }
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(serviceType)) {
            if (isProductRegion) {
                instances.put("vha.instance.num", Float.valueOf(instanceNum));
                instances.put("vha.vol.size", Float.valueOf(volumesSize));
            }
        } else if (isProductRegion) {
            instances.put("csha.instance.num", Float.valueOf(instanceNum));
            instances.put("csha.vol.size", Float.valueOf(volumesSize));
        }
        return instances;
    }

    private boolean isProductOrDisaster(boolean isProductRegion, boolean isOriginalRegion) {
        return isOriginalRegion && isProductRegion || !isOriginalRegion && !isProductRegion;
    }

    private Map<String, Float> getVolumesSize(ProtectObject po, Map<String, Integer> volidMap) {
        String replicationInfo;
        PoReplicaInfo poReplicaInfo;
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        HashMap<String, Float> volumesMap = new HashMap<String, Float>();
        if (null != po.getProps() && !po.getProps().isEmpty() && null != (poReplicaInfo = JsonUtil.jsonToBean(replicationInfo = (String)po.getProps().get("replicationInfo"), PoReplicaInfo.class)) && !poReplicaInfo.getPairInfos().isEmpty()) {
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (volidMap.containsKey(pairInfo.getVolumeUuid()) || !VOLUMES_STATUS_PROTECTED.equals(pairInfo.getVolumeStatus()) && !VOLUMES_STATUS_REMOVED.equals(pairInfo.getVolumeStatus())) continue;
                volumesSize = (float)pairInfo.getSize() + volumesSize;
                volumesNumber += 1.0f;
                volidMap.put(pairInfo.getVolumeUuid(), 1);
            }
        }
        volumesMap.put("csha.vol.size", Float.valueOf(volumesSize));
        volumesMap.put("csha.vol.num", Float.valueOf(volumesNumber));
        return volumesMap;
    }

    private void restoreAllAlarm(List<String> proPg) {
        for (String proId : proPg) {
            try {
                AlarmReporter.restoreAlarm((long)52625473L, (String[])new String[]{proId});
            }
            catch (Exception e) {
                logger.error((Object)"restore fault alarm failed.", 90160758786989L);
            }
        }
    }

    private void reportAllMeterInfoBefore63(String openstackUuid, List<String> nameList) {
        ProtectGroup pg2;
        ArrayList<String> sourceId = new ArrayList<String>();
        List<ServiceInstance> instList = this.queryServiceInstances(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue());
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgs = pgService.getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, true);
        if (VerifyUtil.isEmpty(instList) || VerifyUtil.isEmpty((Collection)pgs)) {
            logger.info((Object)("query instance or pgs result is null, instList: " + instList + ", pgs: " + pgs));
            return;
        }
        instList.forEach(inst -> {
            nameList.add(inst.getName());
            sourceId.add(inst.getId());
        });
        HashMap<String, ProtectGroup> pgMap = new HashMap<String, ProtectGroup>();
        for (ProtectGroup pg2 : pgs) {
            pgMap.put(pg2.getUuid(), pg2);
        }
        ServiceInstance instanceInfo = (ServiceInstance)CommonUtil.getFirstElement(instList);
        pg2 = (ProtectGroup)pgMap.get(instanceInfo.getProtectGroupId());
        if (null == pg2) {
            logger.error((Object)("get ProtectGroup return null, group id=" + instanceInfo.getProtectGroupId()));
            throw new LegoCheckedException(1073947393L);
        }
        String regionId = (String)pg2.getProps().get("regionId");
        HashMap<String, List<ServiceInstance>> projectMap = new HashMap<String, List<ServiceInstance>>();
        for (ServiceInstance instanceDBInfo : instList) {
            List<ServiceInstance> list;
            String proId = instanceDBInfo.getProjectId();
            sourceId.add(instanceDBInfo.getId());
            if (projectMap.containsKey(proId)) {
                list = (List)projectMap.get(proId);
                list.add(instanceDBInfo);
                projectMap.put(proId, list);
                continue;
            }
            list = new ArrayList();
            list.add(instanceDBInfo);
            projectMap.put(instanceDBInfo.getProjectId(), list);
        }
        this.reportProjectInfo(regionId, projectMap, openstackUuid, pgMap);
        sourceId.add(openstackUuid);
        this.restoreAllAlarm(sourceId);
        logger.info((Object)"timer report meter success");
    }

    private void reportAllMeterInfoAfter63(String openstackUuid, List<String> nameList) {
        ArrayList<String> sourceId = new ArrayList<String>();
        List<ServiceInstance> instList = this.queryServiceInstances(null);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgs = pgService.getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, true);
        if (VerifyUtil.isEmpty(instList) || VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)("query protectGroups\uff0cpgs\uff1a" + pgs + " or serviceInstance,  instList: " + instList + " is null"));
            return;
        }
        instList.forEach(inst -> {
            nameList.add(inst.getName());
            sourceId.add(inst.getId());
        });
        HashMap<String, ProtectGroup> pgMap = new HashMap<String, ProtectGroup>();
        for (ProtectGroup pg : pgs) {
            pgMap.put(pg.getUuid(), pg);
        }
        HashMap<String, Map<String, Map<String, List<MeterInfo>>>> projectRegionMeterInfoMap = new HashMap<String, Map<String, Map<String, List<MeterInfo>>>>();
        for (ServiceInstance instanceInfo : instList) {
            ProtectGroup pg = (ProtectGroup)pgMap.get(instanceInfo.getProtectGroupId());
            if (null == pg) {
                logger.error((Object)("get ProtectGroup return null, group id=" + instanceInfo.getProtectGroupId()));
                throw new LegoCheckedException(1073947393L);
            }
            String projectUuid = (String)pg.getProps().get("projectId");
            String regionUuid = (String)pg.getProps().get("regionId");
            String drProjectUuid = (String)pg.getProps().get("drProjectId");
            String drRegionUuid = (String)pg.getProps().get("drRegionId");
            if (!this.checkRegisterOverdue(regionUuid)) {
                this.updateMeterInfo(pgMap, projectRegionMeterInfoMap, instanceInfo, projectUuid, regionUuid, true);
            }
            if (this.checkRegisterOverdue(drRegionUuid)) continue;
            this.updateMeterInfo(pgMap, projectRegionMeterInfoMap, instanceInfo, drProjectUuid, drRegionUuid, false);
        }
        this.reportMeterInfo(openstackUuid, projectRegionMeterInfoMap);
        sourceId.add(openstackUuid);
        this.restoreAllAlarm(sourceId);
    }

    private void updateMeterInfo(Map<String, ProtectGroup> pgMap, Map<String, Map<String, Map<String, List<MeterInfo>>>> projectRegionMeterInfoMap, ServiceInstance instanceInfo, String projectUuid, String regionUuid, boolean isProductRegion) {
        Map regionMeterInfoMap = projectRegionMeterInfoMap.computeIfAbsent(projectUuid, key -> new HashMap());
        Map meterInfoMap = regionMeterInfoMap.computeIfAbsent(regionUuid, key -> new HashMap());
        ProtectGroup pg = pgMap.get(instanceInfo.getProtectGroupId());
        Map<String, Float> instances = this.buildInstanceInfo(instanceInfo, pg, isProductRegion);
        this.updateMeterInfoMap(meterInfoMap, instances, instanceInfo.getId(), instanceInfo.getName(), projectUuid);
    }

    private void reportMeterInfo(String openstackUuid, Map<String, Map<String, Map<String, List<MeterInfo>>>> projectRegionMeterInfoMap) {
        String timeStamp = this.getReportTime(DATE_FORMAT);
        ICeiloMeterManager celio = ManagerFactory.getInstance().getMeterManager(openstackUuid);
        for (Map.Entry<String, Map<String, Map<String, List<MeterInfo>>>> projectEntry : projectRegionMeterInfoMap.entrySet()) {
            String projectUuid = projectEntry.getKey();
            String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
            Map<String, Map<String, List<MeterInfo>>> regionMeterInfoMap = projectEntry.getValue();
            this.reportRegionMeter(timeStamp, celio, tokenId, regionMeterInfoMap);
        }
    }

    private void reportRegionMeter(String timeStamp, ICeiloMeterManager celio, String tokenId, Map<String, Map<String, List<MeterInfo>>> regionMeterInfoMap) {
        for (Map.Entry<String, Map<String, List<MeterInfo>>> regionEntry : regionMeterInfoMap.entrySet()) {
            String regionUuid = regionEntry.getKey();
            boolean checkRegister = this.checkRegister(regionUuid);
            Map<String, List<MeterInfo>> meterInfoMap = regionEntry.getValue();
            for (Map.Entry<String, List<MeterInfo>> entryInfo : meterInfoMap.entrySet()) {
                String meterName = entryInfo.getKey();
                List<MeterInfo> metersInfo = meterInfoMap.get(meterName);
                metersInfo.forEach(meterInfo -> meterInfo.setTimestamp(timeStamp));
                try {
                    AsyncTaskResponse response = celio.reportMeterInfo(metersInfo, meterName, regionUuid, tokenId);
                    this.handleRequestResult(response.isSuccess(), checkRegister);
                }
                catch (Exception e) {
                    this.handleRequestResult(false, checkRegister);
                }
            }
        }
    }

    private void handleRequestResult(boolean success, boolean checkRegister) {
        if (success) {
            logger.info((Object)"Report ceilometer success");
        } else if (checkRegister) {
            logger.error((Object)"Report ceilometer faild, and this region is registered");
        } else {
            logger.error((Object)"Report ceilometer faild");
            throw new LegoCheckedException(1073948124L);
        }
    }

    private boolean checkRegister(String regionUuid) {
        List<SDRRegion> list = this.meterDao.querySDRRegion(OpenStackCommonUtil.getIdFromUuid(regionUuid));
        return !VerifyUtil.isEmpty(list);
    }

    private boolean checkRegisterOverdue(String regionUuid) {
        List<SDRRegion> list = this.meterDao.querySDRRegion(OpenStackCommonUtil.getIdFromUuid(regionUuid));
        if (!VerifyUtil.isEmpty(list)) {
            SDRRegion sdrRegion = list.get(0);
            long registerTime = sdrRegion.getRegisterTime();
            long currentTime = System.currentTimeMillis();
            return currentTime - registerTime > 31536000000L;
        }
        return false;
    }

    private void recordInstanceChange(ServiceInstance instance, Map<String, Object> meterInfo) {
        String changeType = this.getMapValue(meterInfo, "change_type", String.class);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = "inst_delete".equals(changeType) ? this.getMapValue(meterInfo, "meter_pg", ProtectGroup.class) : pgService.getProtectGroupByID(instance.getProtectGroupId());
        switch (changeType) {
            case "inst_create": {
                this.recordInstanceCreate(instance, pg, meterInfo);
                break;
            }
            case "inst_update": {
                this.recordInstanceUpdate(instance, pg, meterInfo);
                break;
            }
            case "inst_upgrade": {
                this.recordInstanceUpgrade(instance, pg, meterInfo);
                break;
            }
            case "inst_downgrade": {
                this.recordInstanceDowngrade(instance, pg, meterInfo);
                break;
            }
            case "inst_delete": {
                this.recordInstanceDelete(instance, pg, meterInfo);
                break;
            }
        }
    }

    private void recordInstanceCreate(ServiceInstance instance, ProtectGroup pg, Map<String, Object> meterInfo) {
        String instanceNum = this.getMapValue(meterInfo, "csha.instance.num", String.class);
        String volumesSize = this.getMapValue(meterInfo, "csha.vol.size", String.class);
        ArrayList<MeterRecord> meterRecordList = new ArrayList<MeterRecord>();
        if (this.recordCsdr(instance)) {
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, "0", "0", "meter_create"));
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, instanceNum, volumesSize, "meter_delete_fake"));
        }
        if (this.recordVha(instance)) {
            meterRecordList.addAll(this.buildVHARecords(instance, pg, "0", "0", "meter_create"));
            meterRecordList.addAll(this.buildVHARecords(instance, pg, instanceNum, volumesSize, "meter_delete_fake"));
        }
        if (this.recordCsha(instance)) {
            meterRecordList.addAll(this.buildCSHARecords(instance, pg, "0", "0", "meter_create"));
            meterRecordList.addAll(this.buildCSHARecords(instance, pg, instanceNum, volumesSize, "meter_delete_fake"));
        }
        for (MeterRecord meterRecord : meterRecordList) {
            this.meterDao.storeMeterRecord(meterRecord, null);
        }
    }

    private void recordInstanceUpdate(ServiceInstance instance, ProtectGroup pg, Map<String, Object> meterInfo) {
        String instanceNum = this.getMapValue(meterInfo, "csha.instance.num", String.class);
        String volumesSize = this.getMapValue(meterInfo, "csha.vol.size", String.class);
        ArrayList<MeterRecord> meterRecordList = new ArrayList<MeterRecord>();
        Map<String, Object> meterInfoAfter = this.calculateMeterInfos(pg);
        String instanceNumAfter = this.getMapValue(meterInfoAfter, "csha.instance.num", String.class);
        String volumesSizeAfter = this.getMapValue(meterInfoAfter, "csha.vol.size", String.class);
        ArrayList<MeterRecord> meterRecordListAfter = new ArrayList<MeterRecord>();
        if (this.recordCsdr(instance)) {
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, instanceNum, volumesSize, "meter_update"));
            meterRecordListAfter.addAll(this.buildCSDRRecords(instance, pg, instanceNumAfter, volumesSizeAfter, "meter_update"));
        }
        if (this.recordVha(instance)) {
            meterRecordList.addAll(this.buildVHARecords(instance, pg, instanceNum, volumesSize, "meter_update"));
            meterRecordListAfter.addAll(this.buildVHARecords(instance, pg, instanceNumAfter, volumesSizeAfter, "meter_update"));
        }
        if (this.recordCsha(instance)) {
            meterRecordList.addAll(this.buildCSHARecords(instance, pg, instanceNum, volumesSize, "meter_update"));
            meterRecordListAfter.addAll(this.buildCSHARecords(instance, pg, instanceNumAfter, volumesSizeAfter, "meter_update"));
        }
        if (meterRecordList.size() != meterRecordListAfter.size()) {
            throw new LegoCheckedException(0x300001L);
        }
        for (int i = 0; i < meterRecordList.size(); ++i) {
            this.meterDao.storeMeterRecord((MeterRecord)meterRecordList.get(i), (MeterRecord)meterRecordListAfter.get(i));
        }
    }

    private void recordInstanceUpgrade(ServiceInstance instance, ProtectGroup pg, Map<String, Object> meterInfo) {
        String typeOfChange = this.getMapValue(meterInfo, "up_downgrade_chage", String.class);
        String instanceNum = this.getMapValue(meterInfo, "csha.instance.num", String.class);
        String volumesSize = this.getMapValue(meterInfo, "csha.vol.size", String.class);
        ArrayList<MeterRecord> meterRecordList = new ArrayList<MeterRecord>();
        if (CSDR.equals(typeOfChange)) {
            meterRecordList.addAll(this.buildVHARecords(instance, pg, "0", "0", "meter_create"));
            meterRecordList.addAll(this.buildVHARecords(instance, pg, instanceNum, volumesSize, "meter_delete_fake"));
        }
        if (VHA.equals(typeOfChange)) {
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, "0", "0", "meter_create"));
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, instanceNum, volumesSize, "meter_delete_fake"));
        }
        for (MeterRecord meterRecord : meterRecordList) {
            this.meterDao.storeMeterRecord(meterRecord, null);
        }
    }

    private void recordInstanceDowngrade(ServiceInstance instance, ProtectGroup pg, Map<String, Object> meterInfo) {
        String typeOfChange = this.getMapValue(meterInfo, "up_downgrade_chage", String.class);
        String instanceNum = this.getMapValue(meterInfo, "csha.instance.num", String.class);
        String volumesSize = this.getMapValue(meterInfo, "csha.vol.size", String.class);
        ArrayList<MeterRecord> meterRecordList = new ArrayList<MeterRecord>();
        if (VHA.equals(typeOfChange)) {
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, instanceNum, volumesSize, "meter_delete"));
        }
        if (CSDR.equals(typeOfChange)) {
            meterRecordList.addAll(this.buildVHARecords(instance, pg, instanceNum, volumesSize, "meter_delete"));
        }
        for (MeterRecord meterRecord : meterRecordList) {
            this.meterDao.storeMeterRecord(meterRecord, null);
        }
    }

    private void recordInstanceDelete(ServiceInstance instance, ProtectGroup pg, Map<String, Object> meterInfo) {
        String instanceNum = this.getMapValue(meterInfo, "csha.instance.num", String.class);
        String volumesSize = this.getMapValue(meterInfo, "csha.vol.size", String.class);
        ArrayList<MeterRecord> meterRecordList = new ArrayList<MeterRecord>();
        if (this.recordCsdr(instance)) {
            meterRecordList.addAll(this.buildCSDRRecords(instance, pg, instanceNum, volumesSize, "meter_delete"));
        }
        if (this.recordVha(instance)) {
            meterRecordList.addAll(this.buildVHARecords(instance, pg, instanceNum, volumesSize, "meter_delete"));
        }
        if (this.recordCsha(instance)) {
            meterRecordList.addAll(this.buildCSHARecords(instance, pg, instanceNum, volumesSize, "meter_delete"));
        }
        for (MeterRecord meterRecord : meterRecordList) {
            this.meterDao.storeMeterRecord(meterRecord, null);
        }
    }

    private boolean recordCsdr(ServiceInstance instance) {
        String serviceType = instance.getType();
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceType);
    }

    private boolean recordCsha(ServiceInstance instance) {
        String serviceType = instance.getType();
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(serviceType) || this.recordCsdr(instance) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue().equals(instance.getProtectType());
    }

    private boolean recordVha(ServiceInstance instance) {
        String serviceType = instance.getType();
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(serviceType) || this.recordCsdr(instance) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue().equals(instance.getProtectType());
    }

    private List<MeterRecord> buildCSDRRecords(ServiceInstance instance, ProtectGroup pg, String instanceNum, String volumesSize, String recordType) {
        String regionUuid = (String)pg.getProps().get("regionName");
        String drRegionUuid = (String)pg.getProps().get("drRegionName");
        String instanceName = pg.getName();
        HashMap<String, String> meterMapDel = new HashMap<String, String>();
        meterMapDel.put("csdr.ins", instanceNum);
        meterMapDel.put("csdr.vol", volumesSize);
        ArrayList<MeterRecord> result = new ArrayList<MeterRecord>();
        result.addAll(this.buildMeterRecords(instance, this.commonMeterRecord(regionUuid, CSDR, recordType, instanceName), meterMapDel));
        result.addAll(this.buildMeterRecords(instance, this.commonMeterRecord(drRegionUuid, CSDR, recordType, instanceName), meterMapDel));
        return result;
    }

    private List<MeterRecord> buildVHARecords(ServiceInstance instance, ProtectGroup pg, String instanceNum, String volumesSize, String recordType) {
        String regionUuid = (String)pg.getProps().get("regionName");
        String instanceName = pg.getName();
        HashMap<String, String> meterMapDel = new HashMap<String, String>();
        meterMapDel.put("vha.ins", instanceNum);
        meterMapDel.put("vha.vol", volumesSize);
        return this.buildMeterRecords(instance, this.commonMeterRecord(regionUuid, VHA, recordType, instanceName), meterMapDel);
    }

    private List<MeterRecord> buildCSHARecords(ServiceInstance instance, ProtectGroup pg, String instanceNum, String volumesSize, String recordType) {
        String regionUuid = (String)pg.getProps().get("regionName");
        String instanceName = pg.getName();
        HashMap<String, String> meterMapDel = new HashMap<String, String>();
        meterMapDel.put("csha.ins", instanceNum);
        meterMapDel.put("csha.vol", volumesSize);
        return this.buildMeterRecords(instance, this.commonMeterRecord(regionUuid, CSHA, recordType, instanceName), meterMapDel);
    }

    private MeterRecord commonMeterRecord(String regionId, String instanceType, String recordType, String instanceName) {
        MeterRecord meterRecord = new MeterRecord();
        meterRecord.setRegionId(regionId);
        meterRecord.setInstanceType(instanceType);
        meterRecord.setInstanceName(instanceName);
        if ("meter_delete_fake".equals(recordType)) {
            meterRecord.setRecordTime("99999999999999");
        } else {
            meterRecord.setRecordTime(this.getReportTime("yyyyMMddHHmmss"));
        }
        meterRecord.setRecordType(recordType);
        return meterRecord;
    }

    private List<MeterRecord> buildMeterRecords(ServiceInstance instance, MeterRecord commonRecord, Map<String, String> meterMap) {
        ArrayList<MeterRecord> meterRecordList = new ArrayList<MeterRecord>();
        for (Map.Entry<String, String> entry : meterMap.entrySet()) {
            MeterRecord meterRecord = new MeterRecord();
            meterRecord.setProjectId(instance.getProjectId());
            meterRecord.setRegionId(commonRecord.getRegionId());
            meterRecord.setInstanceType(commonRecord.getInstanceType());
            meterRecord.setInstanceId(instance.getId());
            meterRecord.setInstanceName(commonRecord.getInstanceName());
            if ("meter_delete_fake".equals(commonRecord.getRecordType())) {
                meterRecord.setRecordTime("99999999999999");
            } else {
                meterRecord.setRecordTime(this.getReportTime("yyyyMMddHHmmss"));
            }
            meterRecord.setRecordType(commonRecord.getRecordType());
            meterRecord.setMeterType(entry.getKey());
            meterRecord.setMeterValue(entry.getValue());
            meterRecordList.add(meterRecord);
        }
        return meterRecordList;
    }

    private <T> T getMapValue(Map<String, Object> map, String key, Class<T> classType) {
        Object obj = map.get(key);
        if (classType.equals(obj.getClass())) {
            return classType.cast(obj);
        }
        throw new LegoCheckedException(1073947393L);
    }
}

