/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaBo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VMFlavor;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackProtectionService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.QuotaInfo;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IQuotaService", Desc="", Interface=IQuotaService.class)
public class QuotaServiceImpl
extends BaseService
implements IQuotaService {
    private static Log logger = LogFactory.getInstance(QuotaServiceImpl.class);
    private static final String VOLUMES_STATUS_PROTECTED = "PROTECTED";
    private static final String VOLUMES_STATUS_REMOVED = "REMOVED";
    private static final float QUOTA_NO_LIMIT = -1.0f;
    private static final String ACTION_UPDATE = "update";
    private static final String ACTION_DELETE = "delete";
    private static final String EVS_SERVICE_ID = "evs_service_id";
    private static final Set<String> INSTANCE_NUM = new HashSet<String>(){
        {
            this.add("csha.instance.num");
            this.add("csdr.instance.num");
            this.add("vha.instance.num");
        }
    };
    private static final Set<String> NEW_VERSION_QUOTA = new HashSet<String>(){
        {
            this.add("csdr.vol.num");
            this.add("csdr.vol.size");
            this.add("csdr.instance.num");
            this.add("vha.vol.num");
            this.add("vha.vol.size");
            this.add("vha.instance.num");
        }
    };

    public void updateProjectQuotaInfo(String projectId, List<QuotaBo> quotas) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty(quotas)) {
            logger.error((Object)"Faild to update project quotaInfo.param is null , updateQuotaInfo failed");
            throw new LegoCheckedException(1073947393L);
        }
        List<QuotaInfo> qtList = this.queryQuotaForDb(projectId);
        this.fulfill(quotas, qtList);
        this.checkQuotaBeyondMax(projectId, quotas, qtList);
        List<QuotaInfo> resultlist = null != qtList ? this.updateQuota(projectId, quotas, qtList) : this.constructQuota(projectId, quotas);
        this.changeQuotaInfo(resultlist, ACTION_UPDATE);
    }

    private void fulfill(List<QuotaBo> quotas, List<QuotaInfo> qtList) {
        QuotaBo quota;
        if (!VerifyUtil.isEmpty(quotas)) {
            quota = quotas.get(0);
        } else {
            quota = new QuotaBo();
            quota.setResources(new ArrayList());
            quotas.add(quota);
        }
        List quotaInfoList = Optional.ofNullable(qtList).orElseGet(Collections::emptyList);
        List<String> quotaResourceTypes = this.getAllResourceTypes(quotas);
        quotaInfoList.stream().filter(info -> !quotaResourceTypes.contains(info.getQuotaName())).map(info -> this.constructQuotaResource(info.getQuotaName(), info.getQuota())).forEach(quota.getResources()::add);
        List<String> limited = this.getAllResourceTypes(quotas);
        this.getSupportedResourceTypes().stream().filter(type -> !limited.contains(type)).map(this::constructNoLimitQuotaResource).forEach(quota.getResources()::add);
    }

    private List<String> getAllResourceTypes(List<QuotaBo> quotas) {
        return quotas.stream().flatMap(e -> e.getResources().stream()).map(QuotaResourcesBo::getType).collect(Collectors.toList());
    }

    private QuotaResourcesBo constructNoLimitQuotaResource(String type) {
        return this.constructQuotaResource(type, -1.0f);
    }

    private QuotaResourcesBo constructQuotaResource(String type, float quota) {
        QuotaResourcesBo resource = new QuotaResourcesBo();
        resource.setType(type);
        resource.setQuota(quota);
        return resource;
    }

    private List<String> getSupportedResourceTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (String serviceType : OpenstackConsts.SUPPORTED_SERVICE_TYPES) {
            OpenstackConsts.ALLOWED_RESOURCE_TYPE.forEach(resourceType -> types.add(serviceType + "." + resourceType));
        }
        return types;
    }

    private void changeQuotaInfo(List<QuotaInfo> resultlist, String action) {
        try {
            if (action.equals(ACTION_UPDATE)) {
                resultlist.stream().filter(e -> e.getQuota() < 0.0f).forEach(e -> e.setQuota(-1.0f));
                CommonDAOLocator.getBaseDao().saveOrUpdateAll(resultlist);
            } else if (action.equals(ACTION_DELETE)) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(resultlist);
            }
        }
        catch (DataAccessException e2) {
            logger.error((Object)("failed to change quota.action=" + action), (Throwable)e2, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e2);
        }
    }

    private List<QuotaInfo> constructQuota(String projectId, List<QuotaBo> quotas) {
        ArrayList<QuotaInfo> qtList = new ArrayList<QuotaInfo>();
        for (QuotaBo quota : quotas) {
            for (QuotaResourcesBo resource : quota.getResources()) {
                qtList.add(this.createNewQuotaInfo(projectId, resource.getType(), resource.getQuota()));
            }
        }
        return qtList;
    }

    private List<QuotaInfo> updateQuota(String projectId, List<QuotaBo> quotas, List<QuotaInfo> qtList) {
        ArrayList<QuotaInfo> resultList = new ArrayList<QuotaInfo>();
        HashMap<String, QuotaInfo> quotaMap = new HashMap<String, QuotaInfo>();
        Map<String, Float> quotaUsed = this.queryProjectQuotaUsedInfo(projectId);
        for (QuotaInfo qt : qtList) {
            quotaMap.put(qt.getQuotaName(), qt);
        }
        for (QuotaBo quota : quotas) {
            for (QuotaResourcesBo resource : quota.getResources()) {
                float used = quotaUsed.get(resource.getType()).floatValue();
                if (resource.getQuota() >= 0.0f && resource.getQuota() < used) {
                    logger.error((Object)("set projectId(" + projectId + ")quota too small , quotaused is: " + used + " setquota is: " + resource.getQuota()));
                    throw new LegoCheckedException(1073947393L);
                }
                if (quotaMap.containsKey(resource.getType())) {
                    QuotaInfo oldQt = (QuotaInfo)quotaMap.get(resource.getType());
                    oldQt.setQuota(resource.getQuota());
                    resultList.add(oldQt);
                    continue;
                }
                QuotaInfo newQt = this.createNewQuotaInfo(projectId, resource.getType(), resource.getQuota());
                resultList.add(newQt);
            }
        }
        return resultList;
    }

    private QuotaInfo createNewQuotaInfo(String projectId, String type, float quota) {
        float used = 0.0f;
        String quotaUnit = "Number";
        String[] typeInfo = type.split("\\.");
        if ("size".equals(typeInfo[typeInfo.length - 1])) {
            quotaUnit = "GB";
        }
        QuotaInfo quotaInfo = new QuotaInfo();
        quotaInfo.setId(UUIDGenerator.getUUID());
        quotaInfo.setProjectId(projectId);
        quotaInfo.setQuotaName(type);
        quotaInfo.setQuotaUnit(quotaUnit);
        quotaInfo.setQuota(quota);
        quotaInfo.setQuotaUsed(used);
        return quotaInfo;
    }

    public JSONArray queryProjectQuotaInfo(String projectId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)"param is null , queryQuotaInfo failed");
            throw new LegoCheckedException(1073947393L);
        }
        List<QuotaInfo> qtList = this.queryQuotaForDb(projectId);
        if (null == qtList) {
            logger.info((Object)("Query project quotaInfo is null. by projectid=" + projectId));
            return null;
        }
        this.updateOldtoNewQuota(qtList, projectId);
        Map<String, Float> quotaUsed = this.queryProjectQuotaUsedInfo(projectId);
        JSONArray resources = new JSONArray();
        for (QuotaInfo qt : qtList) {
            JSONObject qouta = new JSONObject();
            qouta.put((Object)"type", (Object)qt.getQuotaName());
            qouta.put((Object)"unit", (Object)qt.getQuotaUnit());
            qouta.put((Object)"quota", (Object)Float.valueOf(qt.getQuota()));
            qouta.put((Object)"used", (Object)quotaUsed.get(qt.getQuotaName()));
            resources.add((Object)qouta);
        }
        JSONObject resour = new JSONObject();
        resour.put((Object)"resources", (Object)resources);
        JSONArray quotas = new JSONArray();
        quotas.add((Object)resour);
        return quotas;
    }

    private List<QuotaInfo> queryQuotaForDb(String projectId) {
        List qtList;
        try {
            if (null != projectId) {
                String hql = "from QuotaInfo where projectId = ?";
                qtList = CommonDAOLocator.getBaseDao().find(hql, (Object[])new String[]{projectId});
            } else {
                String hql = "from QuotaInfo";
                qtList = CommonDAOLocator.getBaseDao().find(hql, new Object[0]);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to query quota by projectId=" + projectId), (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (qtList.size() == 0) {
            logger.info((Object)("query quota is zero. by projectId=" + projectId));
            return null;
        }
        return qtList;
    }

    private void updateOldtoNewQuota(List<QuotaInfo> qtList, String projectId) {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            ArrayList<QuotaInfo> deleteList = new ArrayList<QuotaInfo>();
            for (QuotaInfo info : qtList) {
                if (!"csha.cpu.core.num".equals(info.getQuotaName()) && !"csha.mem.size".equals(info.getQuotaName())) continue;
                deleteList.add(info);
            }
            qtList.removeAll(deleteList);
            if (!VerifyUtil.isEmpty(deleteList)) {
                this.changeQuotaInfo(deleteList, ACTION_DELETE);
            }
            if (qtList.size() == 3) {
                for (QuotaInfo info : qtList) {
                    info.setQuota(0.0f);
                }
                for (String quotaName : NEW_VERSION_QUOTA) {
                    QuotaInfo addQuota = this.createNewQuotaInfo(projectId, quotaName, 0.0f);
                    qtList.add(addQuota);
                }
                this.changeQuotaInfo(qtList, ACTION_UPDATE);
            }
        }
    }

    private Map<String, Float> queryProjectQuotaUsedInfo(String projectId) {
        List<ServiceInstance> instList;
        Map<String, Float> quotaUsed = new HashMap<String, Float>();
        quotaUsed.put("csha.instance.num", Float.valueOf(0.0f));
        quotaUsed.put("csha.vol.size", Float.valueOf(0.0f));
        quotaUsed.put("csha.vol.num", Float.valueOf(0.0f));
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            quotaUsed.put("csdr.instance.num", Float.valueOf(0.0f));
            quotaUsed.put("csdr.vol.size", Float.valueOf(0.0f));
            quotaUsed.put("csdr.vol.num", Float.valueOf(0.0f));
            quotaUsed.put("vha.instance.num", Float.valueOf(0.0f));
            quotaUsed.put("vha.vol.size", Float.valueOf(0.0f));
            quotaUsed.put("vha.vol.num", Float.valueOf(0.0f));
            instList = this.queryServiceInstances(null, projectId);
        } else {
            quotaUsed.put("csha.cpu.core.num", Float.valueOf(0.0f));
            quotaUsed.put("csha.mem.size", Float.valueOf(0.0f));
            instList = this.queryServiceInstances("hypermetro", projectId);
        }
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
        String openstackUuid = openstack.getUuid();
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)("param is empty, openstackUuid is: " + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgs = pgService.getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, true);
        if (VerifyUtil.isEmpty(instList) || VerifyUtil.isEmpty((Collection)pgs)) {
            logger.info((Object)"query result is null");
            return quotaUsed;
        }
        HashMap<String, ProtectGroup> pgMap = new HashMap<String, ProtectGroup>();
        for (ProtectGroup pg : pgs) {
            pgMap.put(pg.getUuid(), pg);
        }
        quotaUsed = OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? this.construcNewProjectQuotaUsedInfo(instList, pgMap) : this.construcProjectQuotaUsedInfo(instList, pgMap, openstackUuid, projectId);
        return quotaUsed;
    }

    private Map<String, Float> construcNewProjectQuotaUsedInfo(List<ServiceInstance> instList, Map<String, ProtectGroup> pgMap) {
        HashMap<String, Float> quotaUsed = new HashMap<String, Float>();
        float cshaInstanceNum = 0.0f;
        float cshaVolSize = 0.0f;
        float cshaVolNumber = 0.0f;
        float csdrInstanceNum = 0.0f;
        float csdrVolSize = 0.0f;
        float csdrVolNumber = 0.0f;
        float vhaInstanceNum = 0.0f;
        float vhaVolSize = 0.0f;
        float vhaVolNumber = 0.0f;
        for (ServiceInstance instanceDBInfo : instList) {
            String type = instanceDBInfo.getType();
            float volumesSize = 0.0f;
            float volumesNumber = 0.0f;
            ProtectGroup pg = pgMap.get(instanceDBInfo.getProtectGroupId());
            HashMap<String, Integer> volidMap = new HashMap<String, Integer>();
            if (null != pg) {
                for (ProtectObject po : pg.getPolist()) {
                    Map<String, Float> volumesMap = this.getVolumesSize(pg, po, volidMap);
                    volumesSize += volumesMap.get("csha.vol.size").floatValue();
                    volumesNumber += volumesMap.get("csha.vol.num").floatValue();
                }
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(type)) {
                csdrVolSize += volumesSize;
                csdrVolNumber += volumesNumber;
                csdrInstanceNum += 1.0f;
                if (pg != null && 34 == pg.getTemplate().getType()) {
                    vhaVolSize += volumesSize;
                    vhaVolNumber += volumesNumber;
                    vhaInstanceNum += 1.0f;
                }
                if (pg == null || 37 != pg.getTemplate().getType()) continue;
                cshaVolSize += volumesSize;
                cshaVolNumber += volumesNumber;
                cshaInstanceNum += 1.0f;
                continue;
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(type)) {
                cshaVolSize += volumesSize;
                cshaVolNumber += volumesNumber;
                cshaInstanceNum += 1.0f;
                continue;
            }
            if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(type)) continue;
            vhaVolSize += volumesSize;
            vhaVolNumber += volumesNumber;
            vhaInstanceNum += 1.0f;
        }
        quotaUsed.put("csha.instance.num", Float.valueOf(cshaInstanceNum));
        quotaUsed.put("csha.vol.size", Float.valueOf(cshaVolSize));
        quotaUsed.put("csha.vol.num", Float.valueOf(cshaVolNumber));
        quotaUsed.put("csdr.instance.num", Float.valueOf(csdrInstanceNum));
        quotaUsed.put("csdr.vol.size", Float.valueOf(csdrVolSize));
        quotaUsed.put("csdr.vol.num", Float.valueOf(csdrVolNumber));
        quotaUsed.put("vha.instance.num", Float.valueOf(vhaInstanceNum));
        quotaUsed.put("vha.vol.size", Float.valueOf(vhaVolSize));
        quotaUsed.put("vha.vol.num", Float.valueOf(vhaVolNumber));
        return quotaUsed;
    }

    private Map<String, Float> construcProjectQuotaUsedInfo(List<ServiceInstance> instList, Map<String, ProtectGroup> pgMap, String openstackUuid, String projectId) {
        String tokenId = TokenUtil.getInstance().getTokenId(openstackUuid + ":" + projectId);
        HashMap<String, Float> quotaUsed = new HashMap<String, Float>();
        float instanceNum = 0.0f;
        float serverCpuNum = 0.0f;
        float serverRam = 0.0f;
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        HashMap<String, List> regionMap = new HashMap<String, List>();
        for (ServiceInstance serviceInstance : instList) {
            ProtectGroup pg = pgMap.get(serviceInstance.getProtectGroupId());
            String regionId = (String)pg.getProps().get("regionId");
            if (regionMap.containsKey(regionId)) {
                List list = (List)regionMap.get(regionId);
                list.add(serviceInstance);
                regionMap.put(regionId, list);
                continue;
            }
            ArrayList<ServiceInstance> firstList = new ArrayList<ServiceInstance>();
            firstList.add(serviceInstance);
            regionMap.put(regionId, firstList);
        }
        for (Map.Entry entry : regionMap.entrySet()) {
            String regionId = (String)entry.getKey();
            List list = (List)entry.getValue();
            Map<String, Map<String, Float>> vmFlavorMap = this.queryVmInfo(openstackUuid, regionId, tokenId, projectId);
            for (ServiceInstance instanceDBInfo : list) {
                Map<String, Float> instances = this.buildInstanceFlavorInfo(instanceDBInfo, vmFlavorMap, pgMap);
                instanceNum += instances.get("csha.instance.num").floatValue();
                serverCpuNum += instances.get("csha.cpu.core.num").floatValue();
                serverRam += instances.get("csha.mem.size").floatValue();
                volumesSize += instances.get("csha.vol.size").floatValue();
                volumesNumber += instances.get("csha.vol.num").floatValue();
            }
        }
        quotaUsed.put("csha.instance.num", Float.valueOf(instanceNum));
        quotaUsed.put("csha.cpu.core.num", Float.valueOf(serverCpuNum));
        quotaUsed.put("csha.mem.size", Float.valueOf(serverRam));
        quotaUsed.put("csha.vol.size", Float.valueOf(volumesSize));
        quotaUsed.put("csha.vol.num", Float.valueOf(volumesNumber));
        return quotaUsed;
    }

    public String checkCreateInstanceOutOfQuota(String projectId, ProtectGroup pg) {
        String result = null;
        try {
            if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)pg)) {
                logger.error((Object)"param is null , checkCreateInstanceOutOfQuota failed");
                throw new LegoCheckedException(1073947393L);
            }
            String type = (String)pg.getProps().get("serviceInstanceType");
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63() && !"hypermetro".equals(type)) {
                return null;
            }
            if (this.checkQuotaUnable(projectId, type)) {
                return null;
            }
            String regionUuid = (String)pg.getProps().get("regionId");
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            Set protectObjectSet = pg.getPolist();
            Map<Object, Object> instances = new HashMap();
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                List<QuotaResourcesBo> list = this.countAddSourceQuota(protectObjectSet, volMap, type, true, pg, null);
                for (QuotaResourcesBo bo : list) {
                    instances.put(bo.getType(), Float.valueOf(bo.getQuota()));
                }
            } else {
                Map<String, Map<String, Float>> vmFlavorMap = this.queryVmInfo(openstackUuid, regionUuid, tokenId, projectId);
                instances = this.getServersAddQuota(protectObjectSet, vmFlavorMap, volMap);
                instances.put("csha.instance.num", Float.valueOf(1.0f));
            }
            result = this.compareQuota(instances, projectId);
        }
        catch (Exception e) {
            logger.error((Object)("check create instance out of quota fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return result;
    }

    public String checkAddServerOutOfQuota(String instanceId, Set<ProtectObject> protectObjectSet) {
        String result = null;
        try {
            if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty(protectObjectSet)) {
                logger.error((Object)"Param is null , checkAddServerOutOfQuota failed.");
                throw new LegoCheckedException(1073947393L);
            }
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
            if (VerifyUtil.isEmpty((Object)instance) || !"hypermetro".equals(instance.getType())) {
                return null;
            }
            String projectId = instance.getProjectId();
            if (this.checkQuotaUnable(projectId, instance.getProtectType())) {
                return null;
            }
            ProtectGroup pg = ((IOpenStackProtectionService)ServiceLocator.getInstance().getService(IOpenStackProtectionService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            if (null == pg) {
                logger.error((Object)"Get instance(%s) protect group info error.", new Object[]{instanceId});
                return null;
            }
            String regionUuid = (String)pg.getProps().get("regionId");
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            HashMap<String, Float> servers = new HashMap();
            String type = (String)pg.getProps().get("serviceInstanceType");
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                List<QuotaResourcesBo> list = this.countAddSourceQuota(protectObjectSet, volMap, type, false, pg, null);
                for (QuotaResourcesBo bo : list) {
                    servers.put(bo.getType(), Float.valueOf(bo.getQuota()));
                }
            } else {
                Map<String, Map<String, Float>> vmFlavorMap = this.queryVmInfo(openstackUuid, regionUuid, tokenId, projectId);
                servers = this.getServersAddQuota(protectObjectSet, vmFlavorMap, volMap);
            }
            result = this.compareQuota(servers, projectId);
        }
        catch (Exception e) {
            logger.error((Object)"Check add server out of quota fail : %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return result;
    }

    private Map<String, Float> getServersAddQuota(Set<ProtectObject> protectObjectSet, Map<String, Map<String, Float>> vmFlavorMap, Map<String, Float> volMap) {
        HashMap<String, Float> instances = new HashMap<String, Float>();
        float serverCpuNum = 0.0f;
        float serverRam = 0.0f;
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        for (ProtectObject po : protectObjectSet) {
            String serverId = OpenStackCommonUtil.getIdFromUuid(po.getMoUuid());
            if (null == vmFlavorMap.get(serverId)) continue;
            JSONArray vols = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            Iterator iterator = vols.iterator();
            while (iterator.hasNext()) {
                JSONObject volInfo = JSONObject.fromObject(iterator.next());
                String volId = OpenStackCommonUtil.getIdFromUuid(volInfo.get("volumeId").toString());
                if (null == volMap.get(volId)) continue;
                volumesSize = volMap.get(volId).floatValue() + volumesSize;
                volumesNumber += 1.0f;
            }
            serverCpuNum = vmFlavorMap.get(serverId).get("csha.cpu.core.num").floatValue() + serverCpuNum;
            serverRam = vmFlavorMap.get(serverId).get("csha.mem.size").floatValue() + serverRam;
        }
        instances.put("csha.cpu.core.num", Float.valueOf(serverCpuNum));
        instances.put("csha.mem.size", Float.valueOf(serverRam / 1024.0f));
        instances.put("csha.vol.size", Float.valueOf(volumesSize));
        instances.put("csha.vol.num", Float.valueOf(volumesNumber));
        return instances;
    }

    public String checkAddVolumesOutOfQuota(String projectId, ProtectGroup pg, Set<ProtectedVolumeInfo> addVolumes) {
        String result = null;
        try {
            if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty(addVolumes)) {
                logger.error((Object)"param is null , checkAddServerOutOfQuota failed");
                throw new LegoCheckedException(1073947393L);
            }
            String type = (String)pg.getProps().get("serviceInstanceType");
            if (!"hypermetro".equals(type)) {
                return result;
            }
            if (this.checkQuotaUnable(projectId, type)) {
                return result;
            }
            String regionUuid = (String)pg.getProps().get("regionId");
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            HashMap<String, Float> volumesMap = new HashMap<String, Float>();
            float volumesSize = 0.0f;
            float volumesNumber = 0.0f;
            for (ProtectedVolumeInfo volumeInfo : addVolumes) {
                String volumeUuid = volumeInfo.getVolumeId();
                String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
                volumesSize = volMap.get(volumeId).floatValue() + volumesSize;
                volumesNumber += 1.0f;
            }
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                List<QuotaResourcesBo> list = this.createQuotaInfo(type, volumesSize, volumesNumber, false);
                for (QuotaResourcesBo bo : list) {
                    volumesMap.put(bo.getType(), Float.valueOf(bo.getQuota()));
                }
            } else {
                volumesMap.put("csha.vol.size", Float.valueOf(volumesSize));
                volumesMap.put("csha.vol.num", Float.valueOf(volumesNumber));
            }
            result = this.compareQuota(volumesMap, projectId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"check add volume out of quota fail. ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("check add volume out of quota fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return result;
    }

    public List<QuotaResourcesBo> calculateCreateInstanceQuota(String projectId, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"param is null , calculateCreateInstanceQuota failed");
            throw new LegoCheckedException(1073947393L);
        }
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
        String openstackUuid = openstack.getUuid();
        String type = (String)pg.getProps().get("serviceInstanceType");
        String regionId = (String)pg.getProps().get("regionId");
        String drRegionId = (String)pg.getProps().get("drRegionId");
        String drProjId = (String)pg.getProps().get("drProjectId");
        String regionUuid = openstackUuid + ":" + OpenStackBasicUtil.getIdFromUuid(regionId);
        String projUuid = openstackUuid + ":" + projectId;
        String drRegionUuid = openstackUuid + ":" + OpenStackBasicUtil.getIdFromUuid(drRegionId);
        String drProjUuid = openstackUuid + ":" + OpenStackBasicUtil.getIdFromUuid(drProjId);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
        Set protectObjectSet = pg.getPolist();
        List<QuotaResourcesBo> instanceQuota = this.countAddSourceQuota(protectObjectSet, volMap, type, true, pg, null);
        return this.addPhVmVolQuota(openstackUuid, drRegionUuid, drProjUuid, protectObjectSet, type, instanceQuota);
    }

    private List<QuotaResourcesBo> countAddSourceQuota(Set<ProtectObject> protectObjectSet, Map<String, Float> volMap, String type, boolean isCreateIns, ProtectGroup pg, Set<String> oldvolIds) {
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        Set<Object> volIds = new HashSet();
        if (!VerifyUtil.isEmpty(oldvolIds)) {
            volIds = oldvolIds;
        }
        if (!VerifyUtil.isEmpty((String)pg.getProperty("BEFORE_UPGRADE_TYPE"))) {
            return this.countUpgradeSourceQuota(pg, volMap);
        }
        Map<String, OpenStackVM> vmMap = this.getRegionVmMap(pg);
        boolean hasShareVol = false;
        for (ProtectObject po : protectObjectSet) {
            if (po.getProtectGroup() == null) {
                po.setProtectGroup(pg);
            }
            boolean isBareMetalServer = OpenStackCommonUtil.isBareMetalServer(vmMap.get(po.getMoUuid()));
            String poReplicaInfoStr = po.getProperty("replicationInfo");
            JSONArray vols = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (Object vol : vols) {
                JSONObject volInfo = JSONObject.fromObject(vol);
                if (isBareMetalServer && !VerifyUtil.isEmpty((String)poReplicaInfoStr) && this.isSkipCountAddQuota(volInfo, pg)) continue;
                String volId = OpenStackCommonUtil.getIdFromUuid(volInfo.get("volumeId").toString());
                if (volIds.contains(volId)) {
                    hasShareVol = true;
                    continue;
                }
                if (null == volMap.get(volId)) {
                    logger.error((Object)("calculateQuota failed, vol is miss, volid: " + volId));
                    throw new LegoCheckedException(1073947393L);
                }
                volumesSize = volMap.get(volId).floatValue() + volumesSize;
                volumesNumber += 1.0f;
                volIds.add(volId);
            }
        }
        if (!hasShareVol && VerifyUtil.isEmpty((String)pg.getProperty("BEFORE_UPGRADE_TYPE"))) {
            this.checkAddVolumesNumber(type, volumesNumber);
        }
        return this.createQuotaInfo(type, volumesSize, volumesNumber, isCreateIns);
    }

    private Map<String, OpenStackVM> getRegionVmMap(ProtectGroup pg) {
        String regionUuid = (String)pg.getProps().get("regionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String projectId = (String)pg.getProps().get("projectId");
        String tokenId = TokenUtil.getInstance().getTokenId(projectId);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectId);
        HashMap<String, OpenStackVM> vmMap = new HashMap<String, OpenStackVM>();
        for (OpenStackVM vm : vmList) {
            vmMap.put(vm.getUuid(), vm);
        }
        return vmMap;
    }

    private List<QuotaResourcesBo> countUpgradeSourceQuota(ProtectGroup pg, Map<String, Float> volMap) {
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        HashSet<String> volIds = new HashSet<String>();
        ServiceInstance serviceInstance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)pg.getProperty("SERVICEINSTANCE_UUID")));
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup oldPg = pgService.getProtectGroupByID(serviceInstance.getProtectGroupId(), false);
        for (ProtectObject po : oldPg.getPolist()) {
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
                String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid());
                if (volIds.contains(volId)) {
                    logger.info((Object)("calculateQuota volid: " + volId + " is share volume"));
                    continue;
                }
                if (null == volMap.get(volId)) {
                    logger.error((Object)("calculateQuota failed, vol is miss, volid: " + volId));
                    throw new LegoCheckedException(1073947393L);
                }
                volumesSize = volMap.get(volId).floatValue() + volumesSize;
                volumesNumber += 1.0f;
                volIds.add(volId);
            }
        }
        String type = pg.getProperty("serviceInstanceType");
        return this.createQuotaInfo(type, volumesSize, volumesNumber, true);
    }

    private boolean isSkipCountAddQuota(JSONObject volInfo, ProtectGroup pg) {
        if (!volInfo.containsKey((Object)"drVolumeType")) {
            return true;
        }
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || volInfo.containsKey((Object)"drHyperVolumeType"))) {
            return true;
        }
        return VerifyUtil.isEmpty((String)volInfo.getString("drVolumeType")) || volInfo.containsKey((Object)"drHyperVolumeType") && VerifyUtil.isEmpty((String)volInfo.getString("drHyperVolumeType"));
    }

    public List<QuotaResourcesBo> calculateAddServerQuota(String instanceId, Set<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty(protectObjectSet)) {
            logger.error((Object)"Failed to calculate add ServerQuota.param is null ,calculateAddServerQuota failed");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (VerifyUtil.isEmpty((Object)instance)) {
            logger.error((Object)("Failed to calculate add ServerQuota.instance is null , calculateAddServerQuota failed, instance id: " + instanceId));
            throw new LegoCheckedException(1073947393L);
        }
        String projectId = instance.getProjectId();
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String regionUuid = (String)pg.getProps().get("regionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String projUuid = openstackUuid + ":" + projectId;
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String type = (String)pg.getProps().get("serviceInstanceType");
        Set<String> oldvolIds = OpenStackCommonUtil.getVolIdsOfProtectObjects(pg.getPolist(), true);
        List<QuotaResourcesBo> instanceQuota = this.countAddSourceQuota(protectObjectSet, volMap, type, false, pg, oldvolIds);
        return this.addPhVmVolQuota(openstackUuid, drRegionUuid, drProjUuid, protectObjectSet, type, instanceQuota);
    }

    public List<QuotaResourcesBo> calculateAddVolumesQuota(String instanceId, Set<ProtectedVolumeInfo> addVolumes) {
        if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty(addVolumes)) {
            logger.error((Object)"param is null , calculateAddVolumesQuota failed");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (VerifyUtil.isEmpty((Object)instance)) {
            logger.error((Object)("instance is null , calculateAddServerQuota failed, instance id: " + instanceId));
            throw new LegoCheckedException(1073947393L);
        }
        String projectId = instance.getProjectId();
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String regionUuid = (String)pg.getProps().get("regionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String projUuid = openstackUuid + ":" + projectId;
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
        String type = (String)pg.getProps().get("serviceInstanceType");
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        for (ProtectedVolumeInfo volumeInfo : addVolumes) {
            String volumeUuid = volumeInfo.getVolumeId();
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            volumesSize = volMap.get(volumeId).floatValue() + volumesSize;
            volumesNumber += 1.0f;
        }
        this.checkAddVolumesNumber(type, volumesNumber);
        return this.createQuotaInfo(type, volumesSize, volumesNumber, false);
    }

    public String calculateDeleteInstanceQuota(String instanceId) {
        try {
            if (VerifyUtil.isEmpty((String)instanceId)) {
                logger.error((Object)"param is null , calculateDeleteInstance failed");
                throw new LegoCheckedException(1073947393L);
            }
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
            if (VerifyUtil.isEmpty((Object)instance)) {
                logger.error((Object)("instance is null , calculateDeleteInstance failed, instance id: " + instanceId));
                throw new LegoCheckedException(1073947393L);
            }
            String projectId = instance.getProjectId();
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            String regionUuid = (String)pg.getProps().get("regionId");
            String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
            String drRegionId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
            String drProjectId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drProjectId"));
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            String type = (String)pg.getProps().get("serviceInstanceType");
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            List<QuotaResourcesBo> quotaList = this.countDelSourceQuota(pg.getPolist(), volMap, type, true);
            List<QuotaResourcesBo> noBootQuotaList = this.countDelSourceQuotaNoBootVolume(pg.getPolist(), volMap, type, true);
            boolean isCsdrVhaMode = OpenStackBasicUtil.isCsdrVhaMode(pg);
            JSONArray array = this.constructQuotaResult(type, new String[]{projectId, regionId}, new String[]{drProjectId, drRegionId}, quotaList, isCsdrVhaMode);
            String drAzid = (String)pg.getProps().get("drZoneName");
            String azid = (String)pg.getProps().get("zoneName");
            if (isCsdrVhaMode && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type)) {
                azid = drAzid;
                projectId = drProjectId;
                regionId = drRegionId;
            } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
                azid = (String)pg.getProps().get("prod_region_drZoneName");
                if (isCsdrVhaMode) {
                    projectId = drProjectId;
                    regionId = drRegionId;
                }
            }
            JSONArray evsArray = this.constructEvsQuota(type, new String[]{drProjectId, drRegionId, drAzid}, new String[]{projectId, regionId, azid}, noBootQuotaList);
            array.addAll((Collection)evsArray);
            logger.info((Object)"delete instance quota message: %s", new Object[]{array.toString()});
            return array.toString();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("calculate Delete Instance fail.instanceId=" + instanceId), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("calculate Delete Instance fail.instanceId=" + instanceId + ", cause: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    public String calculateDeleteServerQuota(String instanceId, Set<String> serverIdSet) {
        try {
            if (VerifyUtil.isEmpty((String)instanceId)) {
                logger.error((Object)"param is null , calculateDeleteServerQuota failed");
                throw new LegoCheckedException(1073947393L);
            }
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
            if (VerifyUtil.isEmpty((Object)instance)) {
                logger.error((Object)("instance is null , calculateDeleteServerQuota failed, instance id: " + instanceId));
                throw new LegoCheckedException(1073947393L);
            }
            String projectId = instance.getProjectId();
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            String regionUuid = (String)pg.getProps().get("regionId");
            String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
            String drRegionId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
            String drProjectId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drProjectId"));
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            HashSet<ProtectObject> delVms = new HashSet<ProtectObject>();
            for (ProtectObject po : pg.getPolist()) {
                String serverId = OpenStackCommonUtil.getIdFromUuid(po.getMoUuid());
                if (!serverIdSet.contains(serverId)) continue;
                delVms.add(po);
            }
            String type = pg.getProperty("serviceInstanceType");
            List<QuotaResourcesBo> quotaList = this.countDelSourceQuota(delVms, volMap, type, false);
            List<QuotaResourcesBo> noBootQuotaList = this.countDelSourceQuotaNoBootVolume(delVms, volMap, type, true);
            boolean isCsdrVhaMode = OpenStackBasicUtil.isCsdrVhaMode(pg);
            JSONArray array = this.constructQuotaResult(type, new String[]{projectId, regionId}, new String[]{drProjectId, drRegionId}, quotaList, isCsdrVhaMode);
            String drAzid = (String)pg.getProps().get("drZoneName");
            String azid = (String)pg.getProps().get("zoneName");
            if (isCsdrVhaMode && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type)) {
                azid = drAzid;
                projectId = drProjectId;
                regionId = drRegionId;
            } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
                azid = (String)pg.getProps().get("prod_region_drZoneName");
                if (isCsdrVhaMode) {
                    projectId = drProjectId;
                    regionId = drRegionId;
                }
            }
            JSONArray evsArray = this.constructEvsQuota(type, new String[]{drProjectId, drRegionId, drAzid}, new String[]{projectId, regionId, azid}, noBootQuotaList);
            array.addAll((Collection)evsArray);
            logger.info((Object)"delete server quota message: %s", new Object[]{array.toString()});
            return array.toString();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"calculate Delete Server Quota fail. ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("calculate Delete Server Quota fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    public String calculateDeleteVolumeQuota(String instanceId, Set<ProtectedVolumeInfo> delVolumes) {
        try {
            if (VerifyUtil.isEmpty((String)instanceId) || VerifyUtil.isEmpty(delVolumes)) {
                logger.error((Object)"param is null , calculateDeleteVolumeQuota failed");
                throw new LegoCheckedException(1073947393L);
            }
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
            if (VerifyUtil.isEmpty((Object)instance)) {
                logger.error((Object)("instance is null , calculateDeleteVolumeQuota failed, instance id: " + instanceId));
                throw new LegoCheckedException(1073947393L);
            }
            String projectId = instance.getProjectId();
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            String regionUuid = (String)pg.getProps().get("regionId");
            String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
            String drRegionId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
            String drProjectId = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drProjectId"));
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            float volumesSize = 0.0f;
            float volumesNumber = 0.0f;
            for (ProtectedVolumeInfo volumeInfo : delVolumes) {
                String volumeUuid = volumeInfo.getVolumeId();
                String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
                volumesSize = volMap.get(volumeId).floatValue() + volumesSize;
                volumesNumber += 1.0f;
            }
            String type = (String)pg.getProps().get("serviceInstanceType");
            List<QuotaResourcesBo> quotaList = this.createQuotaInfo(type, volumesSize, volumesNumber, false);
            boolean isCsdrVhaMode = OpenStackBasicUtil.isCsdrVhaMode(pg);
            JSONArray array = this.constructQuotaResult(type, new String[]{projectId, regionId}, new String[]{drProjectId, drRegionId}, quotaList, isCsdrVhaMode);
            String drAzid = (String)pg.getProps().get("drZoneName");
            String azid = (String)pg.getProps().get("zoneName");
            if (isCsdrVhaMode && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type)) {
                azid = drAzid;
                projectId = drProjectId;
                regionId = drRegionId;
            } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
                azid = (String)pg.getProps().get("prod_region_drZoneName");
                if (isCsdrVhaMode) {
                    projectId = drProjectId;
                    regionId = drRegionId;
                }
            }
            JSONArray evsArray = this.constructEvsQuota(type, new String[]{drProjectId, drRegionId, drAzid}, new String[]{projectId, regionId, azid}, quotaList);
            array.addAll((Collection)evsArray);
            logger.info((Object)"delete volume protect quota message: %s", new Object[]{array.toString()});
            return array.toString();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"calculate Delete Volume Quota fail. ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("calculate Delete Volume Quota fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    private List<QuotaResourcesBo> createQuotaInfo(String type, float volumesSize, float volumesNumber, boolean isCreateIns) {
        ArrayList<QuotaResourcesBo> result = new ArrayList<QuotaResourcesBo>();
        QuotaResourcesBo volSize = new QuotaResourcesBo();
        volSize.setQuota(volumesSize);
        QuotaResourcesBo volNum = new QuotaResourcesBo();
        volNum.setQuota(volumesNumber);
        QuotaResourcesBo instNum = new QuotaResourcesBo();
        QuotaResourcesBo volVhaSize = new QuotaResourcesBo();
        volVhaSize.setQuota(volumesSize);
        QuotaResourcesBo volVhaNum = new QuotaResourcesBo();
        volVhaNum.setQuota(volumesNumber);
        QuotaResourcesBo instVhaNum = new QuotaResourcesBo();
        this.initInstAndVhaNum(isCreateIns, instNum, instVhaNum);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(type)) {
            volSize.setType("csdr.vol.size");
            volNum.setType("csdr.vol.num");
            instNum.setType("csdr.instance.num");
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(type)) {
            volSize.setType("csha.vol.size");
            volNum.setType("csha.vol.num");
            instNum.setType("csha.instance.num");
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(type)) {
            volSize.setType("vha.vol.size");
            volNum.setType("vha.vol.num");
            instNum.setType("vha.instance.num");
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type)) {
            volVhaSize.setType("vha.vol.size");
            volVhaNum.setType("vha.vol.num");
            instVhaNum.setType("vha.instance.num");
            volSize.setType("csdr.vol.size");
            volNum.setType("csdr.vol.num");
            instNum.setType("csdr.instance.num");
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
            volVhaSize.setType("csha.vol.size");
            volVhaNum.setType("csha.vol.num");
            instVhaNum.setType("csha.instance.num");
            volSize.setType("csdr.vol.size");
            volNum.setType("csdr.vol.num");
            instNum.setType("csdr.instance.num");
        } else {
            logger.error((Object)("instance type is error, type: " + type));
            throw new LegoCheckedException(1073947393L);
        }
        result.add(volSize);
        result.add(volNum);
        result.add(instNum);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
            result.add(volVhaSize);
            result.add(volVhaNum);
            result.add(instVhaNum);
        }
        return result;
    }

    private void initInstAndVhaNum(boolean isCreateIns, QuotaResourcesBo instNum, QuotaResourcesBo instVhaNum) {
        if (isCreateIns) {
            instNum.setQuota(1.0f);
            instVhaNum.setQuota(1.0f);
        } else {
            instNum.setQuota(0.0f);
            instVhaNum.setQuota(0.0f);
        }
    }

    private boolean checkQuotaUnable(String projectId, String type) {
        List<QuotaInfo> list = this.filterRelatedQuota(this.queryQuotaForDb(projectId), type);
        if (VerifyUtil.isEmpty(list)) {
            return true;
        }
        for (QuotaInfo qt : list) {
            if (!(qt.getQuota() < 0.0f)) continue;
            return true;
        }
        return false;
    }

    private List<QuotaInfo> filterRelatedQuota(List<QuotaInfo> items, String type) {
        if (items == null) {
            return Collections.emptyList();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue(), Collections.singletonList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue(), Collections.singletonList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue(), Collections.singletonList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue(), Collections.singletonList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue(), Collections.singletonList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue(), Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue(), Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue(), Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()));
        map.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue(), Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()));
        List related = (List)map.get(type);
        ArrayList<QuotaInfo> result = new ArrayList<QuotaInfo>();
        for (QuotaInfo item : items) {
            boolean matched = related.stream().anyMatch(prefix -> item.getQuotaName().startsWith(prefix + "."));
            if (!matched) continue;
            result.add(item);
        }
        return result;
    }

    private String compareQuota(Map<String, Float> quotaAdd, String projectId) {
        List<QuotaInfo> list = this.queryQuotaForDb(projectId);
        if (VerifyUtil.isEmpty(list)) {
            return null;
        }
        Map<String, Float> quotaUsed = this.queryProjectQuotaUsedInfo(projectId);
        for (QuotaInfo qt : list) {
            float usedQuota;
            float addQuota;
            if (!quotaAdd.containsKey(qt.getQuotaName()) || !((addQuota = quotaAdd.get(qt.getQuotaName()).floatValue()) + (usedQuota = quotaUsed.get(qt.getQuotaName()).floatValue()) > qt.getQuota())) continue;
            String result = qt.getQuotaName() + ":" + qt.getQuota() + ":" + usedQuota + ":" + addQuota;
            return result;
        }
        return null;
    }

    private List<ServiceInstance> queryServiceInstances(String type, String projectId) {
        List instList;
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getMoDao().getHibernateTemplate();
        try {
            if (null == type) {
                String hql = "from ServiceInstance where projectId = ?";
                instList = hibernateTemplate.find(hql, (Object[])new String[]{projectId});
            } else {
                String hql = "from ServiceInstance where type = ? and projectId = ?";
                instList = hibernateTemplate.find(hql, (Object[])new String[]{type, projectId});
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to query instance.projectId =%s,errMsg:%s", new Object[]{projectId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
        if (instList.size() == 0) {
            logger.info((Object)("Query instance is null.projectId=" + projectId));
            return null;
        }
        return instList;
    }

    private Map<String, Float> buildInstanceFlavorInfo(ServiceInstance instanceDBInfo, Map<String, Map<String, Float>> vmFlavorMap, Map<String, ProtectGroup> pgMap) {
        HashMap<String, Float> instances = new HashMap<String, Float>();
        float instanceNum = 0.0f;
        float serverCpuNum = 0.0f;
        float serverRam = 0.0f;
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        ProtectGroup pg = pgMap.get(instanceDBInfo.getProtectGroupId());
        HashMap<String, Integer> volidMap = new HashMap<String, Integer>();
        if (null != pg) {
            for (ProtectObject po : pg.getPolist()) {
                String serverId = OpenStackCommonUtil.getIdFromUuid(po.getMoUuid());
                Map<String, Float> volumesMap = this.getVolumesSize(pg, po, volidMap);
                if (null == vmFlavorMap.get(serverId)) continue;
                serverCpuNum = vmFlavorMap.get(serverId).get("csha.cpu.core.num").floatValue() + serverCpuNum;
                serverRam = vmFlavorMap.get(serverId).get("csha.mem.size").floatValue() + serverRam;
                volumesSize += volumesMap.get("csha.vol.size").floatValue();
                volumesNumber += volumesMap.get("csha.vol.num").floatValue();
            }
            instanceNum = 1.0f;
        }
        instances.put("csha.instance.num", Float.valueOf(instanceNum));
        instances.put("csha.cpu.core.num", Float.valueOf(serverCpuNum));
        instances.put("csha.mem.size", Float.valueOf(serverRam / 1024.0f));
        instances.put("csha.vol.size", Float.valueOf(volumesSize));
        instances.put("csha.vol.num", Float.valueOf(volumesNumber));
        return instances;
    }

    private Map<String, Float> getVolumesSize(ProtectGroup pg, ProtectObject po, Map<String, Integer> volidMap) {
        String replicationInfo;
        PoReplicaInfo poReplicaInfo;
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        HashMap<String, Float> volumesMap = new HashMap<String, Float>();
        if (null != pg.getProps() && !pg.getProps().isEmpty() && null != (poReplicaInfo = JsonUtil.jsonToBean(replicationInfo = (String)po.getProps().get("replicationInfo"), PoReplicaInfo.class)) && !poReplicaInfo.getPairInfos().isEmpty()) {
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (volidMap.containsKey(pairInfo.getVolumeUuid()) || !VOLUMES_STATUS_PROTECTED.equals(pairInfo.getVolumeStatus()) && !VOLUMES_STATUS_REMOVED.equals(pairInfo.getVolumeStatus())) continue;
                volumesSize = (float)pairInfo.getSize() + volumesSize;
                volumesNumber += 1.0f;
                volidMap.put(pairInfo.getVolumeUuid(), 1);
            }
        }
        volumesMap.put("csha.vol.size", Float.valueOf(volumesSize));
        volumesMap.put("csha.vol.num", Float.valueOf(volumesNumber));
        return volumesMap;
    }

    private Map<String, Map<String, Float>> queryVmInfo(String openstackUuid, String regionUuid, String tokenId, String projectId) {
        INovaManager nova = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vmList = nova.getVms(regionUuid, tokenId, projectId);
        List<VMFlavor> vmFlavor = nova.getVmFlavors(regionUuid, tokenId, projectId);
        HashMap<String, Map<String, Float>> vmFlavorMap = new HashMap<String, Map<String, Float>>();
        HashMap flavorMap = new HashMap();
        for (VMFlavor flavor : vmFlavor) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            map.put("csha.cpu.core.num", Float.valueOf(flavor.getVcpus()));
            map.put("csha.mem.size", Float.valueOf(flavor.getRam()));
            flavorMap.put(flavor.getId(), map);
        }
        for (OpenStackVM vm : vmList) {
            String serverID = OpenStackCommonUtil.getIdFromUuid(vm.getUuid());
            vmFlavorMap.put(serverID, (Map<String, Float>)flavorMap.get(vm.getFlavorId()));
        }
        return vmFlavorMap;
    }

    private Map<String, Float> queryVolInfo(String openstackUuid, String regionUuid, String tokenId, String projUuid) {
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volList = volumeService.getVolumesFromOpenstack(regionUuid, projUuid);
        HashMap<String, Float> volMap = new HashMap<String, Float>();
        for (OpenStackVolume vol : volList) {
            float size = vol.getSize().intValue();
            String volId = OpenStackCommonUtil.getIdFromUuid(vol.getUuid());
            volMap.put(volId, Float.valueOf(size));
        }
        return volMap;
    }

    private JSONArray constructQuotaResult(String type, String projectId, String regionId, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        return this.constructQuotaResult(type, new String[]{projectId, regionId}, new String[]{drProjectId, drRegionId}, list, false);
    }

    private JSONArray constructQuotaResult(String type, String[] region, String[] drRegion, List<QuotaResourcesBo> list, boolean isCsdrVhaMode) {
        String drRegionId;
        String drProjectId;
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
            JSONArray results = this.constructQuotaResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue(), region, drRegion, list, false);
            if (isCsdrVhaMode) {
                results.addAll((Collection)this.constructQuotaResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type) ? ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue() : ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue(), drRegion, null, list, false));
            } else {
                results.addAll((Collection)this.constructQuotaResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type) ? ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue() : ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue(), region, null, list, false));
            }
            return results;
        }
        String projectId = region[0];
        String regionId = region[1];
        if (drRegion != null) {
            drProjectId = drRegion[0];
            drRegionId = drRegion[1];
        } else {
            drProjectId = null;
            drRegionId = null;
        }
        JSONArray quotas = new JSONArray();
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)type);
        if (instanceType == null) {
            return quotas;
        }
        JSONArray quotaResourceList = new JSONArray();
        String prefix = instanceType.getFrontValue() + ".";
        for (QuotaResourcesBo bo : list) {
            JSONObject quotaResource = new JSONObject();
            String resourceType = bo.getType();
            if (resourceType == null || !resourceType.startsWith(prefix)) continue;
            quotaResource.put((Object)"resource", (Object)bo.getType());
            quotaResource.put((Object)"used", (Object)Float.valueOf(0.0f - bo.getQuota()));
            quotaResourceList.add((Object)quotaResource);
        }
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getServiceIdFromServiceType((String)type));
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)projectId);
        quota.put((Object)"region_id", (Object)regionId);
        quota.put((Object)"usages", (Object)usagesList);
        quotas.add((Object)quota);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(type)) {
            JSONObject drQuota = new JSONObject();
            drQuota.put((Object)"project_id", (Object)drProjectId);
            drQuota.put((Object)"region_id", (Object)drRegionId);
            drQuota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)drQuota);
        }
        return quotas;
    }

    private void checkQuotaBeyondMax(String projectId, List<QuotaBo> quotas, List<QuotaInfo> qtList) {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            float total = 0.0f;
            float csdrTotal = 0.0f;
            for (QuotaBo quota : quotas) {
                for (QuotaResourcesBo resource : quota.getResources()) {
                    if (resource.getQuota() < 0.0f) continue;
                    if (INSTANCE_NUM.contains(resource.getType())) {
                        total += resource.getQuota();
                    }
                    if (!"csdr.instance.num".equals(resource.getType())) continue;
                    csdrTotal += resource.getQuota();
                }
            }
            if (total > 512.0f) {
                logger.error((Object)("set projectId " + projectId + ",quota beyond max, total: " + total + ",max num=" + 512));
                throw new LegoCheckedException(1073948164L);
            }
            if (null == qtList) {
                return;
            }
            this.checkAllProjectQuota(total, csdrTotal, projectId, qtList);
        }
    }

    private void checkAllProjectQuota(float total, float csdrTotal, String projectId, List<QuotaInfo> qtList) {
        float usedTotal = 0.0f;
        for (QuotaInfo use : qtList) {
            if (projectId.equals(use.getProjectId()) || !INSTANCE_NUM.contains(use.getQuotaName()) || use.getQuota() < 0.0f) continue;
            usedTotal += use.getQuota();
            if (!"csdr.instance.num".equals(use.getQuotaName())) continue;
            csdrTotal += use.getQuota();
        }
        if (total + usedTotal - csdrTotal / 2.0f > 512.0f) {
            logger.error((Object)("set projectId " + projectId + "quota beyond max(" + 512 + "), total: " + total + ",usedTotal: " + usedTotal + ", csdrTotal:" + csdrTotal));
            throw new LegoCheckedException(1073948164L);
        }
    }

    private List<QuotaResourcesBo> addPhVmVolQuota(String openstackUuid, String drRegionUuid, String drProjectUuid, Set<ProtectObject> protectObjectSet, String type, List<QuotaResourcesBo> instanceQuota) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(type)) {
            return instanceQuota;
        }
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(drProjectUuid);
        List<OpenStackVM> drvmList = novaMgr.getVms(drRegionUuid, tokenId, drProjectUuid);
        HashMap<String, String> vmToVolumeMap = new HashMap<String, String>();
        HashMap<String, OpenStackVM> idToVmMap = new HashMap<String, OpenStackVM>();
        for (OpenStackVM drvm : drvmList) {
            vmToVolumeMap.put(OpenStackCommonUtil.getIdFromUuid(drvm.getUuid()), drvm.getVolumeAttached());
            idToVmMap.put(OpenStackCommonUtil.getIdFromUuid(drvm.getUuid()), drvm);
        }
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List vols = volumeService.getVolumesFromOpenstack(drRegionUuid, drProjectUuid);
        HashMap<String, Integer> volAndVolSizeMap = new HashMap<String, Integer>();
        for (OpenStackVolume vol : vols) {
            volAndVolSizeMap.put(OpenStackCommonUtil.getIdFromUuid(vol.getUuid()), vol.getSize());
        }
        float num = 0.0f;
        float size = 0.0f;
        HashSet<String> idSet = new HashSet<String>();
        for (ProtectObject po : protectObjectSet) {
            List<String> remoteVolumeIdList;
            String drvmId = OpenStackCommonUtil.getIdFromUuid((String)po.getProps().get("occupied_vm"));
            if (!vmToVolumeMap.containsKey(drvmId)) {
                logger.error((Object)("calculateQuota failed, drvm is miss, drvmid: " + drvmId));
                throw new LegoCheckedException(1073947393L);
            }
            if (OpenStackCommonUtil.isBareMetalServer((OpenStackVM)idToVmMap.get(drvmId)) || (remoteVolumeIdList = OpenStackCommonUtil.getListFromStr((String)vmToVolumeMap.get(drvmId), ",")).size() == 0) continue;
            for (String id : remoteVolumeIdList) {
                String volId = OpenStackCommonUtil.getIdFromUuid(id);
                if (idSet.contains(volId)) continue;
                if (!volAndVolSizeMap.containsKey(volId)) {
                    logger.error((Object)("calculateQuota failed, drvm vol is miss, drvolid: " + volId));
                    throw new LegoCheckedException(1073947393L);
                }
                size += (float)((Integer)volAndVolSizeMap.get(volId)).intValue();
                num += 1.0f;
                idSet.add(volId);
            }
        }
        QuotaResourcesBo evsVolNumBo = new QuotaResourcesBo();
        evsVolNumBo.setType("volumes");
        evsVolNumBo.setQuota(num);
        instanceQuota.add(evsVolNumBo);
        QuotaResourcesBo evsVolSizeBo = new QuotaResourcesBo();
        evsVolSizeBo.setType("gigabytes");
        evsVolSizeBo.setQuota(size);
        instanceQuota.add(evsVolSizeBo);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) {
            this.addCshaCsdrPhVmVolQuota(protectObjectSet, openstackUuid, instanceQuota);
        }
        return instanceQuota;
    }

    private void addCshaCsdrPhVmVolQuota(Set<ProtectObject> protectObjectSet, String openstackUuid, List<QuotaResourcesBo> instanceQuota) {
        ArrayList<ProtectObject> protectObjectList = new ArrayList<ProtectObject>(protectObjectSet);
        ProtectGroup pg = protectObjectList.get(0).getProtectGroup();
        String regionId = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String regionUuid = openstackUuid + ":" + OpenStackBasicUtil.getIdFromUuid(regionId);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        HashMap<String, String> vmToVolumeMap = new HashMap<String, String>();
        HashMap<String, OpenStackVM> idToVmMap = new HashMap<String, OpenStackVM>();
        for (OpenStackVM vm : vmList) {
            vmToVolumeMap.put(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()), vm.getVolumeAttached());
            idToVmMap.put(OpenStackCommonUtil.getIdFromUuid(vm.getUuid()), vm);
        }
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List vols = volumeService.getVolumesFromOpenstack(regionUuid, projectUuid);
        HashMap<String, Integer> volAndVolSizeMap = new HashMap<String, Integer>();
        for (OpenStackVolume vol : vols) {
            volAndVolSizeMap.put(OpenStackCommonUtil.getIdFromUuid(vol.getUuid()), vol.getSize());
        }
        float num = 0.0f;
        float size = 0.0f;
        HashSet<String> idSet = new HashSet<String>();
        for (ProtectObject po : protectObjectSet) {
            List<String> remoteVolumeIdList;
            String cshadrvmId = OpenStackCommonUtil.getIdFromUuid((String)po.getProps().get("csha_occupied_vm"));
            if (!vmToVolumeMap.containsKey(cshadrvmId)) {
                logger.error((Object)("calculateQuota failed, drvm is miss, drvmid: " + cshadrvmId));
                throw new LegoCheckedException(1073947393L);
            }
            if (OpenStackCommonUtil.isBareMetalServer((OpenStackVM)idToVmMap.get(cshadrvmId)) || (remoteVolumeIdList = OpenStackCommonUtil.getListFromStr((String)vmToVolumeMap.get(cshadrvmId), ",")).size() == 0) continue;
            for (String id : remoteVolumeIdList) {
                String volId = OpenStackCommonUtil.getIdFromUuid(id);
                if (idSet.contains(volId)) continue;
                if (!volAndVolSizeMap.containsKey(volId)) {
                    logger.error((Object)("calculateQuota failed, cshadrvm vol is miss, cshadrvmdrvolid: " + volId));
                    throw new LegoCheckedException(1073947393L);
                }
                size += (float)((Integer)volAndVolSizeMap.get(volId)).intValue();
                num += 1.0f;
                idSet.add(volId);
            }
        }
        QuotaResourcesBo evsVolNumBo = new QuotaResourcesBo();
        evsVolNumBo.setType("csha_volumes");
        evsVolNumBo.setQuota(num);
        instanceQuota.add(evsVolNumBo);
        QuotaResourcesBo evsVolSizeBo = new QuotaResourcesBo();
        evsVolSizeBo.setType("csha_gigabytes");
        evsVolSizeBo.setQuota(size);
        instanceQuota.add(evsVolSizeBo);
    }

    private JSONArray constructEvsQuota(String type, String[] drRegion, String[] hyperMetroRegion, List<QuotaResourcesBo> quotaList) {
        String hyperMetroAzId;
        String hyperMetroRegionId;
        String hyperMetroProjectId;
        List<String> supportQuotaType = Arrays.asList("vha.vol.size", "vha.vol.num", "csha.vol.size", "csha.vol.num");
        if (null == drRegion) {
            return null;
        }
        JSONArray result = new JSONArray();
        String drProjectId = drRegion[0];
        String drRegionId = drRegion[1];
        String drAzId = drRegion[2];
        if (null != hyperMetroRegion) {
            hyperMetroProjectId = hyperMetroRegion[0];
            hyperMetroRegionId = hyperMetroRegion[1];
            hyperMetroAzId = hyperMetroRegion[2];
        } else {
            hyperMetroProjectId = null;
            hyperMetroRegionId = null;
            hyperMetroAzId = null;
        }
        if ((ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(type)) && null != hyperMetroRegion) {
            if (null != drRegionId && drRegionId.equals(hyperMetroRegionId) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(type)) {
                List<QuotaResourcesBo> list = this.getQuotaResourcesBos(quotaList);
                result.add((Object)this.constructEvsQuota(drAzId, drProjectId, drRegionId, list));
                return result;
            }
            ArrayList<QuotaResourcesBo> vhaQuotaList = new ArrayList<QuotaResourcesBo>();
            for (QuotaResourcesBo quota : quotaList) {
                if (!supportQuotaType.contains(quota.getType())) continue;
                vhaQuotaList.add(quota);
            }
            result.add((Object)this.constructEvsQuota(hyperMetroAzId, hyperMetroProjectId, hyperMetroRegionId, vhaQuotaList));
            quotaList.removeAll(vhaQuotaList);
        }
        result.add((Object)this.constructEvsQuota(drAzId, drProjectId, drRegionId, quotaList));
        return result;
    }

    private List<QuotaResourcesBo> getQuotaResourcesBos(List<QuotaResourcesBo> quotaList) {
        QuotaResourcesBo sizeAllQuota = new QuotaResourcesBo();
        QuotaResourcesBo numAllQuota = new QuotaResourcesBo();
        float sizeAll = 0.0f;
        float numAll = 0.0f;
        for (QuotaResourcesBo bo : quotaList) {
            if (bo.getType().endsWith("vol.size")) {
                float size = bo.getQuota();
                sizeAll += size;
                continue;
            }
            if (!bo.getType().endsWith("vol.num")) continue;
            float num = bo.getQuota();
            numAll += num;
        }
        sizeAllQuota.setType("vol.size");
        sizeAllQuota.setQuota(sizeAll);
        numAllQuota.setType("vol.num");
        numAllQuota.setQuota(numAll);
        return Arrays.asList(sizeAllQuota, numAllQuota);
    }

    private JSONObject constructEvsQuota(String drAzid, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        return this.constructEvsQuota(drAzid, drProjectId, drRegionId, list, false);
    }

    private JSONObject constructEvsQuota(String drAzid, String drProjectId, String drRegionId, List<QuotaResourcesBo> list, boolean addOrMinus) {
        float size = 0.0f;
        float num = 0.0f;
        float drvolSize = 0.0f;
        float drvolNum = 0.0f;
        String evsId = this.getEVSServiceId();
        logger.debug((Object)("EVSServiceId is: " + evsId));
        for (QuotaResourcesBo bo : list) {
            if (bo.getType().endsWith("vol.size")) {
                if (addOrMinus) {
                    size = 0.0f + bo.getQuota();
                    continue;
                }
                size = 0.0f - bo.getQuota();
                continue;
            }
            if (bo.getType().endsWith("vol.num")) {
                if (addOrMinus) {
                    num = 0.0f + bo.getQuota();
                    continue;
                }
                num = 0.0f - bo.getQuota();
                continue;
            }
            if ("gigabytes".equals(bo.getType())) {
                if (!addOrMinus) continue;
                drvolSize = bo.getQuota();
                continue;
            }
            if (!"volumes".equals(bo.getType()) || !addOrMinus) continue;
            drvolNum = bo.getQuota();
        }
        JSONArray quotaResourceList = new JSONArray();
        JSONObject sizeResource = new JSONObject();
        sizeResource.put((Object)"resource", (Object)"gigabytes");
        sizeResource.put((Object)"used", (Object)Float.valueOf(size - drvolSize));
        quotaResourceList.add((Object)sizeResource);
        JSONObject numResource = new JSONObject();
        numResource.put((Object)"resource", (Object)"volumes");
        numResource.put((Object)"used", (Object)Float.valueOf(num - drvolNum));
        quotaResourceList.add((Object)numResource);
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)evsId);
        usage.put((Object)"available_zone", (Object)OpenStackCommonUtil.getIdFromUuid(drAzid));
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)drProjectId);
        quota.put((Object)"region_id", (Object)drRegionId);
        quota.put((Object)"usages", (Object)usagesList);
        return quota;
    }

    public String calculateDowngradeInstanceQuota(String instanceId, String reservedInsType) {
        try {
            if (VerifyUtil.isEmpty((String)instanceId)) {
                logger.error((Object)"param is null , calculateDowngradeInstanceQuota failed");
                throw new LegoCheckedException(1073947393L);
            }
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
            if (VerifyUtil.isEmpty((Object)instance)) {
                logger.error((Object)("instance is null , calculateDowngradeInstanceQuota failed, instance id: " + instanceId));
                throw new LegoCheckedException(1073947393L);
            }
            if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue().equals(instance.getProtectType())) {
                logger.error((Object)("instance not support downgrade, instance id: " + instanceId));
                throw new LegoCheckedException(1073947393L);
            }
            String projectId = instance.getProjectId();
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            String regionUuid = (String)pg.getProps().get("regionId");
            String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
            HashMap<String, String> downGradeMap = new HashMap<String, String>();
            downGradeMap.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue());
            downGradeMap.put(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getFrontValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue());
            String type = (String)downGradeMap.get(reservedInsType);
            if (type == null) {
                logger.error((Object)("no downgrade instance type for " + reservedInsType + " instance"));
                throw new LegoCheckedException(1073947393L);
            }
            String drProjectId = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("drProjectId"));
            String drRegionUuid = pg.getProperty("drRegionId");
            String drRegionId = OpenStackCommonUtil.getIdFromUuid(drRegionUuid);
            List<QuotaResourcesBo> quotaList = this.countDelSourceQuota(pg.getPolist(), volMap, type, true);
            List<QuotaResourcesBo> noBootQuotaList = this.countDelSourceQuotaNoBootVolume(pg.getPolist(), volMap, type, true);
            JSONArray array = this.constructQuotaResult(type, projectId, regionId, drProjectId, drRegionId, quotaList);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue().equals(reservedInsType)) {
                String azid = (String)pg.getProps().get("zoneName");
                array.add((Object)this.constructEvsQuota(azid, projectId, regionId, noBootQuotaList));
            } else {
                String drAzid = (String)pg.getProps().get("drZoneName");
                array.add((Object)this.constructEvsQuota(drAzid, drProjectId, drRegionId, noBootQuotaList));
            }
            return array.toString();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"calculate Downgrade Instance fail. ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("calculate Downgrade Instance fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    public String calculateUpgradeInstanceQuota(ServiceInstance instance, ProtectGroup pg) {
        try {
            String projectId = instance.getProjectId();
            String regionUuid = (String)pg.getProps().get("regionId");
            String regionId = OpenStackCommonUtil.getIdFromUuid(regionUuid);
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            String projUuid = openstackUuid + ":" + projectId;
            String beforeUpgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
            String azId = (String)pg.getProps().get("zoneName");
            JSONArray resultArray = new JSONArray();
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            Set protectObjectSet = pg.getPolist();
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(beforeUpgradeType)) {
                Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
                List<QuotaResourcesBo> instanceQuota = this.countUpgradeSourceQuota(pg, volMap);
                resultArray.add((Object)this.constructEvsQuota(azId, projectId, regionId, instanceQuota, true));
                return resultArray.toString();
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(beforeUpgradeType)) {
                String drRegionUuid = (String)pg.getProps().get("drRegionId");
                String drProjUuid = (String)pg.getProps().get("drProjectId");
                String type = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue();
                Map<String, Float> volMap = this.queryVolInfo(openstackUuid, regionUuid, tokenId, projUuid);
                List<QuotaResourcesBo> instanceQuota = this.countUpgradeSourceQuota(pg, volMap);
                instanceQuota.addAll(this.addPhVmVolQuota(openstackUuid, drRegionUuid, drProjUuid, protectObjectSet, type, instanceQuota));
                String drAzid = (String)pg.getProps().get("drZoneName");
                String drProjectId = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("drProjectId"));
                String drRegionId = OpenStackCommonUtil.getIdFromUuid(drRegionUuid);
                resultArray.add((Object)this.constructEvsQuota(drAzid, drProjectId, drRegionId, instanceQuota, true));
                return resultArray.toString();
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"calculate upgrade Instance fail. ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("calculate upgrade Instance fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    public String getEVSServiceId() {
        String id = LegoConfig.getInstance().getKeyValue(EVS_SERVICE_ID, "evs");
        return id;
    }

    private List<QuotaResourcesBo> countDelSourceQuota(Set<ProtectObject> protectObjectSet, Map<String, Float> volMap, String type, boolean isCreateIns) {
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        Set<String> volIds = OpenStackCommonUtil.getVolIdsOfProtectObjects(protectObjectSet, true);
        for (String volId : volIds) {
            if (null == volMap.get(volId)) {
                logger.error((Object)("calculateQuota failed, vol is miss, volid: " + volId));
                throw new LegoCheckedException(1073947393L);
            }
            volumesSize = volMap.get(volId).floatValue() + volumesSize;
            volumesNumber += 1.0f;
        }
        return this.createQuotaInfo(type, volumesSize, volumesNumber, isCreateIns);
    }

    private List<QuotaResourcesBo> countDelSourceQuotaNoBootVolume(Set<ProtectObject> protectObjectSet, Map<String, Float> volMap, String type, boolean isCreateIns) {
        Set<String> volIds = OpenStackCommonUtil.getVolIdsOfProtectObjects(protectObjectSet, true);
        float volumesSize = 0.0f;
        float volumesNumber = 0.0f;
        for (String string : volIds) {
            if (null == volMap.get(string)) {
                logger.error((Object)("calculateQuota failed, vol is miss, volid: " + string));
                throw new LegoCheckedException(1073947393L);
            }
            volumesSize = volMap.get(string).floatValue() + volumesSize;
            volumesNumber += 1.0f;
        }
        List<QuotaResourcesBo> quotaList = this.createQuotaInfo(type, volumesSize, volumesNumber, isCreateIns);
        volIds = OpenStackCommonUtil.getVolIdsOfProtectObjects(protectObjectSet, false);
        volumesSize = 0.0f;
        volumesNumber = 0.0f;
        for (String volId : volIds) {
            if (null == volMap.get(volId)) {
                logger.error((Object)("calculateQuota failed, vol is miss, volid: " + volId));
                throw new LegoCheckedException(1073947393L);
            }
            volumesSize = volMap.get(volId).floatValue() + volumesSize;
            volumesNumber += 1.0f;
        }
        List<QuotaResourcesBo> list = this.createQuotaInfo(type, volumesSize, volumesNumber, isCreateIns);
        Iterator<QuotaResourcesBo> iterator = quotaList.iterator();
        while (iterator.hasNext()) {
            QuotaResourcesBo quotaResource = iterator.next();
            if (!"csdr.vol.size".equals(quotaResource.getType()) && !"csdr.vol.num".equals(quotaResource.getType())) continue;
            iterator.remove();
        }
        for (QuotaResourcesBo quota : list) {
            if (!"csdr.vol.size".equals(quota.getType()) && !"csdr.vol.num".equals(quota.getType())) continue;
            quotaList.add(quota);
        }
        return quotaList;
    }

    private void checkAddVolumesNumber(String instanceType, float volumeNumber) {
        if ((ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(instanceType)) && volumeNumber > 60.0f) {
            logger.error((Object)"Batch add volumes to protection error. Volumes number is %s, greater than 60.", new Object[]{String.valueOf(volumeNumber)});
            throw new LegoCheckedException(1073949729L);
        }
    }
}

