/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class HoldVmCheckChecker
implements IServiceInstChecker {
    private static Log logger = LogFactory.getInstance(HoldVmCheckChecker.class);

    public void check(CheckContext context) {
        ServiceInstance serviceInstance = context.getInstanceInst();
        ProtectGroup pg = context.getPg();
        String instanceType = serviceInstance.getType();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instanceType)) {
            return;
        }
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projectUuid = (String)pg.getProps().get("drProjectId");
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        boolean isCshaCsdr = "csha_csdr".equals(serviceInstance.getProtectType()) && !OpenStackCommonUtil.isCsdrCshaMode(pg);
        String hypermetorRegionUuid = isCshaCsdr ? (String)pg.getProps().get("regionId") : regionUuid;
        String hypermetorProjectUuid = isCshaCsdr ? (String)pg.getProps().get("projectId") : projectUuid;
        String hypermetorTokenId = isCshaCsdr ? TokenUtil.getInstance().getTokenId(hypermetorProjectUuid) : tokenId;
        boolean isManualRefresh = VerifyUtil.isEmpty((String)pg.getProperty("isManualRefresh")) || String.valueOf(1).equals(pg.getProperty("isManualRefresh"));
        for (ProtectObject po : pg.getPolist()) {
            if ("true".equals(po.getProps().get("TOBEDELETED")) || "true".equals(po.getProps().get("OBJ_DELETE_ERROR"))) {
                logger.debug((Object)("del po: " + po.getUuid()));
                continue;
            }
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                context.getUnConfigHoldVmPo().add(po.getMoUuid());
                continue;
            }
            PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
            if (VerifyUtil.isEmpty((Object)phVm) || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                context.getUnConfigHoldVmPo().add(po.getMoUuid());
                continue;
            }
            logger.debug((Object)("PhVmInfo in db: " + phVm.getVmUuid()));
            INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(pg.getPoProviderSN());
            OpenStackVM holdUpVm = novaManager.getVm(regionUuid, tokenId, projectUuid, phVm.getVmUuid(), new int[0]);
            if (null == holdUpVm) {
                logger.error((Object)("holdup Vm is not exist: " + phVm.getVmUuid()));
                phVm.setStatus(OpenstackEnumDefine.HOLD_VM_STATUS_E.UNEXISTED.getValue());
                context.getUnExistedHoldVmPo().add(po.getMoUuid());
            } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instanceType)) {
                phVm.setStatus(OpenstackEnumDefine.HOLD_VM_STATUS_E.NORMAL.getValue());
                if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                    this.addTagToHoldVm(holdUpVm, pg, "__type_dr");
                }
                this.addTagToHoldVm(holdUpVm, pg, "__type_csha");
                this.updateVMmetadata(holdUpVm, novaManager, regionUuid, projectUuid, tokenId, poReplicaInfo);
                this.addTagToHoldVm(holdUpVm, pg, "dr_backup_region::" + OpenStackCommonUtil.getIdFromUuid(regionUuid));
                this.addTagToHoldVm(holdUpVm, pg, "dr_backup_vm::" + OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()));
            } else if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && !ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(instanceType)) {
                this.addTagToHoldVm(holdUpVm, pg, "__type_dr");
                this.updateVMmetadata(holdUpVm, novaManager, regionUuid, projectUuid, tokenId, poReplicaInfo);
            }
            po.getProps().put("replicationInfo", JSONObject.fromObject((Object)poReplicaInfo).toString());
            if ("csha_csdr".equals(serviceInstance.getProtectType())) {
                PoReplicaInfo hypermetorPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
                if (VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo)) {
                    context.getUnConfigHoldVmPo().add(po.getMoUuid());
                    continue;
                }
                PhVmInfo hypermetorPhVm = hypermetorPoReplicaInfo.getPhVmInfo();
                if (VerifyUtil.isEmpty((Object)hypermetorPhVm) || VerifyUtil.isEmpty((String)hypermetorPhVm.getVmUuid())) {
                    context.getUnConfigHoldVmPo().add(po.getMoUuid());
                    continue;
                }
                logger.debug((Object)("hypermetorPhVm in db: " + hypermetorPhVm.getVmUuid()));
                OpenStackVM cshaHoldUpVm = novaManager.getVm(hypermetorRegionUuid, hypermetorTokenId, hypermetorProjectUuid, hypermetorPhVm.getVmUuid(), new int[0]);
                if (VerifyUtil.isEmpty((Object)cshaHoldUpVm)) {
                    logger.error((Object)("cshaHoldUp Vm is not exist: " + hypermetorPhVm.getVmUuid()));
                    hypermetorPhVm.setStatus(OpenstackEnumDefine.HOLD_VM_STATUS_E.UNEXISTED.getValue());
                    context.getUnExistedHoldVmPo().add(po.getMoUuid());
                    continue;
                }
                this.updatePoVmNameProps(isManualRefresh, pg, po, holdUpVm, cshaHoldUpVm);
                continue;
            }
            this.updatePoVmNameProps(isManualRefresh, pg, po, holdUpVm, null);
        }
    }

    private void updatePoVmNameProps(boolean isManualRefresh, ProtectGroup pg, ProtectObject po, OpenStackVM holdUpVm, OpenStackVM cshaHoldUpVm) {
        if (!isManualRefresh || null == holdUpVm) {
            logger.debug((Object)"No need update po(%s:%s) holdUpVm name.", new Object[]{pg.getName(), po.getMoUuid()});
            return;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        poReplicaInfo.getPhVmInfo().setName(holdUpVm.getName());
        po.setProperty("replicationInfo", (Object)JSONObject.fromObject((Object)poReplicaInfo).toString());
        if (34 == pg.getTemplate().getType()) {
            PoReplicaInfo hypermetorPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
            PoReplicaInfo remotePoReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
            if (VerifyUtil.isEmpty((Object)remotePoReplicaInfo) || VerifyUtil.isEmpty((Object)remotePoReplicaInfo.getPhVmInfo()) || VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo)) {
                logger.error((Object)"Do not update po(%s:%s) holdUpVm name. ReplicationInfo is not available.", new Object[]{pg.getName(), poReplicaInfo.getMoUuid()});
                return;
            }
            remotePoReplicaInfo.getPhVmInfo().setName(holdUpVm.getName());
            po.setProperty("remote_replicationInfo", (Object)JSONObject.fromObject((Object)remotePoReplicaInfo).toString());
            if (OpenStackCommonUtil.isCsdrVhaMode(pg)) {
                hypermetorPoReplicaInfo.setVmName(holdUpVm.getName());
                po.setProperty("hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)hypermetorPoReplicaInfo).toString());
            }
        }
        this.updateRecoverySettings(po, holdUpVm, "PLACEHOLDVMNAME");
        if (null == cshaHoldUpVm) {
            logger.debug((Object)"No need update po(%s:%s) cshaHoldUpVm name.", new Object[]{pg.getName(), poReplicaInfo.getMoUuid()});
            return;
        }
        PoReplicaInfo remotePoReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
        PoReplicaInfo hypermetorPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)remotePoReplicaInfo) || VerifyUtil.isEmpty((Object)remotePoReplicaInfo.getPhVmInfo()) || VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo) || VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo.getPhVmInfo())) {
            logger.error((Object)"Do not update po(%s:%s) cshaHoldUpVm name. ReplicationInfo is not available.", new Object[]{pg.getName(), poReplicaInfo.getMoUuid()});
            return;
        }
        if (!OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            remotePoReplicaInfo.getPhVmInfo().setName(holdUpVm.getName());
        } else {
            remotePoReplicaInfo.getPhVmInfo().setName(cshaHoldUpVm.getName());
            hypermetorPoReplicaInfo.setVmName(holdUpVm.getName());
            hypermetorPoReplicaInfo.getPhVmInfo().setName(cshaHoldUpVm.getName());
            po.setProperty("hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)hypermetorPoReplicaInfo).toString());
        }
        po.setProperty("remote_replicationInfo", (Object)JSONObject.fromObject((Object)remotePoReplicaInfo).toString());
        this.updateRecoverySettings(po, cshaHoldUpVm, "CSHAPLACEHOLDVMNAME");
    }

    private void updateVMmetadata(OpenStackVM holdUpVm, INovaManager novaManager, String regionUuid, String projectUuid, String tokenId, PoReplicaInfo poReplicaInfo) {
        if (null == holdUpVm) {
            return;
        }
        if (null != holdUpVm.getMetadata() && holdUpVm.getMetadata().containsKey("_bcm_primary_vm")) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("_bcm_primary_vm", OpenStackCommonUtil.getIdFromUuid(OpenStackCommonUtil.getBcmPrimaryVmUuid(poReplicaInfo)));
            novaManager.updateVMmetadata(holdUpVm.getUuid(), projectUuid, regionUuid, tokenId, metadata);
        }
        catch (Exception e) {
            logger.error((Object)("updateVMmetadata error." + holdUpVm.getUuid()), (Throwable)e);
        }
    }

    private void addTagToHoldVm(OpenStackVM openStackVM, ProtectGroup protectGroup, String tag) {
        if (null == openStackVM || null != openStackVM.getTags() && openStackVM.getTags().contains(tag)) {
            return;
        }
        String projUuid = protectGroup.getProperty("projectId");
        String regionUuid = protectGroup.getProperty("regionId");
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openStackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        try {
            novaMgr.addTagToVm(regionUuid, tokenId, projUuid, openStackVM.getUuid(), tag);
        }
        catch (Exception e) {
            logger.error((Object)"Add tag: %s to csha holdVm: %s error.", (Throwable)e, new Object[]{tag, openStackVM.getUuid()});
        }
    }

    private void updateRecoverySettings(ProtectObject po, OpenStackVM holdUpVm, String key) {
        Session session = null;
        String poId = po.getUuid();
        String holdUpName = holdUpVm.getName();
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            String hql = "update RecoverySetting rs set rs.value=:value where rs.ownerId=:ownerId and rs.name=:name";
            Query query = session.createQuery(hql);
            query.setParameter("value", (Object)holdUpName);
            query.setParameter("ownerId", (Object)poId);
            query.setParameter("name", (Object)key);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Failed to update RecoverySetting.", (Throwable)e, 90160758786898L);
                DBOperationUtil.rollbackSession((Session)session);
                throw new LegoCheckedException(-1L, "Failed to update RecoverySetting.");
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }
}

