/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.google.common.cache.Cache;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class VmChecker
implements IServiceInstChecker {
    private static Log logger = LogFactory.getInstance(VmChecker.class);

    public void check(CheckContext context) {
        String tokenId;
        ProtectGroup protectGroup = context.getPg();
        String[] uuids = this.getVmUuids(protectGroup.getPolist());
        String regionUuid = (String)protectGroup.getProps().get("regionId");
        String projUuid = (String)protectGroup.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vms = this.getOpenStackVMS(protectGroup, regionUuid, projUuid, novaMgr, tokenId = TokenUtil.getInstance().getTokenId(projUuid));
        if (VerifyUtil.isEmpty(vms)) {
            logger.error((Object)"Vms in region(%s) is empty,", new Object[]{protectGroup.getProps().get("regionName")});
            return;
        }
        Map<String, OpenStackVM> vmUuidsMap = this.getAllLatestInfoVmInPg(uuids, vms);
        if (null != vmUuidsMap && !vmUuidsMap.isEmpty()) {
            context.getAllVmUuidsMap().putAll(vmUuidsMap);
        }
        if (protectGroup.getTemplate().getType() == 25) {
            if (VmChecker.supportSharedOrScsiVolume(regionUuid)) {
                this.getSharedNotInPgVms(context, vms);
            } else {
                List sharedVolumeNotInPgVmList = context.getSharedVolumeNotInPgVmList();
                if (null != sharedVolumeNotInPgVmList) {
                    sharedVolumeNotInPgVmList.clear();
                }
                this.getVMContainsBanVol(context, vmUuidsMap);
            }
        } else {
            this.getSharedNotInPgVms(context, vms);
        }
        Set removedVmUuids = context.getRemovedVmUuids();
        Set pos = protectGroup.getPolist();
        if (null == pos) {
            logger.error((Object)"Po is null");
            throw new LegoCheckedException(1073947393L);
        }
        Boolean isManualRefresh = VerifyUtil.isEmpty((String)protectGroup.getProperty("isManualRefresh")) || String.valueOf(1).equals(protectGroup.getProperty("isManualRefresh"));
        for (ProtectObject po : protectGroup.getPolist()) {
            if ("true".equals(po.getProps().get("OBJ_DELETE_ERROR"))) continue;
            String moUuid = po.getMoUuid();
            if (!vmUuidsMap.containsKey(moUuid)) {
                logger.error((Object)("VM was removed:" + po.getName()));
                po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
                po.getProps().put("TOBEDELETED", "true");
                removedVmUuids.add(moUuid);
                continue;
            }
            if (vmUuidsMap.containsKey(moUuid) && ProtectObjectStatusEnum.INVALID.getValue() == po.getPoStatus() && "true".equals(po.getProps().get("TOBEDELETED"))) {
                logger.info((Object)"VM was be found, recover origin, po name : %s ", new Object[]{po.getName()});
                po.setPoStatus(ProtectObjectStatusEnum.VALID.getValue());
                po.getProps().put("TOBEDELETED", "false");
            }
            OpenStackVM vm = vmUuidsMap.get(moUuid);
            this.updatePoVmNameProps(isManualRefresh, protectGroup, po, vmUuidsMap, vms);
            this.addAllTagToVM(context, vm, po);
            this.updatePoRootDevName(po, vmUuidsMap);
        }
        OpenStackCommonUtil.setProtectObjectAddressMap(protectGroup);
    }

    private void updatePoVmNameProps(Boolean isManualRefresh, ProtectGroup pg, ProtectObject po, Map<String, OpenStackVM> vmUuidsMap, List<OpenStackVM> vms) {
        if (!isManualRefresh.booleanValue()) {
            logger.debug((Object)"Is not Manual Refresh.");
            return;
        }
        if (VerifyUtil.isEmpty(vmUuidsMap)) {
            logger.error((Object)"VmUuidsMap is null.");
            return;
        }
        OpenStackVM vm = vmUuidsMap.get(po.getMoUuid());
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        if (null == vm || VerifyUtil.isEmpty((String)vm.getName()) || VerifyUtil.isEmpty((Object)poReplicaInfo)) {
            logger.error((Object)"Vm or poReplicaInfo of po(%s) is invaild.", new Object[]{po.getMoUuid()});
            return;
        }
        po.setName(vm.getName());
        poReplicaInfo.setVmName(vm.getName());
        po.setProperty("replicationInfo", (Object)JSONObject.fromObject((Object)poReplicaInfo).toString());
        if (37 == pg.getTemplate().getType() || 34 == pg.getTemplate().getType()) {
            PoReplicaInfo poHyperReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
            PoReplicaInfo remoteHyperReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
            if (VerifyUtil.isEmpty((Object)poHyperReplicaInfo) || VerifyUtil.isEmpty((Object)remoteHyperReplicaInfo)) {
                logger.error((Object)"ReplicaInfo of po(%s) is invaild.", new Object[]{po.getMoUuid()});
                return;
            }
            OpenStackVM remotePhVm = vmUuidsMap.get(remoteHyperReplicaInfo.getMoUuid());
            if (null == remotePhVm) {
                remotePhVm = vms.stream().filter(e -> e.getUuid().equals(remoteHyperReplicaInfo.getMoUuid())).findFirst().orElse(null);
            }
            if (null != remotePhVm) {
                remoteHyperReplicaInfo.setVmName(remotePhVm.getName());
                po.setProperty("remote_replicationInfo", (Object)JSONObject.fromObject((Object)remoteHyperReplicaInfo).toString());
            }
            if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
                OpenStackVM hyperPdVm;
                poHyperReplicaInfo.setVmName(vm.getName());
                if (!VerifyUtil.isEmpty((Object)poHyperReplicaInfo.getPhVmInfo()) && null != (hyperPdVm = (OpenStackVM)vms.stream().filter(e -> e.getUuid().equals(poHyperReplicaInfo.getPhVmInfo().getVmUuid())).findFirst().orElse(null))) {
                    poHyperReplicaInfo.getPhVmInfo().setName(hyperPdVm.getName());
                }
                po.setProperty("hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)poHyperReplicaInfo).toString());
            }
        }
    }

    private List<OpenStackVM> getOpenStackVMS(ProtectGroup protectGroup, String regionUuid, String projUuid, INovaManager novaMgr, String tokenId) {
        List vms;
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"Failed to get vms.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String isManualRefresh = protectGroup.getProperty("isManualRefresh");
        if (!VerifyUtil.isEmpty((String)isManualRefresh) && String.valueOf(0).equals(isManualRefresh)) {
            try {
                Cache<String, Object> cache = OpenstackCache.getCacheMap().get((Object)OpenstackCache.CacheType.OPENSTACK_VM_LIST);
                vms = (List)cache.get((Object)(regionUuid + projUuid), () -> {
                    List<OpenStackVM> vms0 = novaMgr.getVms(regionUuid, tokenId, projUuid);
                    if (vms0 != null) {
                        cache.put((Object)(regionUuid + projUuid), vms0);
                    }
                    return vms0;
                });
            }
            catch (ExecutionException e) {
                logger.error((Object)"Failed to get vms to cache:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Failed to get vms to cache");
            }
        } else {
            vms = novaMgr.getVms(regionUuid, tokenId, projUuid);
        }
        return vms;
    }

    private void getVMContainsBanVol(CheckContext context, Map<String, OpenStackVM> vmUuidsMap) {
        ProtectGroup pg = context.getPg();
        if (null == vmUuidsMap || vmUuidsMap.isEmpty()) {
            String pgName = null == pg ? "" : pg.getName();
            logger.info((Object)("The pg (" + pgName + ") has not po."));
            return;
        }
        Map cannotProtectVms = context.getCannotProtectVms();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        HashSet<String> volumeUuidSet = new HashSet<String>();
        for (OpenStackVM vm : vmUuidsMap.values()) {
            String vols = vm.getVolumeAttached();
            if (null == vols || vols.trim().isEmpty()) continue;
            volumeUuidSet.addAll(OpenStackCommonUtil.getListFromStr(vols, ","));
        }
        ArrayList volumeUuidList = new ArrayList(volumeUuidSet);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumes = volumeService.queryVolumesByUuid(regionUuid, projUuid, volumeUuidList, false);
        if (VerifyUtil.isEmpty((Collection)volumes)) {
            return;
        }
        for (OpenStackVolume openStackVolume : volumes) {
            this.checkBanVol(openStackVolume, vmUuidsMap, cannotProtectVms);
        }
    }

    private void checkBanVol(OpenStackVolume openStackVolume, Map<String, OpenStackVM> vmUuidsMap, Map<String, String> cannotProtectVms) {
        if (null == openStackVolume) {
            return;
        }
        if (!VmChecker.isSharedOrScsiVolume(openStackVolume)) {
            return;
        }
        openStackVolume.generateAttachmentInfo();
        Set attachments = openStackVolume.getAttachments();
        if (VerifyUtil.isEmpty((Collection)attachments)) {
            return;
        }
        for (OpenStackVolAttachment openStackVolAttachment : attachments) {
            OpenStackVM vm = vmUuidsMap.get(openStackVolAttachment.getVmUuid());
            if (null == vm) continue;
            cannotProtectVms.put(vm.getUuid(), vm.getName());
        }
    }

    private void addAllTagToVM(CheckContext context, OpenStackVM vm, ProtectObject po) {
        ServiceInstance serviceInstance = context.getInstanceInst();
        if (null == serviceInstance || null == vm) {
            return;
        }
        ProtectGroup pg = context.getPg();
        if (pg.getTemplate().getType() == 25) {
            PoReplicaInfo poReplicaInfo;
            this.addTagToPrVm(vm, pg, "__type_csha");
            String replicationInfo = po.getProperty("replicationInfo");
            if (!(VerifyUtil.isEmpty((String)replicationInfo) || VerifyUtil.isEmpty((Object)(poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class))) || VerifyUtil.isEmpty((Object)poReplicaInfo.getPhVmInfo()))) {
                String regionUuid = pg.getProperty("regionId");
                this.addTagToPrVm(vm, pg, "dr_backup_region::" + OpenStackCommonUtil.getIdFromUuid(regionUuid));
                this.addTagToPrVm(vm, pg, "dr_backup_vm::" + OpenStackCommonUtil.getIdFromUuid(poReplicaInfo.getPhVmInfo().getVmUuid()));
            }
        }
        if (!OpenStackCommonUtil.isCsdrCshaMode(pg) && pg.getTemplate().getType() == 37) {
            this.addTagToPrVm(vm, pg, "__type_csha");
        }
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && !ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(serviceInstance.getType())) {
            this.addTagToPrVm(vm, pg, "__type_pd");
        }
    }

    private void addTagToPrVm(OpenStackVM openStackVM, ProtectGroup protectGroup, String tag) {
        if (null == openStackVM || null != openStackVM.getTags() && openStackVM.getTags().contains(tag)) {
            return;
        }
        String projUuid = protectGroup.getProperty("projectId");
        String regionUuid = protectGroup.getProperty("regionId");
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openStackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        try {
            novaMgr.addTagToVm(regionUuid, tokenId, projUuid, openStackVM.getUuid(), tag);
        }
        catch (Exception e) {
            logger.error((Object)"Add tag: %s to csha prVm: %s error.", (Throwable)e, new Object[]{tag, openStackVM.getUuid()});
        }
    }

    private void updatePoRootDevName(ProtectObject po, Map<String, OpenStackVM> vmUuidsMap) {
        String moUuid = po.getMoUuid();
        OpenStackVM vm = vmUuidsMap.get(moUuid);
        if (null == vm) {
            logger.info((Object)("Cant find vm by mouuid:mouuid=" + moUuid));
            return;
        }
        String rootDevName = vm.getBootDevName();
        if (!VerifyUtil.isEmpty((String)rootDevName)) {
            po.getProps().put("VM_ROOT_DEVNAME_KEY", rootDevName);
        }
    }

    private String[] getVmUuids(Collection<ProtectObject> pos) {
        String[] uuids = new String[pos.size()];
        int index = 0;
        for (ProtectObject po : pos) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)"Uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        return uuids;
    }

    private Map<String, OpenStackVM> getAllLatestInfoVmInPg(String[] uuids, List<OpenStackVM> vms) {
        HashMap<String, OpenStackVM> vmUuidsMap = new HashMap<String, OpenStackVM>();
        HashSet<String> uuidSet = new HashSet<String>();
        for (String uuid : uuids) {
            uuidSet.add(uuid);
        }
        for (OpenStackVM vm : vms) {
            if (!uuidSet.contains(vm.getUuid())) continue;
            vmUuidsMap.put(vm.getUuid(), vm);
        }
        return vmUuidsMap;
    }

    private void getSharedNotInPgVms(CheckContext context, List<OpenStackVM> vms) {
        ProtectGroup pg = context.getPg();
        List sharedVolumeNotInPgVmList = context.getSharedVolumeNotInPgVmList();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String strIsManual = pg.getProperty("isManualRefresh");
        boolean isAutoFresh = !VerifyUtil.isEmpty((String)strIsManual) && String.valueOf(0).equals(strIsManual);
        Set<String> notContainVmUuidSet = VmChecker.getAllSharedVolumeNotInPgVmUuids(regionUuid, projUuid, pg.getPolist(), pg.getPolist(), false, true, isAutoFresh);
        if (!VerifyUtil.isEmpty(notContainVmUuidSet)) {
            ArrayList<String> notContainVmList = new ArrayList<String>();
            for (OpenStackVM vm : vms) {
                if (!notContainVmUuidSet.contains(vm.getUuid())) continue;
                notContainVmList.add(vm.getName());
            }
            sharedVolumeNotInPgVmList.addAll(notContainVmList);
        }
    }

    public static Set<String> getAllSharedVolumeNotInPgVmUuids(String regionUuid, String projectUuid, Set<ProtectObject> currentPoList, Set<ProtectObject> poList, boolean isDelete, boolean isBatchQueryVolume, boolean isAutoFresh) {
        HashSet<String> notContainVmUuidSet = new HashSet<String>();
        if (VerifyUtil.isEmpty(currentPoList)) {
            logger.error((Object)"CurrentPoList is empty");
            return notContainVmUuidSet;
        }
        if (VerifyUtil.isEmpty(poList)) {
            return notContainVmUuidSet;
        }
        HashSet<String> volumeUuidSet = new HashSet<String>();
        for (ProtectObject po : poList) {
            VmChecker.setPoVolumeIdFromVolcfg(volumeUuidSet, po);
            VmChecker.setPoVolumeIdFromRep(volumeUuidSet, po);
        }
        HashSet<String> currentVmUuidSet = new HashSet<String>();
        for (ProtectObject protectObject : currentPoList) {
            currentVmUuidSet.add(protectObject.getMoUuid());
        }
        return VmChecker.getAllSharedVolumeNotValidVmUuids(regionUuid, projectUuid, volumeUuidSet, currentVmUuidSet, isDelete, isBatchQueryVolume, isAutoFresh);
    }

    public static Set<String> getUnSupportVolumeVm(String regionUuid, String projectUuid, Set<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> volumeUuidSet = new HashSet<String>();
        for (ProtectObject po : poList) {
            VmChecker.setPoVolumeIdFromVolcfg(volumeUuidSet, po);
            VmChecker.setPoVolumeIdFromRep(volumeUuidSet, po);
        }
        Set<String> shareScsiVmSet = VmChecker.getShareOrScsiVmUuids(regionUuid, projectUuid, volumeUuidSet);
        return shareScsiVmSet;
    }

    private static void setPoVolumeIdFromVolcfg(Set<String> volumeUuidSet, ProtectObject po) {
        String volConfigStr = (String)po.getProps().get("volumeConfig");
        if (VerifyUtil.isEmpty((String)volConfigStr)) {
            return;
        }
        JSONArray array = JSONArray.fromObject((Object)volConfigStr);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            if ("BMS".equals(po.getProps().get("vm_type")) && VmChecker.checkDrVolType(json)) continue;
            volumeUuidSet.add(json.getString("volumeId"));
        }
    }

    private static boolean checkDrVolType(JSONObject json) {
        return !json.containsKey((Object)"drVolumeType") || VerifyUtil.isEmpty((String)json.getString("drVolumeType"));
    }

    private static void setPoVolumeIdFromRep(Set<String> volumeUuidSet, ProtectObject po) {
        String replicationInfo = (String)po.getProps().get("replicationInfo");
        if (VerifyUtil.isEmpty((String)replicationInfo)) {
            return;
        }
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null != poReplicaInfo && !poReplicaInfo.getPairInfos().isEmpty()) {
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if ("BMS".equals(po.getProps().get("vm_type")) && OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) continue;
                volumeUuidSet.add(pairInfo.getVolumeUuid());
            }
        }
    }

    public static Set<String> getAllSharedVolumeNotValidVmUuids(String regionUuid, String projectUuid, Set<String> volumeUuidSet, Set<String> currentVmUuidSet, boolean isDelete, boolean isBatchQueryVolume, boolean isAutoFresh) {
        HashSet<String> notContainVmUuidSet = new HashSet<String>();
        if (VerifyUtil.isEmpty(volumeUuidSet)) {
            return notContainVmUuidSet;
        }
        Set<String> sharedVmUuidSet = VmChecker.getAllSharedVmUuids(regionUuid, projectUuid, volumeUuidSet, isBatchQueryVolume, isAutoFresh);
        if (VerifyUtil.isEmpty(sharedVmUuidSet)) {
            return notContainVmUuidSet;
        }
        for (String sharedVmUuid : sharedVmUuidSet) {
            if (isDelete && currentVmUuidSet.contains(sharedVmUuid)) {
                notContainVmUuidSet.add(sharedVmUuid);
                continue;
            }
            if (isDelete || currentVmUuidSet.contains(sharedVmUuid)) continue;
            notContainVmUuidSet.add(sharedVmUuid);
        }
        return notContainVmUuidSet;
    }

    public static Set<String> getAllSharedVmUuids(String regionUuid, String projectUuid, Set<String> volumeUuidSet, boolean isBatchQueryVolume, boolean isAutoFresh) {
        HashSet<String> sharedVmUuidSet = new HashSet<String>();
        if (VerifyUtil.isEmpty(volumeUuidSet)) {
            return sharedVmUuidSet;
        }
        ArrayList<String> volumeUuidList = new ArrayList<String>(volumeUuidSet);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List<OpenStackVolume> volumes = null;
        if (isBatchQueryVolume) {
            volumes = volumeService.queryVolumesByUuid(regionUuid, projectUuid, volumeUuidList, isAutoFresh);
        } else {
            volumes = new ArrayList();
            for (String volumeUUID : volumeUuidList) {
                OpenStackVolume tempOpenStackVolume = volumeService.querySingleVolumeByUuid(regionUuid, projectUuid, volumeUUID);
                volumes.add(tempOpenStackVolume);
            }
        }
        if (VerifyUtil.isEmpty(volumes)) {
            return sharedVmUuidSet;
        }
        for (OpenStackVolume openStackVolume : volumes) {
            if (!openStackVolume.getShareable().booleanValue()) continue;
            openStackVolume.generateAttachmentInfo();
            Set attachments = openStackVolume.getAttachments();
            if (VerifyUtil.isEmpty((Collection)attachments)) continue;
            for (OpenStackVolAttachment openStackVolAttachment : attachments) {
                sharedVmUuidSet.add(openStackVolAttachment.getVmUuid());
            }
        }
        return sharedVmUuidSet;
    }

    public static Set<String> getShareOrScsiVmUuids(String regionUuid, String projectUuid, Set<String> volumeUuidSet) {
        if (VmChecker.supportSharedOrScsiVolume(regionUuid)) {
            logger.info((Object)("region regionUuid " + regionUuid + " support share or scsi volume."));
            return Collections.emptySet();
        }
        ArrayList<String> volumeUuidList = new ArrayList<String>(volumeUuidSet);
        HashSet<String> shareOrscsiVmSet = new HashSet<String>();
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumes = volumeService.queryVolumesByUuid(regionUuid, projectUuid, volumeUuidList, false);
        if (VerifyUtil.isEmpty((Collection)volumes)) {
            return shareOrscsiVmSet;
        }
        for (OpenStackVolume openStackVolume : volumes) {
            if (!VmChecker.isSharedOrScsiVolume(openStackVolume)) continue;
            openStackVolume.generateAttachmentInfo();
            Set attachments = openStackVolume.getAttachments();
            if (VerifyUtil.isEmpty((Collection)attachments)) continue;
            for (OpenStackVolAttachment openStackVolAttachment : attachments) {
                shareOrscsiVmSet.add(openStackVolAttachment.getVmUuid());
            }
        }
        return shareOrscsiVmSet;
    }

    public static Set<String> getVolumeShareOrScsiId(String regionUuid, String projectUuid, Set<String> volumeUuidSet) {
        if (VmChecker.supportSharedOrScsiVolume(regionUuid)) {
            return Collections.emptySet();
        }
        HashSet<String> shareOrScsiVolumeSet = new HashSet<String>();
        ArrayList<String> volumeUuidList = new ArrayList<String>(volumeUuidSet);
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List volumes = volumeService.queryVolumesByUuid(regionUuid, projectUuid, volumeUuidList, false);
        if (VerifyUtil.isEmpty((Collection)volumes)) {
            return shareOrScsiVolumeSet;
        }
        for (OpenStackVolume openStackVolume : volumes) {
            if (!VmChecker.isSharedOrScsiVolume(openStackVolume)) continue;
            shareOrScsiVolumeSet.add(openStackVolume.getUuid());
        }
        return shareOrScsiVolumeSet;
    }

    private static boolean isSharedOrScsiVolume(OpenStackVolume openStackVolume) {
        Boolean scsiFlag = false;
        if (!VerifyUtil.isEmpty((Map)openStackVolume.getMetadata())) {
            String scsiMess = (String)openStackVolume.getMetadata().get("hw:passthrough");
            scsiFlag = Boolean.valueOf(scsiMess);
        }
        return scsiFlag != false || openStackVolume.getMulitattach() != false;
    }

    public static boolean supportSharedOrScsiVolume(String regionUuid) {
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            logger.error((Object)"Regions is empty", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getSupportSharedVolumes();
    }
}

