/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.dao.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.meter.model.MeterRecord;
import com.huawei.ism.drm.meter.model.SDRRegion;
import com.huawei.ism.drm.openstack.serviceinstance.dao.IMeterDao;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.DataException;
import org.hibernate.query.Query;

public class MeterDao
implements IMeterDao {
    private static final Log logger = LogFactory.getInstance(MeterDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMeterRecord(MeterRecord meterRecord, MeterRecord meterRecordAfter) {
        Session session = null;
        try {
            logger.info((Object)"Save meter record. name: %s, type: %s, recordType: %s", new Object[]{meterRecord.getInstanceName(), meterRecord.getInstanceType(), meterRecord.getRecordType()});
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            HibernateUtil.beginTransaction((Session)session);
            session.save((Object)meterRecord);
            Criteria criteria = session.createCriteria(MeterRecord.class);
            criteria.add((Criterion)Restrictions.eq((String)"instanceId", (Object)meterRecord.getInstanceId()));
            criteria.add((Criterion)Restrictions.eq((String)"instanceType", (Object)meterRecord.getInstanceType()));
            criteria.add((Criterion)Restrictions.eq((String)"regionId", (Object)meterRecord.getRegionId()));
            criteria.add((Criterion)Restrictions.eq((String)"recordType", (Object)"meter_delete_fake"));
            criteria.add((Criterion)Restrictions.eq((String)"meterType", (Object)meterRecord.getMeterType()));
            List list = criteria.list();
            if ("meter_delete".equals(meterRecord.getRecordType())) {
                list.forEach(arg_0 -> ((Session)session).delete(arg_0));
            }
            if ("meter_update".equals(meterRecord.getRecordType()) && !VerifyUtil.isEmpty((Object)meterRecordAfter)) {
                Session finalSession = session;
                list.forEach(record -> {
                    record.setMeterValue(meterRecordAfter.getMeterValue());
                    finalSession.update(record);
                });
            }
            HibernateUtil.commit((Session)session);
            HibernateUtil.closeSession((Session)session);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to store meter.", (Throwable)e, 90160758786962L);
            HibernateUtil.rollbackSession(session);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SDRRegion> querySDRRegion(String regionId) {
        List list = Collections.EMPTY_LIST;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(SDRRegion.class);
            criteria.add((Criterion)Restrictions.eq((String)"regionId", (Object)regionId));
            list = criteria.list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Failed to store meter.", (Throwable)e, 90160758786962L);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
            HibernateUtil.closeSession((Session)session);
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSDRRegion(String regionId) {
        Session session;
        block4: {
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(SDRRegion.class);
                criteria.add((Criterion)Restrictions.eq((String)"regionId", (Object)regionId));
                if (!criteria.list().isEmpty()) break block4;
                SDRRegion sdrRegion = new SDRRegion();
                sdrRegion.setRegionId(regionId);
                sdrRegion.setRegisterTime(System.currentTimeMillis());
                session.save((Object)sdrRegion);
            }
            catch (DataException e) {
                try {
                    logger.error((Object)"Failed to save sdr region.", (Throwable)e, 90160758786892L);
                }
                catch (Throwable throwable) {
                    HibernateUtil.closeSession(session);
                    throw throwable;
                }
                HibernateUtil.closeSession((Session)session);
            }
        }
        HibernateUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MeterRecord> queryAllMeterRecord() {
        List recordList = Collections.EMPTY_LIST;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(MeterRecord.class);
            criteria.add((Criterion)Restrictions.eq((String)"recordType", (Object)"meter_create"));
            recordList = criteria.list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Failed to query meter.", (Throwable)e, 90160758786962L);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
            HibernateUtil.closeSession((Session)session);
        }
        HibernateUtil.closeSession((Session)session);
        return recordList;
    }

    @Override
    public List<MeterRecord> queryMeterInfos(String regionId, String serviceName, String startTime) {
        List recordList;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(MeterRecord.class);
            criteria.add((Criterion)Restrictions.gt((String)"recordTime", (Object)startTime));
            criteria.add((Criterion)Restrictions.eq((String)"regionId", (Object)regionId));
            criteria.add((Criterion)Restrictions.eq((String)"instanceType", (Object)serviceName));
            recordList = criteria.list();
        }
        catch (DataException e) {
            try {
                logger.error((Object)"Failed to store meter.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(0x300001L);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOverdueMeter() {
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            HibernateUtil.beginTransaction((Session)session);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(2, -3);
            calendar.add(5, -1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String time3MonthAgo = sdf.format(calendar.getTime());
            Criteria criteria = session.createCriteria(MeterRecord.class);
            criteria.add((Criterion)Restrictions.lt((String)"recordTime", (Object)time3MonthAgo));
            List list = criteria.list();
            list.forEach(arg_0 -> ((Session)session).delete(arg_0));
            HibernateUtil.commit((Session)session);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Failed to store meter.", (Throwable)e, 90160758786962L);
                HibernateUtil.rollbackSession((Session)session);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
            HibernateUtil.closeSession((Session)session);
        }
        HibernateUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMeterRecord(String instId, String instName) {
        Session session = null;
        try {
            logger.info((Object)"Update meter record. instId: %s, instName: %s", new Object[]{instId, instName});
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            Query query = session.createQuery("update MeterRecord as record set record.instName = :instName where record.instanceId = :instId");
            query.setParameter("instName", (Object)instName);
            query.setParameter("instId", (Object)instId);
            query.executeUpdate();
            session.getTransaction().commit();
            HibernateUtil.closeSession((Session)session);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update meter.", (Throwable)e, 90160758786962L);
            HibernateUtil.rollbackSession(session);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }
}

