/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.fault;

import com.huawei.ism.drm.openstack.sdk.bo.AlarmRecord;
import com.huawei.ism.drm.openstack.sdk.bo.OcAlarmBO;
import com.huawei.ism.drm.openstack.sdk.service.ICloudServiceFaultService;
import com.huawei.ism.drm.openstack.serviceinstance.fault.OcFaultMsgHandler;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.ICloudServiceFaultService", Desc="", Interface=ICloudServiceFaultService.class)
public class CloudServiceFaultServiceImp
extends BaseService
implements ICloudServiceFaultService {
    private static final Log logger = LogFactory.getInstance(CloudServiceFaultServiceImp.class);
    private IFaultHandler handler;
    private OcFaultMsgHandler ocFaultMsgHandler;

    public IFaultHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IFaultHandler handler) {
        this.handler = handler;
    }

    public OcFaultMsgHandler getOcFaultMsgHandler() {
        return this.ocFaultMsgHandler;
    }

    public void setOcFaultMsgHandler(OcFaultMsgHandler ocFaultMsgHandler) {
        this.ocFaultMsgHandler = ocFaultMsgHandler;
    }

    public List<String> clearAlarm(List<OcAlarmBO> clearAlarms) {
        if (clearAlarms.isEmpty()) {
            logger.error((Object)"clearAlarms is empty");
            throw new LegoCheckedException(1073947393L);
        }
        IAlarmService alarmservice = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
        ArrayList<String> failureIdList = new ArrayList<String>();
        for (OcAlarmBO ocAlarmBO : clearAlarms) {
            String matchKey = ocAlarmBO.getMatchKey();
            logger.debug((Object)("clear alarm matchKey: " + matchKey));
            try {
                alarmservice.clearAlarms(matchKey, "admin", true);
                logger.info((Object)("Clear alarm successful," + ocAlarmBO.getMatchKey()));
            }
            catch (Exception e) {
                failureIdList.add(matchKey);
                logger.error((Object)("Clear alarm error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return failureIdList;
    }

    public void synchronizeAlarm(long startTime, long endTime) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (0L != startTime) {
            map.put("createTimeStart", String.valueOf(startTime));
            map.put("createTimeEnd", String.valueOf(endTime));
        }
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(0);
        queryInfo.setTotalRow(Integer.MAX_VALUE);
        queryInfo.setOrderByField("createTime");
        queryInfo.setOrderByAscend(true);
        IAlarmService alarmservice = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
        List alarmList = alarmservice.getAlarmList(null, map, queryInfo, -1L);
        StringBuilder builder = new StringBuilder();
        for (LegoAlarm legoAlarm : alarmList) {
            this.getHandler().notify(legoAlarm, null);
            builder.append(legoAlarm.getAlarmId()).append(", ");
        }
        logger.debug((Object)"notifyAlarm: %s , size : %s", new Object[]{builder.toString(), alarmList.size()});
    }

    public HashMap<String, List> reverseClearAlarm(List<AlarmRecord> clearList) {
        if (VerifyUtil.isEmpty(clearList)) {
            logger.error((Object)"ReverseClearAlarms is empty");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, List> resultMap = new HashMap<String, List>();
        ArrayList<AlarmRecord> successList = new ArrayList<AlarmRecord>();
        ArrayList<AlarmRecord> failedList = new ArrayList<AlarmRecord>();
        IAlarmService alarmService = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
        for (AlarmRecord alarmRecord : clearList) {
            String matchKey = alarmRecord.getMatchKey();
            logger.debug((Object)"Clear alarm matchKey: %s", new Object[]{matchKey});
            try {
                alarmService.clearAlarms(matchKey, "admin", true);
                logger.info((Object)"ReverseClear alarm successful, alarm matchKey is %s", new Object[]{matchKey});
            }
            catch (Exception e) {
                failedList.add(alarmRecord);
                logger.error((Object)"ReverseClear alarm error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                continue;
            }
            successList.add(alarmRecord);
        }
        resultMap.put("successLists", successList);
        resultMap.put("failLists", failedList);
        return resultMap;
    }

    public List<OcAlarmBO> checkAlarm(List<AlarmRecord> checkList) {
        List<OcAlarmBO> occlearedList;
        ArrayList<LegoAlarm> bcclearedList = new ArrayList<LegoAlarm>();
        try {
            for (AlarmRecord alarmRecord : checkList) {
                String matchKey = alarmRecord.getMatchKey();
                IAlarmService alarmService = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
                LegoAlarm legoAlarm = alarmService.getAlarm(matchKey);
                logger.debug((Object)"Check alarm matchKey: %s , status: %s", new Object[]{matchKey, legoAlarm.getClearStatus().getValue()});
                if (FaultEnum.ClearState.CLEARED.getValue() != legoAlarm.getClearStatus().getValue()) continue;
                logger.debug((Object)"LegoAlarm has been cleared , legoAlarm name is: %s", new Object[]{legoAlarm.getAlarmName()});
                bcclearedList.add(legoAlarm);
            }
            occlearedList = this.getOcFaultMsgHandler().alarmTransform(bcclearedList);
            StringBuilder builder = new StringBuilder();
            occlearedList.stream().forEach(ocClearedAlarm -> {
                ocClearedAlarm.setClearUtc(ocClearedAlarm.getClearUtc() * 1000L);
                ocClearedAlarm.setOccurUtc(ocClearedAlarm.getOccurUtc() * 1000L);
                builder.append(ocClearedAlarm.getMoi()).append(",");
            });
            logger.debug((Object)"CheckAlarmResult: %s , size : %s", new Object[]{builder.toString(), occlearedList.size()});
        }
        catch (Exception e) {
            logger.error((Object)"Check Alarm error : %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947393L);
        }
        return occlearedList;
    }

    public Paging syncAlarm(long startTime, long endTime, int offset, int limit) {
        Paging paging = new Paging();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (startTime > 0L) {
                map.put("createTimeStart", String.valueOf(startTime));
                map.put("createTimeEnd", String.valueOf(endTime));
            }
            FaultQueryInfo queryInfo = new FaultQueryInfo();
            queryInfo.setFirstRowIndex(0);
            queryInfo.setTotalRow(Integer.MAX_VALUE);
            queryInfo.setOrderByField("createTime");
            queryInfo.setOrderByAscend(true);
            IAlarmService alarmService = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
            List legoAlarmList = alarmService.getAlarmList(FaultEnum.ClearState.UNCLEARED, map, queryInfo, -1L);
            List reportAlarmList = legoAlarmList.stream().filter(e -> this.getOcFaultMsgHandler().isReportOc(e.getAlarmId())).collect(Collectors.toList());
            paging.setiCount(reportAlarmList.size());
            List<LegoAlarm> result = reportAlarmList.subList(Math.min(offset, reportAlarmList.size()), Math.min(limit + offset, reportAlarmList.size()));
            List<OcAlarmBO> ocAlarmBOList = this.getOcFaultMsgHandler().alarmTransform(result);
            StringBuilder builder = new StringBuilder();
            ocAlarmBOList.stream().forEach(ocAlarmBO -> {
                ocAlarmBO.setOccurUtc(ocAlarmBO.getOccurUtc() * 1000L);
                builder.append(ocAlarmBO.getMoi()).append(",");
            });
            paging.setData(ocAlarmBOList);
            logger.debug((Object)"SyncAlarm: %s , size : %s", new Object[]{builder.toString(), ocAlarmBOList.size()});
        }
        catch (Exception e2) {
            logger.error((Object)"Sync Alarm error : %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
            throw new LegoCheckedException(-1L);
        }
        return paging;
    }
}

