/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.fault;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.DelReplicationTask;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.CloudAvailableZone;
import com.huawei.ism.drm.openstack.sdk.msg.CloudInfra;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.model.InstanceOrder;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.lego.cbb.i18n.sdk.I18nMrg;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IScOperationService", Desc="", Interface=IScOperationService.class)
public class ScOperationServiceImp
implements IScOperationService {
    private static Log logger = LogFactory.getInstance(ScOperationServiceImp.class);
    private static final String ACTION_UPDATE = "update";
    private static final String ACTION_DELETE = "delete";
    private static final String REPROT_ORDER_URL = "/rest/subscription/v3.0/subscriptions/";
    private static final int MAX_LENGTH = 1000;
    private static final LegoMoGenerator LEGOMOGENERATOR = new LegoMoGenerator();
    private I18nMrg i18nMgr;

    public I18nMrg getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public void reportOrderResult(String status, List<OrderInstanceInfo> instances, String quotas, String subscriptionId) {
        if (VerifyUtil.isEmpty((String)status) || VerifyUtil.isEmpty(instances) || VerifyUtil.isEmpty((String)subscriptionId)) {
            logger.error((Object)("report Order Result is null, status: " + status + " instances: " + instances + " subscriptionId: " + subscriptionId));
            return;
        }
        ScOperationServiceImp.deleteOrder(subscriptionId);
        JSONObject result = this.createOrderResult(status, instances, quotas);
        String tokenId = null;
        String projectId = null;
        try {
            FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
            String openstackUuid = openstack.getUuid();
            projectId = ((OrderInstanceInfo)CommonUtil.getFirstElement(instances)).getProjectId();
            tokenId = TokenUtil.getInstance().getTokenId(openstackUuid + ":" + projectId);
        }
        catch (LegoCheckedException t) {
            logger.error((Object)"get openstackUuid or tokenId fail", (Throwable)t);
        }
        try {
            String url = REPROT_ORDER_URL + subscriptionId + "/result";
            this.sendOrderResult(tokenId, result.toString(), url);
        }
        catch (LegoCheckedException t) {
            logger.error((Object)"report Order Result fail", (Throwable)t);
            InstanceOrder order = new InstanceOrder();
            order.setSubscriptionId(subscriptionId);
            order.setOrderResult(result.toString());
            order.setProjectId(projectId);
            order.setStatus(status);
            order.setRetryTimes(1);
            this.changeInstanceOrder(order, ACTION_UPDATE);
        }
    }

    private static void deleteOrder(String subscriptionId) {
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getMoDao().getHibernateTemplate();
        try {
            InstanceOrder order = new InstanceOrder();
            order.setSubscriptionId(subscriptionId);
            hibernateTemplate.delete((Object)order);
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to delete Instance Order.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void retrySendOrderResult() {
        List list;
        try {
            String hql = "from InstanceOrder";
            list = CommonDAOLocator.getBaseDao().find(hql, new Object[0]);
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to query InstanceOrder.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (list.size() == 0) {
            logger.info((Object)"no failed report InstanceOrder");
            return;
        }
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
        String uuid = openstack.getUuid();
        for (InstanceOrder order : list) {
            int times = order.getRetryTimes() + 1;
            String subscriptionId = order.getSubscriptionId();
            String projectId = order.getProjectId();
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.EXECUTING.getValue().equals(order.getStatus())) {
                logger.debug((Object)("order status is excuting, times: " + times));
                if (times < 24) {
                    order.setRetryTimes(times);
                } else {
                    order.setStatus(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.FAILED.getValue());
                    order.setRetryTimes(0);
                }
                this.changeInstanceOrder(order, ACTION_UPDATE);
                return;
            }
            String tokenId = TokenUtil.getInstance().getTokenId(uuid + ":" + projectId);
            try {
                String url = REPROT_ORDER_URL + subscriptionId + "/result";
                this.sendOrderResult(tokenId, order.getOrderResult(), url);
                this.changeInstanceOrder(order, ACTION_DELETE);
                AlarmReporter.restoreAlarm((long)52625479L, (String[])new String[]{subscriptionId});
            }
            catch (LegoCheckedException t) {
                logger.error((Object)("retry report orderresult fail, the id is " + subscriptionId + ExceptionUtil.getErrorMessage((Throwable)t)), 90160758784257L);
                if (times >= 24) {
                    AlarmReporter.sendAlarm((long)52625479L, (String)subscriptionId, (String)FaultEnum.AlarmResourceType.UNDEFINED.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])this.getAlarmLocationParam(subscriptionId));
                    continue;
                }
                order.setRetryTimes(times);
                this.changeInstanceOrder(order, ACTION_UPDATE);
            }
        }
    }

    public void recordingOrder(Map<String, Object> extendParam) {
        if (!extendParam.containsKey("order_instinfo") || !extendParam.containsKey("subscription_id")) {
            logger.error((Object)("Order Result param is empty, extendParam: " + extendParam));
            return;
        }
        OrderInstanceInfo order = (OrderInstanceInfo)extendParam.get("order_instinfo");
        order.setResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.FAILED.getValue());
        ArrayList<OrderInstanceInfo> instances = new ArrayList<OrderInstanceInfo>();
        instances.add(order);
        JSONObject result = this.createOrderResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.FAILED.getValue(), instances, null);
        InstanceOrder instanceOrder = new InstanceOrder();
        instanceOrder.setSubscriptionId(extendParam.get("subscription_id").toString());
        instanceOrder.setOrderResult(result.toString());
        instanceOrder.setProjectId(order.getProjectId());
        instanceOrder.setStatus(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.EXECUTING.getValue());
        instanceOrder.setRetryTimes(0);
        try {
            this.changeInstanceOrder(instanceOrder, ACTION_UPDATE);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("recording Order fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private JSONObject createOrderResult(String status, List<OrderInstanceInfo> instances, String quotas) {
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)status);
        Locale znLocal = new Locale("zh", "CN");
        Locale enLocal = new Locale("en");
        JSONArray instanceList = new JSONArray();
        for (OrderInstanceInfo inst : instances) {
            HashMap<String, String> instance = new HashMap<String, String>();
            instance.put("result", inst.getResult());
            instance.put("instance_id", inst.getInstanceId());
            instance.put("instance_name", inst.getInstanceName());
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(inst.getInstanceType()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(inst.getInstanceType())) {
                instance.put("instance_type", ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue());
            } else {
                instance.put("instance_type", ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getServiceIdFromServiceType((String)inst.getInstanceType()));
            }
            if (!VerifyUtil.isEmpty((String)inst.getProductId())) {
                instance.put("product_id", inst.getProductId());
            }
            instance.put("region_id", inst.getRegionId());
            instance.put("project_id", inst.getProjectId());
            if (!VerifyUtil.isEmpty((String)inst.getErrorCode())) {
                String messageZn;
                instance.put("error_code", inst.getErrorCode());
                String messageEn = this.i18nMgr.getString(inst.getErrorCode(), enLocal, inst.getParam());
                if (messageEn.length() > 1000) {
                    messageEn = messageEn.substring(0, 1000);
                }
                if ((messageZn = this.i18nMgr.getString(inst.getErrorCode(), znLocal, inst.getParam())).length() > 1000) {
                    messageZn = messageZn.substring(0, 1000);
                }
                JSONObject errorInfo = new JSONObject();
                errorInfo.put((Object)"zh_CN", (Object)messageZn);
                errorInfo.put((Object)"en_US", (Object)messageEn);
                instance.put("message", errorInfo.toString());
            }
            instanceList.add(instance);
            this.reportVolume(instanceList, inst);
        }
        result.put((Object)"instances", (Object)instanceList);
        if (null != quotas) {
            result.put((Object)"extend_quotas", (Object)JSONArray.fromObject((Object)quotas));
        }
        return result;
    }

    private void reportVolume(JSONArray instanceList, OrderInstanceInfo inst) {
        String dupKey;
        HashSet<String> dupSet;
        List beforeDrVolList = inst.getBeforeDrVolList();
        String beforeStutas = inst.getBeforeStutas();
        ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE operateType = inst.getOperateType();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_INSTANCE.equals((Object)operateType) && DelReplicationTask.NO_ALLOWDELETE_STATUS.contains(beforeStutas)) {
            logger.info((Object)"delete instance:%s when status is unnormal, no need report volume info.", new Object[]{inst.getInstanceId()});
            return;
        }
        beforeDrVolList = beforeDrVolList == null ? new ArrayList() : beforeDrVolList;
        List<OpenStackVolume> currentDrVolList = OpenStackCommonUtil.findAllDrVolumes(inst.getInstanceId());
        ArrayList<OpenStackVolume> reportVolume = new ArrayList<OpenStackVolume>();
        if (currentDrVolList.size() >= beforeDrVolList.size()) {
            dupSet = new HashSet<String>();
            for (OpenStackVolume volume : beforeDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                dupSet.add(dupKey);
            }
            for (OpenStackVolume volume : currentDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                if (dupSet.contains(dupKey)) continue;
                reportVolume.add(volume);
            }
        } else {
            dupSet = new HashSet();
            for (OpenStackVolume volume : currentDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                dupSet.add(dupKey);
            }
            for (OpenStackVolume volume : beforeDrVolList) {
                dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                if (dupSet.contains(dupKey)) continue;
                reportVolume.add(volume);
            }
        }
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        for (OpenStackVolume volume : reportVolume) {
            HashMap<String, String> volumeMap = new HashMap<String, String>();
            volumeMap.put("result", inst.getResult());
            volumeMap.put("region_id", OpenStackCommonUtil.getIdFromUuid(volume.getRegionUuid()));
            volumeMap.put("project_id", OpenStackCommonUtil.getIdFromUuid(volume.getProjUuid()));
            volumeMap.put("instance_id", OpenStackCommonUtil.getIdFromUuid(volume.getUuid()));
            volumeMap.put("instance_name", volume.getName());
            volumeMap.put("instance_type", quotaService.getEVSServiceId());
            instanceList.add(volumeMap);
        }
    }

    private void changeInstanceOrder(InstanceOrder order, String action) {
        try {
            if (action.equals(ACTION_UPDATE)) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)order);
            } else if (action.equals(ACTION_DELETE)) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)order);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to change Instance Order.", (Throwable)e, 90160758786896L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void updateProjectQuotas(String regionId, String projectId, String quotas) {
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)quotas)) {
            logger.error((Object)("param is null, regionId: " + regionId + " projectId: " + projectId + " quotas: " + quotas));
            return;
        }
        try {
            FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
            String openstackUuid = openstack.getUuid();
            String tokenId = TokenUtil.getInstance().getTokenId(openstackUuid + ":" + projectId);
            String url = "/rest/vdc/v3.0/quotas/regions/" + regionId;
            this.sendOrderResult(tokenId, quotas, url);
        }
        catch (Exception t) {
            logger.error((Object)("update Project Quotas fail:" + ExceptionUtil.getErrorMessage((Throwable)t)));
        }
    }

    protected void sendOrderResult(String tokenId, String message, String url) {
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)message) || VerifyUtil.isEmpty((String)url)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        CloudConfig accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("manageOne");
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            logger.error((Object)"accessInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String adderss = "https://" + domain + ":" + port;
        String urlStr = adderss + url;
        logger.debug((Object)("put message to SC, urlStr: " + urlStr));
        ClientUtil.sendPutRequest(urlStr, message, tokenId);
    }

    public List<CloudInfra> queryCloudInfras() {
        HashMap uriVariables;
        if (VerifyUtil.isEmpty((Object)OpenStackCommonUtil.getOpenstack())) {
            return Collections.emptyList();
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        if (VerifyUtil.isEmpty((Object)open)) {
            return Collections.emptyList();
        }
        CloudConfig accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("manageOne");
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            logger.error((Object)"accessInfo is empty");
            return Collections.emptyList();
        }
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String adderss = "https://" + domain + ":" + port;
        String urlStr = adderss + "/rest/serviceaccess/v3.0/cloud-infras";
        String respStr = ClientUtil.sendGetRequest(urlStr, uriVariables = new HashMap(), tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"Failed to get cloudInfras.response string is empty");
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"records")) {
            JSONArray jsonArray = json.getJSONArray("records");
            List cloudInfraList = JSONArray.toCollection((JSONArray)jsonArray, CloudInfra.class);
            return cloudInfraList;
        }
        logger.error((Object)"Failed to get records,request");
        return Collections.emptyList();
    }

    public List<CloudAvailableZone> queryAvailableZones(String cloudInfraId) {
        if (VerifyUtil.isEmpty((Object)OpenStackCommonUtil.getOpenstack())) {
            return Collections.emptyList();
        }
        CloudConfig accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("manageOne");
        if (VerifyUtil.isEmpty((Object)accessInfo)) {
            logger.error((Object)"accessInfo is empty");
            return Collections.emptyList();
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String domain = (String)accessInfo.getProps().get("manageOne_domain");
        String port = (String)accessInfo.getProps().get("manageOne_port");
        String adderss = "https://" + domain + ":" + port;
        String urlStr = adderss + "/rest/serviceaccess/v3.0/available-zones?cloud_infra_id={cloud_infra_id}";
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("cloud_infra_id", cloudInfraId);
        String respStr = ClientUtil.sendGetRequest(urlStr, uriVariables, tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"Failed to get availableZones.response string is empty");
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"records")) {
            JSONArray jsonArray = json.getJSONArray("records");
            List cloudInfraList = JSONArray.toCollection((JSONArray)jsonArray, CloudAvailableZone.class);
            return cloudInfraList;
        }
        logger.error((Object)"Failed to get records,request");
        return Collections.emptyList();
    }

    private String[] getAlarmLocationParam(String subscriptionId) {
        CloudConfig accessInfo = ((ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class)).getCloudConfigBy("manageOne");
        String[] locationParams = new String[]{subscriptionId, VerifyUtil.isEmpty((Object)accessInfo) ? "" : (String)accessInfo.getProps().get("manageOne_domain"), VerifyUtil.isEmpty((Object)accessInfo) ? "" : (String)accessInfo.getProps().get("manageOne_port"), LEGOMOGENERATOR.getInstallServerIp()};
        return locationParams;
    }
}

