/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.listener;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.serviceinstance.AutoDeleteMeterRecords;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReportInstanceOrderInfo;
import com.huawei.ism.drm.openstack.serviceinstance.AutoReportMetersInfo;
import com.huawei.ism.drm.openstack.serviceinstance.CheckArbitrationStatus;
import com.huawei.ism.drm.openstack.serviceinstance.CheckIntanceConfig;
import com.huawei.ism.drm.openstack.serviceinstance.CheckLicenseTimeoutTask;
import com.huawei.ism.drm.openstack.serviceinstance.SDRRegisterHelper;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.serviceinstance.UpdateVolTypeMappingTask;
import com.huawei.ism.drm.openstack.system.unitepassword.task.IAMregistask;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ServiceInstanceInitializer
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(ServiceInstanceInitializer.class);
    private static final Long DEFAULT_INTERVAL = 43200000L;
    private static final Long DEFAULT_DELAY = 600000L;

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            logger.info((Object)"the status started, begin check instance");
            Timer timer = new Timer(true);
            CheckIntanceConfig task = new CheckIntanceConfig();
            timer.schedule((TimerTask)task, DEFAULT_DELAY, (long)DEFAULT_INTERVAL);
            Timer meterTimer = new Timer(true);
            AutoReportMetersInfo reportMeterInfo = new AutoReportMetersInfo();
            meterTimer.schedule((TimerTask)reportMeterInfo, 600000L, 3600000L);
            this.deleteMeterRecords();
            Timer orderTimer = new Timer(true);
            AutoReportInstanceOrderInfo reportOrderInfo = new AutoReportInstanceOrderInfo();
            orderTimer.schedule((TimerTask)reportOrderInfo, 1800000L, 3600000L);
            Timer checkTimer = new Timer(true);
            CheckArbitrationStatus checkArbTask = new CheckArbitrationStatus();
            checkTimer.schedule((TimerTask)checkArbTask, 0L, 10000L);
            Timer licenseCheckTimer = new Timer(true);
            CheckLicenseTimeoutTask checkLicenseTimeoutTask = new CheckLicenseTimeoutTask();
            licenseCheckTimer.schedule((TimerTask)checkLicenseTimeoutTask, 3600000L, 86400000L);
            Timer updateVolTypeMappingTimer = new Timer(true);
            UpdateVolTypeMappingTask updateVolTypeMappingTask = new UpdateVolTypeMappingTask(updateVolTypeMappingTimer);
            updateVolTypeMappingTimer.schedule((TimerTask)updateVolTypeMappingTask, 60000L, 300000L);
            this.changeInstanceStatus();
            this.checkInstanceMeterRecords();
            SDRRegisterHelper.getInstance().registerSDR();
            Timer iamTimer = new Timer(true);
            IAMregistask iamregistask = new IAMregistask();
            iamTimer.schedule((TimerTask)iamregistask, 1800000L, DEFAULT_INTERVAL * 2L);
        }
    }

    private void deleteMeterRecords() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 2);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        if (date.before(new Date())) {
            Calendar startDT = Calendar.getInstance();
            startDT.setTime(date);
            startDT.add(5, 1);
            date = startDT.getTime();
        }
        Timer meterRecordTimer = new Timer(true);
        AutoDeleteMeterRecords deleteMeterRecords = new AutoDeleteMeterRecords();
        meterRecordTimer.schedule((TimerTask)deleteMeterRecords, date, 86400000L);
    }

    private void checkInstanceMeterRecords() {
        IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
        meterService.checkInstanceMeterRecords();
    }

    private void changeInstanceStatus() {
        logger.info((Object)"enter change instance status1");
        try {
            List serviceInsList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ServiceInstance", new Object[0]);
            if (VerifyUtil.isEmpty((Collection)serviceInsList)) {
                logger.info((Object)"no serviceinstance to change status");
                return;
            }
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            for (ServiceInstance instance : serviceInsList) {
                String status = instance.getStatus();
                ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E statusEnum = ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.getType((String)status);
                if (null == statusEnum) {
                    logger.info((Object)("the status is invalid:" + status));
                    continue;
                }
                String planId = instance.getRecoveryPlanId();
                RecoveryPlan plan = planService.getRecoveryPlan(planId);
                ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E targetStatusEnum = this.getTargetStatus(plan, statusEnum);
                if (targetStatusEnum.equals((Object)statusEnum)) continue;
                logger.info((Object)("change instance status from" + statusEnum + " to " + targetStatusEnum));
                ServiceInstanceHelper.getInstance().changeStatus(instance.getId(), targetStatusEnum);
            }
        }
        catch (Exception e) {
            logger.error((Object)("change serviceinstace status failed," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E getTargetStatus(RecoveryPlan plan, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E currentStatus) {
        ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E targetStatusEnum = currentStatus;
        switch (currentStatus) {
            case TESTING: {
                targetStatusEnum = this.getStatusForTest(plan);
                break;
            }
            case HOT_MIGRATION_RUNNING: {
                targetStatusEnum = this.getStatusForHotMigration(plan);
                break;
            }
            case PLANED_MIGRATION_RUNNING: {
                targetStatusEnum = this.getStatusForPlanMigration(plan);
                break;
            }
            case DISASTER_RECOVERY_RUNNING: {
                targetStatusEnum = this.getStatusForDisasterRecovery(plan);
                break;
            }
            case REPROTECT_RUNNING: {
                targetStatusEnum = this.getStatusForReprotect(plan);
                break;
            }
            case LOCKED: {
                targetStatusEnum = ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL;
                break;
            }
            case DELETING: {
                targetStatusEnum = ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_DELETE;
                break;
            }
            default: {
                logger.info((Object)("will not change status, currentStatus=" + currentStatus));
            }
        }
        return targetStatusEnum;
    }

    private ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E getStatusForReprotect(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL;
        }
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED;
    }

    private ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E getStatusForDisasterRecovery(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED;
        }
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED;
    }

    private ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E getStatusForPlanMigration(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL;
        }
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED;
    }

    private ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E getStatusForHotMigration(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL;
        }
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_FAILED;
    }

    private ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E getStatusForTest(RecoveryPlan plan) {
        if (null != plan && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED.getValue() == plan.getPlanStatus()) {
            return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTED;
        }
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_TEST;
    }
}

