/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.concurrent.CountDownLatch;

public class CheckInstanceConfigTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(CheckInstanceConfigTask.class);
    private static final int DEFAULT_TIMEOUT = 3000;
    private ServiceInstance serviceInstance;
    private CountDownLatch cdl;
    private boolean isManual;

    public CheckInstanceConfigTask(ServiceInstance instance, CountDownLatch cdl, boolean isManual) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instance.getName(), (String)"ism.drm.pg.instance.check", (String)instance.getProjectId(), (String)instance.getType(), (String)"", null), 3000, true);
        this.serviceInstance = instance;
        this.isManual = isManual;
        this.cdl = cdl;
    }

    protected void doWork() {
        try {
            this.doWorkTask();
        }
        finally {
            if (this.cdl != null) {
                this.cdl.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkTask() {
        ProtectGroup protectGroup = null;
        if (null == this.serviceInstance) {
            logger.error((Object)"Failed to check instance config.serviceInstance is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ServiceInstanceHelper.getInstance().getLock(this.serviceInstance.getId())) {
            logger.error((Object)("Failed to check instance config.not get this instance lock,instanceId:" + this.serviceInstance.getId() + ",instanceName=" + this.serviceInstance.getName()));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            ServiceInstance inst = ServiceInstanceHelper.getInstance().changeStatus(this.serviceInstance.getId(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.LOCKED);
            logger.debug((Object)("check instance config. the inst status changed: " + inst.getStatus() + ",instanceName=" + this.serviceInstance.getName()));
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            protectGroup = pgService.getProtectGroupByID(this.serviceInstance.getProtectGroupId(), true);
            if (null == protectGroup) {
                logger.error((Object)("Failed to check instance config.protectGroup is null. protectGroupId=" + this.serviceInstance.getProtectGroupId() + ",instanceName=" + this.serviceInstance.getName()));
                throw new LegoCheckedException(2117645L);
            }
            OpenstackPgRefreshServiceImpl refreshService = new OpenstackPgRefreshServiceImpl();
            if (!this.isManual) {
                protectGroup.setProperty("isManualRefresh", (Object)Integer.toString(0));
            }
            refreshService.refreshProtectGroup(protectGroup);
        }
        finally {
            ServiceInstanceHelper.getInstance().releaseLock(this.serviceInstance.getId());
            try {
                ServiceInstanceHelper.getInstance().changeStatus(this.serviceInstance.getId(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL);
            }
            catch (Exception e) {
                logger.error((Object)("set instance(" + this.serviceInstance.getId() + ") normal error." + ExceptionUtil.getErrorMessage((Throwable)e) + ",instanceName=" + this.serviceInstance.getName()));
            }
        }
    }
}

