/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.protection.service.ReattachProtectGroupVolumeBackTask;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.ProtectExecutingVmsQueue;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVmUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateServerTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(CreateServerTask.class);
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final int CREATE_VM_TIMEOUT = 2147483;
    private static final int MONITORINTERVAL = 10;
    private String instanceId;
    private String instanceName;
    private Set<ProtectObject> addServerSet;

    public CreateServerTask(String proId, String type, String instanceId, String instanceName, Set<ProtectObject> protectObjectSet) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instanceName, (String)"ism.drm.instance.vm.add", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.instanceId = instanceId;
        this.instanceName = instanceName;
        this.addServerSet = protectObjectSet;
    }

    protected void doWork() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
        }
        IServiceInstanceService instService = (IServiceInstanceService)ServiceLocator.getInstance().getService(IServiceInstanceService.class);
        instService.checkAddServerParam(this.instanceId, this.addServerSet);
        OpenStackCheckPhVmUtil.checkPhVmsAndRun(this.addServerSet, this::work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        this.quataCheck();
        if (!ServiceInstanceHelper.getInstance().getLock(this.instanceId)) {
            logger.error((Object)("not get this instance lock,instanceId:" + this.instanceId));
            throw new LegoCheckedException(1073948693L);
        }
        ArrayList<String> poVmids = new ArrayList<String>();
        try {
            ServiceInstance instance = ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.LOCKED);
            String pgId = instance.getProtectGroupId();
            this.vmsQueueOffer(poVmids, instance);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            Map meterInfos = meterService.calculateMeterInfos(pg);
            meterInfos.put("change_type", "inst_update");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            if (!this.createServer(pgId)) {
                logger.error((Object)("Not support create this server,pgId:" + pgId));
                throw new LegoCheckedException(1073948110L);
            }
            OpenStackCommonUtil.updateRecoverySetting(instance.getRecoveryPlanId(), this.addServerSet);
            pg = this.reportChangeMeterInfo(instance, meterService, meterInfos);
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.SUCCESSED.getValue(), this.getExtendParam(), null, null);
            }
            if (OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(pg.getTemplate().getType())) {
                ReattachProtectGroupVolumeBackTask reattachTask = new ReattachProtectGroupVolumeBackTask(pg, "System");
                reattachTask.setTaskId(pg.getUuid() + "_reMappingVol");
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)reattachTask);
            }
        }
        finally {
            poVmids.stream().forEach(poVmid -> ProtectExecutingVmsQueue.remove(poVmid));
            this.refreshPg();
            ServiceInstanceHelper.getInstance().releaseLock(this.instanceId);
            try {
                ServiceInstanceHelper.getInstance().changeStatus(this.instanceId, ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL);
            }
            catch (Exception e) {
                logger.error((Object)("set instance(" + this.instanceName + ") normal error."), (Throwable)e);
            }
        }
    }

    private void vmsQueueOffer(List<String> poVmids, ServiceInstance instance) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String regionId = (String)pg.getProps().get("regionId");
        this.addServerSet.stream().forEach(po -> {
            String poVmId = CommUtil.combineString((String[])new String[]{regionId, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid())});
            if (ProtectExecutingVmsQueue.isContainVm(poVmId)) {
                logger.info((Object)"ProtectExecutingVmsQueue has poVmId:%s", new Object[]{poVmId});
                return;
            }
            poVmids.add(poVmId);
            ProtectExecutingVmsQueue.offer(poVmId);
        });
    }

    private ProtectGroup reportChangeMeterInfo(ServiceInstance instance, IMeterService meterService, Map<String, Object> meterInfos) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        meterService.reportChangedMeterInfo(regionUuid, instance, openstackUuid, meterInfos);
        meterService.reportChangedMeterInfo(drRegionUuid, instance, openstackUuid, meterInfos);
        return pg;
    }

    private void quataCheck() {
        OpenstackCache.run(() -> {
            int addVolumeSize = this.addServerSet.stream().mapToInt(b -> JSONArray.fromObject(b.getProps().get("volumeConfig")).size()).sum();
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
            OpenStackCommonUtil.checkPgVolumeCounts(instance.getProtectGroupId(), addVolumeSize);
            OpenStackCommonUtil.checkPgVmCounts(instance.getProtectGroupId(), this.addServerSet.size());
            IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
            String result = quotaService.checkAddServerOutOfQuota(this.instanceId, this.addServerSet);
            if (!VerifyUtil.isEmpty((String)result)) {
                String[] param = result.split(":");
                logger.error((Object)"Create server out of quota:instanceName: %s", new Object[]{this.instanceName});
                throw new LegoCheckedException(1073948125L, param, "Create server failed.");
            }
            return null;
        });
    }

    private void refreshPg() {
        try {
            ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)this.instanceId));
            if (null == instance) {
                logger.info((Object)("instance(" + this.instanceId + ") is not exist."));
                throw new LegoCheckedException(201L, "instance(" + this.instanceId + ") is not exist.");
            }
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = pgService.getProtectGroupByID(instance.getProtectGroupId(), true);
            if (null == protectGroup) {
                logger.error((Object)"protectGroup is null");
                throw new LegoCheckedException(2117645L);
            }
            OpenstackPgRefreshServiceImpl refreshService = new OpenstackPgRefreshServiceImpl();
            refreshService.refreshProtectGroup(protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)("instance check failed instanceId : " + this.instanceId + " and refresh failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private boolean createServer(String pgId) {
        int times;
        if (VerifyUtil.isEmpty((String)pgId)) {
            return false;
        }
        long taskId = this.getCreateServerTaskId(pgId);
        if (taskId == -1L) {
            return false;
        }
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        BackTask task = taskService.readTask(taskId);
        if (null == task) {
            logger.error((Object)("add vm to " + pgId + "@" + this.instanceName + " task is null: " + taskId));
            return false;
        }
        for (times = 214748; times > 0; --times) {
            CommUtil.pauseThread((long)10000L);
            task = taskService.readTask(taskId);
            if (CommonConstant.BACKTASK_RESULT_FAIL != task.getTaskResult()) continue;
            logger.error((Object)("add vm to " + pgId + "@" + this.instanceName + " task is null: " + taskId + ",reTryTimes=" + (214748 - times)));
            OpenStackCommonUtil.throwTaskError(task);
            return false;
        }
        logger.error((Object)("add vm to " + pgId + "@" + this.instanceName + " task is timeout: " + taskId + ",reTryTimes=" + (214748 - times)));
        return false;
    }

    private long getCreateServerTaskId(String pgId) {
        try {
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            return pgService.addProtectObjects(pgId, this.addServerSet);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"add server to instance failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"delete pg error.", (Throwable)e);
            return -1L;
        }
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

