/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ServiceInstanceReplicationSyncTask {
    private static final String PROJECT_ID = "projectId";
    private static final String REGION_ID = "regionId";
    private static final String CGID = "cgid";
    private static final String TOKEN_ID = "tokenId";
    private static Log logger = LogFactory.getInstance(ServiceInstanceReplicationSyncTask.class);
    private LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();

    public boolean add(String instanceId) {
        return this.queue.add(instanceId);
    }

    public void run() {
        Iterator<String> it = this.queue.iterator();
        while (it.hasNext()) {
            String instanceId = it.next();
            HibernateTemplate hibernateTemplate = CommonDAOLocator.getMoDao().getHibernateTemplate();
            ServiceInstance serviceInstance = (ServiceInstance)hibernateTemplate.get(ServiceInstance.class, (Serializable)((Object)instanceId));
            if (serviceInstance == null) {
                logger.error((Object)"not found service instance for %s", new Object[]{instanceId});
                it.remove();
                continue;
            }
            if (!Arrays.asList("csha_csdr", "vha_csdr").contains(serviceInstance.getProtectType())) {
                logger.info((Object)("not a DRStar instance " + instanceId));
                it.remove();
                continue;
            }
            IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = groupService.getProtectGroupByID(serviceInstance.getProtectGroupId(), false);
            if (protectGroup == null || DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus() != protectGroup.getStatus()) {
                logger.error((Object)"not found protect group for %s, or protect group status is not normal.", new Object[]{instanceId});
                it.remove();
                continue;
            }
            DrExtendManager manager = new DrExtendManager();
            boolean sync = false;
            JSONObject info = new JSONObject().set((Object)"instanceId", (Object)instanceId).set((Object)"instanceName", (Object)serviceInstance.getName());
            try {
                Map.Entry<JSONObject, VolumeReplicationCgInfo> detail = this.queryVolumeReplicationCG(manager, protectGroup);
                VolumeReplicationCgInfo replicationCgInfo = detail.getValue();
                if (replicationCgInfo == null) {
                    it.remove();
                    continue;
                }
                JSONObject json = detail.getKey();
                String regionId = json.getString(REGION_ID);
                String tokenId = json.getString(TOKEN_ID);
                String projectId = json.getString(PROJECT_ID);
                String cgid = json.getString(CGID);
                info.pick(json.toMap(String.class), new String[]{REGION_ID, PROJECT_ID, CGID});
                boolean complete = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(replicationCgInfo.getReplicationStatus());
                if (complete) {
                    sync = true;
                    it.remove();
                    logger.info((Object)"Begin to sync replication. info: %s", new Object[]{info});
                    AsyncTaskResponse response = manager.syncVolumeReplicationCG(regionId, tokenId, projectId, cgid);
                    if (response.isSuccess()) {
                        logger.info((Object)"sync replication success. info: %s", new Object[]{info});
                        continue;
                    }
                    logger.error((Object)"sync replication failed. info: %s", new Object[]{info});
                    continue;
                }
                logger.info((Object)"replication status is not active. info: %s", new Object[]{info});
            }
            catch (Exception e) {
                if (sync) {
                    logger.error((Throwable)e, (Object)"sync replication failed. info: %s", new Object[]{info});
                    continue;
                }
                logger.error((Throwable)e, (Object)"check replication failed. info: %s", new Object[]{info});
            }
        }
    }

    private Map.Entry<JSONObject, VolumeReplicationCgInfo> queryVolumeReplicationCG(DrExtendManager manager, ProtectGroup protectGroup) {
        String regionId = protectGroup.getProperty(REGION_ID);
        String projectId = protectGroup.getProperty(PROJECT_ID);
        String tokenId = TokenUtil.getInstance().getTokenId(projectId);
        String cgid = protectGroup.getProperty("replicaCgUuid");
        JSONObject info = new JSONObject().set((Object)PROJECT_ID, (Object)projectId).set((Object)REGION_ID, (Object)regionId).set((Object)CGID, (Object)cgid).set((Object)TOKEN_ID, (Object)tokenId);
        VolumeReplicationCgInfo replicationCgInfo = manager.queryVolumeReplicationCG(regionId, tokenId, projectId, cgid);
        if (replicationCgInfo == null || OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicationCgInfo.getReplicationStatus())) {
            logger.error((Object)"replication may be switched. info: %s", new Object[]{new JSONObject().pick(info.toMap(String.class), new String[]{PROJECT_ID, REGION_ID, CGID})});
            return new AbstractMap.SimpleEntry<JSONObject, Object>(info, null);
        }
        return new AbstractMap.SimpleEntry<JSONObject, VolumeReplicationCgInfo>(info, replicationCgInfo);
    }
}

