/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.bugmanagement;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.drm.openstack.system.bugmanagement.task.OpenStackVersionReportTask;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackVersionReportService
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(OpenStackVersionReportService.class);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && this.available()) {
            logger.info((Object)"version report service creat a task to handle on register.");
            OpenStackVersionReportTask openStackVersionReportTask = new OpenStackVersionReportTask("ism.drm.version.report", "version.report");
            logger.info((Object)"submit a task for version report.");
            long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)openStackVersionReportTask);
            logger.info((Object)String.format("submit a task for version report success taskId is: %s", taskId));
        }
    }

    private boolean available() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.info((Object)"BugManagement server url is empty, Version Report management is not supported.");
            return false;
        }
        logger.info((Object)"BugManagement Version Report is supported.");
        return true;
    }
}

