/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.serviceimpl;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.openstack.sdk.service.IUnitePasswordService;
import com.huawei.ism.drm.openstack.system.unitepassword.task.UnitePasswordModifyPasswordBackTask;
import com.huawei.ism.drm.openstack.system.unitepassword.task.UnitePasswordResetPasswordBackTask;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.user.dao.IUserDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IUnitePasswordService", Desc="", Interface=IUnitePasswordService.class)
public class UnitePasswordServiceimpl
extends BaseService
implements IUnitePasswordService {
    private static final Log logger = LogFactory.getInstance(UnitePasswordServiceimpl.class);
    private static final String VALID = "valid";
    private IUserDao userDao;
    private NodeAgentLocalService.Iface client;

    public IUserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(IUserDao userDao) {
        this.userDao = userDao;
    }

    public NodeAgentLocalService.Iface getClient() {
        return this.client;
    }

    public void setClient(NodeAgentLocalService.Iface client) {
        this.client = client;
    }

    public void modifyPassword(Account account) {
        logger.info((Object)"create modify password task");
        BackTask modifyPasswordBacktask = BackTaskUtil.buildBackTask((String)"BCManager", (String)"ism.drm.manageone.unitepassword.modifypassword", (String)"System", null, null);
        modifyPasswordBacktask.setTaskLink(account.getTaskId());
        UnitePasswordModifyPasswordBackTask task = new UnitePasswordModifyPasswordBackTask(account, modifyPasswordBacktask, this.client);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public JSONObject queryStatus(String taskId) {
        JSONObject jsonObject = new JSONObject();
        String taskLink = taskId;
        IBackTaskService backTaskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskLink", taskLink);
        BackTask backTask = (BackTask)backTaskService.queryTasks(condition).get(0);
        if (!VerifyUtil.isEmpty((Object)backTask)) {
            int taskResult = backTask.getTaskResult();
            int data = this.transformStatus(taskResult);
            String resultCode = String.valueOf(data);
            if (data == 2) {
                String errorMsg = "Password modify failed";
                jsonObject.put((Object)"errMsg", (Object)errorMsg);
            }
            jsonObject.put((Object)"resultCode", (Object)resultCode);
            jsonObject.put((Object)"data", (Object)data);
        }
        return jsonObject;
    }

    public void resetPassword(Account account) {
        logger.info((Object)"create reset password task");
        BackTask resetPasswordBacktask = BackTaskUtil.buildBackTask((String)"BCManager", (String)"ism.drm.manageone.unitepassword.resetpassword", (String)"System", null, null);
        resetPasswordBacktask.setTaskLink(account.getTaskId());
        UnitePasswordResetPasswordBackTask task = new UnitePasswordResetPasswordBackTask(account, resetPasswordBacktask, this.client);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public String validPasswd(Account account) {
        String accountName = account.getAccountName();
        if (accountName.equals("SyncAdmin")) {
            UserInfo userInfo = this.userDao.getUserByName(accountName, false);
            String printPasswd = account.getPasswdNew();
            String realPasswd = userInfo.getUserPwd();
            String salt = userInfo.getUserPwdSalt();
            if (KmcCompatible.isDataSame((String)printPasswd, (String)salt, (String)realPasswd)) {
                return "{\"resultCode\":\"00000000\",\"errMsg\":\"SUCCESS\"}";
            }
            return "{\"resultCode\":\"11111111\",\"errMsg\":\"Password valid failed\"}";
        }
        if (accountName.equals("DRManager") || accountName.equals("root")) {
            try {
                ArrayList<Node> validNodeList = new ArrayList<Node>();
                List allNodes = this.client.getNodeList();
                for (Node node : allNodes) {
                    if (!node.addresses.contains(account.getIp())) continue;
                    validNodeList.add(node);
                    break;
                }
                ArrayList<String> params = new ArrayList<String>();
                params.add(VALID);
                params.add(account.getAccountName());
                params.add(account.getPasswdNew());
                params.add(account.getPasswdNew());
                Map responsesMap = this.client.execute(new Command("manage_passwd").setParams(params), validNodeList, null);
                if (responsesMap.values().stream().allMatch(response -> response.code == 0L)) {
                    return "{\"resultCode\":\"00000000\",\"errMsg\":\"SUCCESS\"}";
                }
                return "{\"resultCode\":\"11111111\",\"errMsg\":\"Password valid failed\"}";
            }
            catch (Exception e) {
                logger.error((Object)"UnitePassword valid %s password failed!, exception is %s", new Object[]{account.getAccountName(), e.getMessage()});
                return "{\"resultCode\":\"11111111\",\"errMsg\":\"Password valid failed\"}";
            }
        }
        return "{\"resultCode\":\"11111111\",\"errMsg\":\"The account does not support verification\"}";
    }

    private int transformStatus(int taskResult) {
        if (taskResult == 0) {
            return 1;
        }
        if (taskResult == 1) {
            return 2;
        }
        return 0;
    }
}

