/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.drm.openstack.system.unitepassword.task.UnitePasswordModifyPasswordBackTask;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnitePasswordResetPasswordBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UnitePasswordResetPasswordBackTask.class);
    private static final String RESET = "reset";
    private Account account;
    private NodeAgentLocalService.Iface client;

    public UnitePasswordResetPasswordBackTask(Account account, BackTask backTask, NodeAgentLocalService.Iface client) {
        super(account.getTaskId(), backTask, true);
        this.account = account;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        if (this.account.getAccountName().equals("DRManager") || this.account.getAccountName().equals("root")) {
            boolean isSuccessful = false;
            try {
                ArrayList<Node> resetNodeList = new ArrayList<Node>();
                List allNodes = this.client.getNodeList();
                for (Node node : allNodes) {
                    if (!node.addresses.contains(this.account.getIp())) continue;
                    resetNodeList.add(node);
                    break;
                }
                ArrayList<String> params = new ArrayList<String>();
                params.add(RESET);
                params.add(this.account.getAccountName());
                params.add(this.account.getPasswd());
                params.add(this.account.getPasswd());
                Map responsesMap = this.client.execute(new Command("manage_passwd").setParams(params), resetNodeList, null);
                isSuccessful = responsesMap.values().stream().allMatch(response -> response.code == 0L);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"UnitePassword reset %s password failed!, exception is %s", new Object[]{this.account.getAccountName(), e.getMessage()});
                    isSuccessful = false;
                }
                catch (Throwable throwable) {
                    logger.info((Object)"reset %s password result is %s", new Object[]{this.account.getAccountName(), isSuccessful});
                    UnitePasswordModifyPasswordBackTask.recordResult(this.account.getTaskId(), isSuccessful);
                    logger.info((Object)"Successful record reset %s password task result,", new Object[]{this.account.getAccountName()});
                    throw throwable;
                }
                logger.info((Object)"reset %s password result is %s", new Object[]{this.account.getAccountName(), isSuccessful});
                UnitePasswordModifyPasswordBackTask.recordResult(this.account.getTaskId(), isSuccessful);
                logger.info((Object)"Successful record reset %s password task result,", new Object[]{this.account.getAccountName()});
            }
            logger.info((Object)"reset %s password result is %s", new Object[]{this.account.getAccountName(), isSuccessful});
            UnitePasswordModifyPasswordBackTask.recordResult(this.account.getTaskId(), isSuccessful);
            logger.info((Object)"Successful record reset %s password task result,", new Object[]{this.account.getAccountName()});
        }
    }
}

