/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTaskResult;
import com.huawei.ism.drm.openstack.protection.service.DelReplicationTask;
import com.huawei.ism.drm.openstack.protection.service.TimeOutCalculator;
import com.huawei.ism.drm.openstack.resource.OpenStackVmResRollBackExecutor;
import com.huawei.ism.drm.openstack.sdk.bo.ConsistentGroupReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackProtectionService;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.model.DelTagParam;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class OpenStackCommonUtil
extends OpenStackBasicUtil {
    public static final String DR_STAR_REPLICATION_SIDE_MAPPING = "DrStarReplicationSideMapping";
    private static final String VMUUID = "61a9308f-f99e-4e32-945e-5f4a78bfa957";
    private static Log logger = LogFactory.getInstance(OpenStackCommonUtil.class);

    private OpenStackCommonUtil() {
    }

    public static OpenstackInfo getOpenstackInfo(String openstackUuid) {
        FusionSphereOpenStack open = (FusionSphereOpenStack)CommonDAOLocator.getMoDao().getMoByUuid(openstackUuid, Boolean.valueOf(true));
        if (VerifyUtil.isEmpty((Object)open)) {
            logger.error((Object)("Can not find openstack mo:openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        long moId = open.getMoId();
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extend = neMgr.findByMoId(Long.valueOf(moId));
        if (VerifyUtil.isEmpty((Object)extend)) {
            logger.error((Object)("Can not find openstack ne extend info :openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Map paramMap = extend.getExtendParams();
        String isIam = (String)paramMap.get("authType");
        OpenstackInfo openInfo = new OpenstackInfo();
        openInfo.setIp(open.getIpAddress());
        openInfo.setPort((String)paramMap.get("port"));
        openInfo.setDomainName((String)paramMap.get("domain"));
        openInfo.setUser(extend.getNetworkUserName());
        openInfo.setPasswd(extend.getNetworkPassword());
        openInfo.setUseIAM("IAM".equals(isIam));
        return openInfo;
    }

    public static FusionSphereOpenStack getOpenstack() {
        return OpenStackCommonUtil.getOpenstack(false);
    }

    public static FusionSphereOpenStack getOpenstack(boolean check) {
        List openstackList = CommonDAOLocator.getMoDao().getAllMo(FusionSphereOpenStack.class);
        if (VerifyUtil.isEmpty((Collection)openstackList) || openstackList.get(0) == null) {
            logger.error((Object)"Openstack instance is not exist.");
            if (check) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        return (FusionSphereOpenStack)CommonUtil.getFirstElement((Collection)openstackList);
    }

    public static void putOrderResult(String status, Map<String, Object> extendParam, String errorCode, String[] errorParam) {
        if (VerifyUtil.isEmpty((String)status) || !extendParam.containsKey("order_instinfo") || !extendParam.containsKey("subscription_id")) {
            logger.error((Object)("Order Result param is empty, status: " + status + " extendParam: " + extendParam));
            return;
        }
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        ArrayList<OrderInstanceInfo> instances = new ArrayList<OrderInstanceInfo>();
        OrderInstanceInfo order = (OrderInstanceInfo)extendParam.get("order_instinfo");
        logger.debug((Object)("Start report order to manageOne, ServiceInstanceID=" + order.getInstanceId() + ",serviceName=" + order.getInstanceName()));
        order.setResult(status);
        order.setErrorCode(errorCode);
        order.setParam(errorParam);
        instances.add(order);
        String quotas = null;
        if (extendParam.containsKey("order_quotas") && ServiceInstaceEnumDefine.SERVICEINSTANCE_ORDEREXECUTE_STATUS_E.SUCCESSED.getValue().equals(status)) {
            quotas = extendParam.get("order_quotas").toString();
        }
        try {
            scOperation.reportOrderResult(status, instances, quotas, extendParam.get("subscription_id").toString());
            logger.debug((Object)("End report order to manageOne, ServiceInstanceID=" + order.getInstanceId() + ",serviceName=" + order.getInstanceName()));
        }
        catch (Exception e) {
            logger.error((Object)("Report Order Result fail : " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public static String getBcmPrimaryVmUuid(PoReplicaInfo info) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(info.getRegionUuid());
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(info.getProjUuid());
        OpenStackVM vmInfo = novaMgr.getVm(info.getRegionUuid(), tokenId, info.getProjUuid(), info.getMoUuid(), new int[0]);
        if (null == vmInfo) {
            logger.error((Object)("Source vm(" + info.getMoUuid() + ") is not exist."));
            throw new LegoCheckedException(1073947394L);
        }
        if (!VerifyUtil.isEmpty((Map)vmInfo.getMetadata()) && !VerifyUtil.isEmpty((String)((String)vmInfo.getMetadata().get("_bcm_primary_vm")))) {
            return (String)vmInfo.getMetadata().get("_bcm_primary_vm");
        }
        return info.getMoUuid();
    }

    public static void throwTaskError(BackTask task) {
        if (null != task && NumberUtils.isDigits((String)task.getTaskDetail())) {
            long errorCode = Long.parseLong(task.getTaskDetail());
            if (1073947906L == errorCode) {
                errorCode = 1073948137L;
            }
            throw new LegoCheckedException(errorCode, task.getTaskDetailParas());
        }
    }

    public static void updateRecoverySetting(String planId, Set<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(protectObjects)) {
            logger.info((Object)"Input argument is illegal.");
            return;
        }
        ArrayList<RecoverySetting> settings = new ArrayList<RecoverySetting>();
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        for (ProtectObject po : protectObjects) {
            PoReplicaInfo replicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            if (null == replicaInfo) {
                logger.error((Object)("The vm has no replica info:vmName=" + po.getName()));
                continue;
            }
            PhVmInfo vmInfo = replicaInfo.getPhVmInfo();
            if (VerifyUtil.isEmpty((Object)vmInfo)) {
                logger.error((Object)("The vm has no placehold vm info:vmName=" + po.getName()));
                continue;
            }
            RecoverySetting uuidSetting = new RecoverySetting();
            uuidSetting.setPlanId(planId);
            uuidSetting.setRecoveryPlan(recoveryPlan);
            uuidSetting.setOwnerId(po.getUuid());
            uuidSetting.setName("PLACEHOLDVM");
            uuidSetting.setValue(vmInfo.getVmUuid());
            settings.add(uuidSetting);
            RecoverySetting nameSetting = new RecoverySetting();
            nameSetting.setPlanId(planId);
            nameSetting.setRecoveryPlan(recoveryPlan);
            nameSetting.setOwnerId(po.getUuid());
            nameSetting.setName("PLACEHOLDVMNAME");
            nameSetting.setValue(vmInfo.getName());
            settings.add(nameSetting);
            RecoverySetting startPriSetting = new RecoverySetting();
            startPriSetting.setPlanId(planId);
            startPriSetting.setRecoveryPlan(recoveryPlan);
            startPriSetting.setOwnerId(po.getUuid());
            startPriSetting.setName("startOrder");
            startPriSetting.setValue("1");
            settings.add(startPriSetting);
            OpenStackCommonUtil.setCshaCsdrRecoverySetting(planId, settings, recoveryPlan, po);
        }
        planService.saveOrUpdateRecoverySettings(planId, settings);
    }

    private static void setCshaCsdrRecoverySetting(String planId, List<RecoverySetting> settings, RecoveryPlan recoveryPlan, ProtectObject po) {
        if (po.getProtectGroup().getTemplate().getType() == 37) {
            PoReplicaInfo hypermetorReplicationInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
            if (null == hypermetorReplicationInfo) {
                logger.error((Object)"SetCshaCSDRPhVMInfo failed.the vm has no replica info:vmName=%s", new Object[]{po.getName()});
                return;
            }
            PhVmInfo hypermetorVmInfo = hypermetorReplicationInfo.getPhVmInfo();
            if (VerifyUtil.isEmpty((Object)hypermetorVmInfo)) {
                logger.error((Object)"SetCshaCSDRPhVMInfo failed.the vm has no placehold vm info:vmName=%s", new Object[]{po.getName()});
                return;
            }
            RecoverySetting hypermetorUuidSetting = new RecoverySetting();
            hypermetorUuidSetting.setPlanId(planId);
            hypermetorUuidSetting.setRecoveryPlan(recoveryPlan);
            hypermetorUuidSetting.setOwnerId(po.getUuid());
            hypermetorUuidSetting.setName("CSHAPLACEHOLDVM");
            hypermetorUuidSetting.setValue(hypermetorVmInfo.getVmUuid());
            settings.add(hypermetorUuidSetting);
            RecoverySetting hypermetorNameUuidSetting = new RecoverySetting();
            hypermetorNameUuidSetting.setPlanId(planId);
            hypermetorNameUuidSetting.setRecoveryPlan(recoveryPlan);
            hypermetorNameUuidSetting.setOwnerId(po.getUuid());
            hypermetorNameUuidSetting.setName("CSHAPLACEHOLDVMNAME");
            hypermetorNameUuidSetting.setValue(hypermetorVmInfo.getName());
            settings.add(hypermetorNameUuidSetting);
        }
    }

    public static OpenStackVM getServerById(String projectUuid, String regionUuid, String serverId) {
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String serverUuid = OpenStackCommonUtil.getObjectUuid(openStackUuid, serverId);
        return OpenStackCommonUtil.getServerByUuid(projectUuid, regionUuid, serverUuid);
    }

    public static OpenStackVM getServerByUuid(String projectUuid, String regionUuid, String serverUuid) {
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openStackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        return novaManager.getVm(regionUuid, tokenId, projectUuid, serverUuid, new int[0]);
    }

    public static boolean isBareMetalServer(OpenStackVM server) {
        if (null == server) {
            logger.error((Object)"Check if the server is bare metal, but server is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Set serverTags = server.getTags();
        return !VerifyUtil.isEmpty((Collection)serverTags) && serverTags.contains("__type_baremetal");
    }

    public static boolean isBareMetalServer(ProtectObject po) {
        if (null == po || null == po.getProtectGroup()) {
            logger.error((Object)"Check if the protect object is bare metal server, but po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
        String openstackUuid = openstack.getUuid();
        String projectUuid = openstackUuid + ":" + OpenStackCommonUtil.getIdFromUuid((String)po.getProtectGroup().getProps().get("projectId"));
        String regionUuid = openstackUuid + ":" + OpenStackCommonUtil.getIdFromUuid((String)po.getProtectGroup().getProps().get("regionId"));
        return OpenStackCommonUtil.isBareMetalServer(OpenStackCommonUtil.getServerByUuid(projectUuid, regionUuid, po.getMoUuid()));
    }

    public static void closeRing(IVolumeService volumeService, String projId, String regionId, String ringId, String splitFlag) {
        boolean normalClosing = false;
        try {
            volumeService.closeRing(regionId, projId, ringId, false);
        }
        catch (LegoCheckedException e) {
            normalClosing = true;
            logger.error((Object)("Normal close Ring failed.ringId=" + ringId + ", splitFlag:" + splitFlag + ";Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        if (normalClosing) {
            logger.info((Object)("Start single closeRing:ringId=" + ringId));
            volumeService.closeRing(regionId, projId, ringId, true);
        }
    }

    public static void deleteCg(IVolumeService volumeService, String projId, String regionId, String cgId, String splitFlag) {
        boolean success;
        try {
            volumeService.delReplicaCG(regionId, projId, cgId, false, false);
            success = true;
        }
        catch (LegoCheckedException e) {
            if (!Boolean.toString(true).equals(splitFlag)) {
                throw e;
            }
            success = false;
        }
        if (!success) {
            logger.info((Object)("Start single delete cg:cgId=" + cgId));
            volumeService.delReplicaCG(regionId, projId, cgId, true, true);
        }
    }

    public static Consumer<VolumeReplicationCgInfo> deleteCg(IVolumeService volumeService, String projectId, String regionId, String splitFlag) {
        return cg -> OpenStackCommonUtil.deleteCg(volumeService, projectId, regionId, cg.getId(), splitFlag);
    }

    public static List<Callable<PoReplicaPairInfo>> getTaskList(IVolumeService volumeService, Collection<ProtectObject> poList, ProtectGroup protectGroup, String replicationSide, String openrationSide, DelTagParam delTagParam) {
        return OpenStackCommonUtil.getTaskList(volumeService, poList, protectGroup, replicationSide, delTagParam, openrationSide);
    }

    public static List<Callable<PoReplicaPairInfo>> getTaskList(IVolumeService volumeService, Collection<ProtectObject> poList, ProtectGroup protectGroup, String replicationSide, DelTagParam delTagParam, String openrationSide) {
        ArrayList<Callable<PoReplicaPairInfo>> taskList = new ArrayList<Callable<PoReplicaPairInfo>>();
        HashSet<String> srcVolumeUuid = new HashSet<String>();
        for (ProtectObject po : poList) {
            String replicationInfo = "activeside".equals(replicationSide) ? (String)po.getProps().get("replicationInfo") : ("standbyside".equals(replicationSide) ? (String)po.getProps().get("remote_replicationInfo") : ("hypermetorside".equals(replicationSide) ? (String)po.getProps().get("hypermetor_replicationInfo") : (String)po.getProps().get("replicationInfo")));
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                logger.error((Object)("Json to bean error:replicaInfoStr=" + replicationInfo + ", protectGroup name=" + protectGroup.getName()));
                continue;
            }
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (srcVolumeUuid.contains(pairInfo.getVolumeUuid())) continue;
                srcVolumeUuid.add(pairInfo.getVolumeUuid());
                DelReplicationTask task = new DelReplicationTask(volumeService, pairInfo, protectGroup, openrationSide);
                task.setDelTagParam(delTagParam);
                taskList.add(task);
            }
            if ("standbyside".equals(replicationSide)) continue;
            logger.info((Object)("Delete vm tags at " + new JSONObject().set((Object)"mo", (Object)poReplicaInfo.getMoUuid()).set((Object)"side", (Object)openrationSide).toString() + ", protectGroup name=" + protectGroup.getName()));
            OpenStackCommonUtil.deleteTagFromVm(poReplicaInfo, delTagParam);
        }
        return taskList;
    }

    public static <T> void executeTask(List<Callable<T>> taskList, ExecutionService.ExecuteType executeType, boolean checkResult) {
        if (VerifyUtil.isEmpty(taskList)) {
            logger.info((Object)"Delete replication task list is empty");
            return;
        }
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        int calculateTimeOut = OpenStackCommonUtil.calculateTaskTimeOut(taskList);
        if (calculateTimeOut > timeout) {
            timeout = calculateTimeOut;
        }
        List resultList = ExecutionService.execute(taskList, (ExecutionService.ExecuteType)executeType, (int)timeout, (int)batchNum);
        logger.info((Object)("Excute tast complete:ret size=" + resultList.size() + " taskSize=" + taskList.size()));
        if (!checkResult) {
            return;
        }
        FutureResult.check((Collection)resultList);
    }

    public static <T> int calculateTaskTimeOut(List<Callable<T>> taskList) {
        if (VerifyUtil.isEmpty(taskList)) {
            logger.info((Object)"Task list is empty");
            return 0;
        }
        int maxTimeOut = 0;
        for (Callable<T> callable : taskList) {
            int callableTimeOut = 0;
            if (callable instanceof TimeOutCalculator) {
                callableTimeOut = ((TimeOutCalculator)((Object)callable)).timeOutSecond(taskList);
            }
            if (callableTimeOut <= maxTimeOut) continue;
            maxTimeOut = callableTimeOut;
        }
        logger.debug((Object)"CalculateTaskTimeOut is:%s", new Object[]{String.valueOf(maxTimeOut)});
        return maxTimeOut;
    }

    public static void deleteRing(IVolumeService volumeService, String projId, String regionId, String ringId, String splitFlag) {
        boolean singleDeleteing = false;
        try {
            volumeService.delRing(regionId, projId, ringId, false, false);
        }
        catch (LegoCheckedException e) {
            singleDeleteing = true;
            logger.error((Object)("Normal delete Ring failed.ringId=" + ringId + ";Exception:" + ExceptionUtil.getErrorMessage((Throwable)e) + ", splitFlag=" + splitFlag));
        }
        if (singleDeleteing) {
            logger.info((Object)("Start single delete Ring:ringId=" + ringId));
            volumeService.delRing(regionId, projId, ringId, true, true);
        }
    }

    public static String getReplicaIdStr(List<PoReplicaPairInfo> pairInfoList, boolean isMaster) {
        if (VerifyUtil.isEmpty(pairInfoList)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (isMaster) {
            for (PoReplicaPairInfo pairInfo : pairInfoList) {
                String replicaUuid = pairInfo.getReplicaUuid();
                if (VerifyUtil.isEmpty((String)replicaUuid)) continue;
                buffer.append(OpenStackCommonUtil.getIdFromUuid(replicaUuid));
                buffer.append(',');
            }
            return buffer.substring(0, buffer.length() - 1);
        }
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            String drReplicaUuid = pairInfo.getDrReplicaUuid();
            if (VerifyUtil.isEmpty((String)drReplicaUuid)) continue;
            buffer.append(OpenStackCommonUtil.getIdFromUuid(drReplicaUuid));
            buffer.append(',');
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public static boolean shouldCheckWhetherNotSwitch(String serviceType, String protectType) {
        List<String> notAllowSwichTypes = Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue());
        return notAllowSwichTypes.contains(serviceType) || OpenStackCommonUtil.isVhaReplication(serviceType, protectType);
    }

    private static boolean isVhaReplication(String serviceType, String protectType) {
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceType) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue().equals(protectType);
    }

    public static Map<String, String> getVolAndVolTypeMap(String regionUuid, String projectUuid) {
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List vols = volumeService.getVolumesFromOpenstack(regionUuid, projectUuid);
        HashMap<String, String> volAndVolTypeMap = new HashMap<String, String>();
        for (OpenStackVolume vol : vols) {
            volAndVolTypeMap.put(OpenStackCommonUtil.getIdFromUuid(vol.getUuid()), vol.getVolType());
        }
        return volAndVolTypeMap;
    }

    public static void updateProtectedVolType(String regionUuid, String projectUuid, Set<ProtectedVolumeInfo> addVolumes) {
        if (VerifyUtil.isEmpty(addVolumes)) {
            return;
        }
        Map<String, String> volAndVolTypeMap = OpenStackCommonUtil.getVolAndVolTypeMap(regionUuid, projectUuid);
        for (ProtectedVolumeInfo vol : addVolumes) {
            String srVolType = vol.getVolumeType();
            if (!VerifyUtil.isEmpty((String)srVolType)) continue;
            String volId = OpenStackCommonUtil.getIdFromUuid(vol.getVolumeId());
            if (!volAndVolTypeMap.containsKey(volId)) {
                logger.error((Object)("Vol(" + volId + ") is not exist and not set voltype."));
                continue;
            }
            vol.setVolumeType(volAndVolTypeMap.get(volId));
        }
    }

    public static boolean updateRecoverySetting(String key, String value, String poUuid, RecoveryPlan recoveryPlan) {
        if (!VerifyUtil.isEmpty((String)value)) {
            recoveryPlan.updatePoRecoverySetting(poUuid, key, value);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void updateBasicInfo(ServiceInstance inst) {
        Session session;
        block6: {
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                String updateInst = "UPDATE ti_serviceinstance SET NAME=:instName,DESCRIPTION=:instDes, STARTPRIORITY=:startPriority WHERE UUID=:uuid";
                NativeQuery queryInst = session.createSQLQuery(updateInst);
                queryInst.setString("instName", inst.getName());
                queryInst.setString("instDes", inst.getDescription());
                queryInst.setString("uuid", inst.getUuid());
                queryInst.setInteger("startPriority", inst.getStartPriority());
                int updateResult = queryInst.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block6;
                logger.error((Object)"Update protectGroup basic info failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)"Update protectGroup basic info failed!", e.getErrorCode());
                ExceptionUtil.rethrowException((Exception)((Object)e), (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters());
                DBOperationUtil.closeSession((Session)session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession((Session)session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Update protectGroup basic info failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }

    public static long countVolumeNumberByStatus(ProtectObject po, List<String> status) {
        String replicaStr = (String)po.getProps().get("replicationInfo");
        if (VerifyUtil.isEmpty((String)replicaStr)) {
            logger.error((Object)("Get PoReplicaInfo return null, replicaStr=" + replicaStr));
            throw new LegoCheckedException(0x300001L);
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaStr, PoReplicaInfo.class);
        if (null == replicaInfo) {
            logger.error((Object)("Convert PoReplicaInfo return null, replicaStr=" + replicaStr));
            throw new LegoCheckedException(0x300001L);
        }
        return replicaInfo.getPairInfos().stream().filter(item -> status.contains(item.getVolumeStatus())).count();
    }

    public static boolean isBmsServiceVolume(String volVmUuid, List<OpenStackVM> bmsVms) {
        boolean isBmsVolume = false;
        for (OpenStackVM vm : bmsVms) {
            if (!volVmUuid.equals(vm.getUuid())) continue;
            isBmsVolume = true;
        }
        return isBmsVolume;
    }

    public static List<OpenStackVM> getBmsVms(List<OpenStackVM> vms) {
        ArrayList<OpenStackVM> openStackBmsVMs = new ArrayList<OpenStackVM>();
        for (OpenStackVM vm : vms) {
            if (!vm.getTags().contains("__type_baremetal")) continue;
            openStackBmsVMs.add(vm);
        }
        return openStackBmsVMs;
    }

    public static String getReplicationStatusForRing(ProtectGroup pg, VolumeReplicationCgInfo createActiveCgInfo, VolumeReplicationCgInfo createStandbyCgInfo, VolumeReplicationCgInfo createHyperMetroCgInfo) {
        if (null == createActiveCgInfo || null == createStandbyCgInfo || null == createHyperMetroCgInfo) {
            logger.error((Object)"ReplicationCg is null ");
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue();
        }
        VolumeReplicationCgInfo tempActiveCG = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(createActiveCgInfo.getReplicationStatus()) ? createStandbyCgInfo : createActiveCgInfo;
        boolean tempActiveCGStatusACTIVEFlag = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(tempActiveCG.getReplicationStatus());
        boolean hyperMetroCgStatusACTIVEFlag = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(createHyperMetroCgInfo.getReplicationStatus());
        boolean tempActiveCGStatusCOPYINGFlag = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(tempActiveCG.getReplicationStatus());
        boolean hyperMetroCgStatusCOPYINGFlag = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(createHyperMetroCgInfo.getReplicationStatus());
        boolean hyperMetroCgStatusACTIVESTOPPEDFlag = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(createHyperMetroCgInfo.getReplicationStatus());
        boolean flagCopyingCopying = tempActiveCGStatusCOPYINGFlag && hyperMetroCgStatusCOPYINGFlag;
        boolean flagActiveCopying = tempActiveCGStatusACTIVEFlag && hyperMetroCgStatusCOPYINGFlag;
        boolean flagCopyingActive = tempActiveCGStatusCOPYINGFlag && hyperMetroCgStatusACTIVEFlag;
        String splitFlagStr = (String)pg.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        boolean splitFlagBoolean = Boolean.toString(true).equals(splitFlagStr);
        if (tempActiveCGStatusACTIVEFlag && hyperMetroCgStatusACTIVEFlag) {
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue();
        }
        if (flagCopyingCopying || !((String)pg.getProps().get("originalAvailableRegion")).equals(pg.getProps().get("regionId")) && hyperMetroCgStatusACTIVESTOPPEDFlag && tempActiveCGStatusCOPYINGFlag) {
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue();
        }
        if (flagActiveCopying || flagCopyingActive) {
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue();
        }
        if (tempActiveCGStatusACTIVEFlag && hyperMetroCgStatusACTIVESTOPPEDFlag && !((String)pg.getProps().get("originalAvailableRegion")).equals(pg.getProps().get("regionId"))) {
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue();
        }
        if (tempActiveCGStatusACTIVEFlag && hyperMetroCgStatusACTIVESTOPPEDFlag && splitFlagBoolean) {
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue();
        }
        if (tempActiveCGStatusACTIVEFlag || tempActiveCGStatusCOPYINGFlag) {
            return createHyperMetroCgInfo.getReplicationStatus();
        }
        return tempActiveCG.getReplicationStatus();
    }

    public static VolumeReplicationCgInfo getVolumeReplicationCgInfo(ProtectGroup pg, boolean isPrimaryStatus, int ... retryTimes) {
        String tokenId;
        String regionUuid = isPrimaryStatus ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String projUuid = isPrimaryStatus ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        String replicaCgUuid = OpenStackCommonUtil.getIdFromUuid(isPrimaryStatus ? (String)pg.getProps().get("replicaCgUuid") : (String)pg.getProps().get("drReplicaCgUuid"));
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        VolumeReplicationCgInfo cgInfo = drExtendMgr.queryVolumeReplicationCGWithCache(regionUuid, tokenId = TokenUtil.getInstance().getTokenId(projUuid), projUuid, OpenStackCommonUtil.getIdFromUuid(replicaCgUuid), retryTimes);
        if (null == cgInfo) {
            logger.error((Object)("ReplicationCg is null\uff0creplicaCgUuid id " + replicaCgUuid));
        }
        return cgInfo;
    }

    public static VolumeReplicationCgInfo getVolumeReplicaCgInfoForStandby(ProtectGroup pg, boolean isPrimaryStatus) {
        String tokenId;
        String regionUuid = isPrimaryStatus ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String projUuid = isPrimaryStatus ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        String replicaCgUuid = OpenStackCommonUtil.getIdFromUuid(isPrimaryStatus ? (String)pg.getProps().get("hyperProRemoteCgUuid") : (String)pg.getProps().get("hyperProRemotedrCgUuid"));
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        VolumeReplicationCgInfo cgInfo = drExtendMgr.queryVolumeReplicationCGWithCache(regionUuid, tokenId = TokenUtil.getInstance().getTokenId(projUuid), projUuid, OpenStackCommonUtil.getIdFromUuid(replicaCgUuid), new int[0]);
        if (null == cgInfo) {
            logger.error((Object)("Standby replicationCg is null\uff0creplicaCgUuid id " + replicaCgUuid));
        }
        return cgInfo;
    }

    public static VolumeReplicationCgInfo getVolumeReplicaCgInfoForHyperMetro(ProtectGroup pg, boolean isPrimaryStatus) {
        String tokenId;
        String regionUuid = OpenStackBasicUtil.isCsdrVhaMode(pg) ? (String)pg.getProps().get("drRegionId") : (String)pg.getProps().get("regionId");
        String projUuid = OpenStackBasicUtil.isCsdrVhaMode(pg) ? (String)pg.getProps().get("drProjectId") : (String)pg.getProps().get("projectId");
        String replicaCgUuid = OpenStackCommonUtil.getIdFromUuid(isPrimaryStatus ? (String)pg.getProps().get("hyperProCgUuid") : (String)pg.getProps().get("hyperProdrCgUuid"));
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        VolumeReplicationCgInfo cgInfo = drExtendMgr.queryVolumeReplicationCGWithCache(regionUuid, tokenId = TokenUtil.getInstance().getTokenId(projUuid), projUuid, OpenStackCommonUtil.getIdFromUuid(replicaCgUuid), new int[0]);
        if (null == cgInfo) {
            logger.error((Object)("Hypermetro replicationCg is null\uff0creplicaCgUuid id " + replicaCgUuid));
        }
        return cgInfo;
    }

    public static void switchAllRing(ProtectGroup pg, boolean isOpen) {
        OpenStackCommonUtil.switchAllRing(pg.getTemplate().getType(), pg.getProps(), isOpen);
    }

    public static void switchAllRing(int templateType, Map<String, String> pgProp, boolean isOpen) {
        if (34 == templateType || 37 == templateType) {
            logger.info((Object)("Start to switch ring, isOpen:" + isOpen));
            String standbyRingUuid = pgProp.get("standbyDRRingUuid");
            String hyperRingUuid = pgProp.get("hyperDRRingID");
            String proRingUuid = pgProp.get("prodRingID");
            String projUuid = pgProp.get("projectId");
            String drProjUuid = pgProp.get("drProjectId");
            String regionUuid = pgProp.get("regionId");
            String drRegionUuid = pgProp.get("drRegionId");
            OpenStackCommonUtil.switchRing(standbyRingUuid, isOpen, drRegionUuid, drProjUuid);
            OpenStackCommonUtil.switchRing(proRingUuid, isOpen, regionUuid, projUuid);
            OpenStackCommonUtil.switchRing(hyperRingUuid, isOpen, regionUuid, projUuid);
        }
    }

    public static void switchRing(String ringUuid, boolean open, String regionUuid, String projUuid) {
        if (VerifyUtil.isEmpty((String)ringUuid)) {
            logger.error((Object)"Switch ring fail , ringUuid is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        if (open) {
            try {
                volumeService.openRing(regionUuid, projUuid, ringUuid);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("Open ring fail, ringUUID : " + ringUuid + " ex: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw e;
            }
        }
        boolean normalClosing = false;
        try {
            volumeService.closeRing(regionUuid, projUuid, ringUuid, false);
        }
        catch (LegoCheckedException e) {
            normalClosing = true;
            logger.error((Object)("Normal close Ring failed.ringId=" + ringUuid + ";Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        if (normalClosing) {
            logger.info((Object)("Start single closeRing:ringId=" + ringUuid));
            volumeService.closeRing(regionUuid, projUuid, ringUuid, true);
        }
    }

    public static Set<String> getReplicaIdSet(List<PoReplicaPairInfo> pairInfoList, boolean isMaster) {
        HashSet<String> replicaIdSet = new HashSet<String>();
        if (isMaster) {
            for (PoReplicaPairInfo pairInfo : pairInfoList) {
                String replicaId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getReplicaUuid());
                if (VerifyUtil.isEmpty((String)replicaId) || replicaIdSet.contains(replicaId)) continue;
                replicaIdSet.add(replicaId);
            }
            return replicaIdSet;
        }
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            String replicaId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrReplicaUuid());
            if (VerifyUtil.isEmpty((String)replicaId) || replicaIdSet.contains(replicaId)) continue;
            replicaIdSet.add(replicaId);
        }
        return replicaIdSet;
    }

    public static List<Map<String, Object>> getVHACSDRMapping(String regionId, IOpenstackResourceService openstackResourceService, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        List<OpenStackAvailabilityZoneMapping> vhaMappingsList;
        List mappings = openstackResourceService.getAvailabilityZoneMappingsFromDB();
        List volTypeMappings = openstackResourceService.getVolTypeMappingsFromDB();
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        List<OpenStackAvailabilityZoneMapping> csdrMappingsList = OpenStackCommonUtil.getCsdrMappingsList(mappings, regionId);
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E vhaCshaType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA;
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION == instanceType) {
            vhaCshaType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO;
        }
        if (VerifyUtil.isEmpty(vhaMappingsList = OpenStackCommonUtil.getVhaCshaMappingsList(mappings, regionId, vhaCshaType))) {
            logger.info((Object)"Get vha+csdr or csha+csdr region and AZ mapping is null, because regionId=%s, instanceType=%s have not vha AZ mapping", new Object[]{regionId, instanceType});
            return maps;
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION == instanceType) {
            OpenStackCommonUtil.getCshaCsdrAZMaping(volTypeMappings, maps, csdrMappingsList, vhaMappingsList);
        } else {
            for (OpenStackAvailabilityZoneMapping mapping : csdrMappingsList) {
                ArrayList<OpenStackVolTypeMapping> csdrVolTypesList = new ArrayList<OpenStackVolTypeMapping>();
                ArrayList<OpenStackVolTypeMapping> vhaCshaVolTypesList = new ArrayList<OpenStackVolTypeMapping>();
                OpenStackCommonUtil.getvhaAndCsdrVolType(volTypeMappings, mapping, csdrVolTypesList, vhaCshaVolTypesList, vhaCshaType);
                for (OpenStackVolTypeMapping volTypeMapping : vhaCshaVolTypesList) {
                    OpenStackCommonUtil.getAZMapForVhaCshaCSDR(csdrVolTypesList, volTypeMapping, mapping, maps, instanceType);
                }
            }
        }
        return maps;
    }

    private static void getCshaCsdrAZMaping(List<OpenStackVolTypeMapping> volTypeMappings, List<Map<String, Object>> maps, List<OpenStackAvailabilityZoneMapping> csdrMappingsList, List<OpenStackAvailabilityZoneMapping> vhaMappingsList) {
        ArrayList<OpenStackVolTypeMapping> csdrProdVolTypesList = new ArrayList<OpenStackVolTypeMapping>();
        ArrayList<OpenStackVolTypeMapping> csdrDrVolTypesList = new ArrayList<OpenStackVolTypeMapping>();
        ArrayList<OpenStackVolTypeMapping> cshaCshaVolTypesList = new ArrayList<OpenStackVolTypeMapping>();
        for (OpenStackVolTypeMapping volTypeMapping : volTypeMappings) {
            if (volTypeMapping.getType().equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue())) {
                cshaCshaVolTypesList.add(volTypeMapping);
            }
            if (!volTypeMapping.getType().equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue())) continue;
            csdrProdVolTypesList.add(volTypeMapping);
        }
        csdrDrVolTypesList.addAll(csdrProdVolTypesList);
        for (OpenStackVolTypeMapping cshaVolType : cshaCshaVolTypesList) {
            for (OpenStackVolTypeMapping csdrProdVolType : csdrProdVolTypesList) {
                for (OpenStackVolTypeMapping csdrDrVolType : csdrDrVolTypesList) {
                    ArrayList<OpenStackVolTypeMapping> checkSamemappings = new ArrayList<OpenStackVolTypeMapping>();
                    checkSamemappings.add(csdrDrVolType);
                    checkSamemappings.add(csdrProdVolType);
                    if (OpenStackVolTypeMapping.checkVolTypeListRepeat(checkSamemappings) || !OpenStackCommonUtil.isAllSame(cshaVolType, csdrProdVolType, csdrDrVolType)) continue;
                    OpenStackCommonUtil.getCshaCsdrVolAndAZMap(maps, csdrMappingsList, vhaMappingsList, cshaVolType, csdrProdVolType);
                }
            }
        }
    }

    private static boolean isAllSame(OpenStackVolTypeMapping cshaVolType, OpenStackVolTypeMapping csdrProdVolType, OpenStackVolTypeMapping csdrDrVolType) {
        logger.debug((Object)"IsAllSame: cshaVolType:(%s,%s), csdrProdVolType(%s,%s),  csdrDrVolType(%s,%s), ", new Object[]{cshaVolType.getPrimaryVolType(), cshaVolType.getSecondVolType(), csdrProdVolType.getPrimaryVolType(), csdrProdVolType.getSecondVolType(), csdrDrVolType.getPrimaryVolType(), csdrDrVolType.getSecondVolType()});
        boolean sameProdAZ = cshaVolType.getPrimaryVolType().equalsIgnoreCase(csdrProdVolType.getPrimaryVolType()) && cshaVolType.getPrimaryAzId().equalsIgnoreCase(csdrProdVolType.getPrimaryAzId());
        boolean sameHyperDrAZ = cshaVolType.getSecondVolType().equalsIgnoreCase(csdrDrVolType.getPrimaryVolType()) && cshaVolType.getSecondAzId().equalsIgnoreCase(csdrDrVolType.getPrimaryAzId());
        boolean sameDRAZ = csdrProdVolType.getSecondVolType().equalsIgnoreCase(csdrDrVolType.getSecondVolType()) && csdrProdVolType.getSecondAzId().equalsIgnoreCase(csdrDrVolType.getSecondAzId());
        return sameProdAZ && sameHyperDrAZ && sameDRAZ;
    }

    private static void getCshaCsdrVolAndAZMap(List<Map<String, Object>> maps, List<OpenStackAvailabilityZoneMapping> csdrMappingsList, List<OpenStackAvailabilityZoneMapping> vhaMappingsList, OpenStackVolTypeMapping cshaVolType, OpenStackVolTypeMapping csdrProdVolType) {
        for (OpenStackAvailabilityZoneMapping csdrMap : csdrMappingsList) {
            boolean isReverseCsdrAZEqual;
            boolean isCsdrAZEqual = OpenStackVolTypeMapping.getMappingAzId((String)csdrMap.getPrimaryRegionId(), (String)csdrMap.getPrimaryAzId()).equals(csdrProdVolType.getPrimaryAzId()) && OpenStackVolTypeMapping.getMappingAzId((String)csdrMap.getSecondRegionId(), (String)csdrMap.getSecondAzId()).equals(csdrProdVolType.getSecondAzId());
            boolean bl = isReverseCsdrAZEqual = OpenStackVolTypeMapping.getMappingAzId((String)csdrMap.getPrimaryRegionId(), (String)csdrMap.getPrimaryAzId()).equals(csdrProdVolType.getSecondAzId()) && OpenStackVolTypeMapping.getMappingAzId((String)csdrMap.getSecondRegionId(), (String)csdrMap.getSecondAzId()).equals(csdrProdVolType.getPrimaryAzId());
            if (!isCsdrAZEqual && !isReverseCsdrAZEqual) continue;
            Map map = csdrMap.toMap();
            map.put("primary_region_name", map.get("primary_region"));
            map.put("second_region_name", map.get("second_region"));
            map.put("primary_az_name", map.get("primary_az"));
            map.put("second_az_name", map.get("second_az"));
            if (isReverseCsdrAZEqual) {
                map.put("primary_region_name", map.get("second_region"));
                map.put("second_region_name", map.get("primary_region"));
                map.put("primary_az_name", map.get("second_az"));
                map.put("second_az_name", map.get("primary_az"));
            }
            map.put("drHyperMetorType", cshaVolType.getSecondVolType());
            map.put("sourceType", csdrProdVolType.getPrimaryVolType());
            map.put("drType", csdrProdVolType.getSecondVolType());
            map.put("priority", csdrProdVolType.getPriority());
            OpenStackCommonUtil.putDrSecondInfo(cshaVolType, map);
            for (OpenStackAvailabilityZoneMapping cshrMapping : vhaMappingsList) {
                if (OpenStackVolTypeMapping.getMappingAzId((String)cshrMapping.getPrimaryRegionId(), (String)cshrMapping.getPrimaryAzId()).equals(cshaVolType.getSecondAzId())) {
                    map.put("dr_second_az_name", cshrMapping.getPrimaryAz());
                    break;
                }
                if (!OpenStackVolTypeMapping.getMappingAzId((String)cshrMapping.getSecondRegionId(), (String)cshrMapping.getSecondAzId()).equals(cshaVolType.getSecondAzId())) continue;
                map.put("dr_second_az_name", cshrMapping.getSecondAz());
                break;
            }
            map.remove("primary_region");
            map.remove("second_region");
            map.remove("primary_az");
            map.remove("second_az");
            map.remove("type");
            maps.add(map);
            break;
        }
    }

    public static void getvhaAndCsdrVolType(List<OpenStackVolTypeMapping> volTypeMappings, OpenStackAvailabilityZoneMapping mapping, List<OpenStackVolTypeMapping> csdrVolTypesList, List<OpenStackVolTypeMapping> vhaCshaVolTypesList, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        for (OpenStackVolTypeMapping volTypeMapping : volTypeMappings) {
            boolean azReverseEqualCheck;
            String primaryMappingId = OpenStackVolTypeMapping.getMappingAzId((String)mapping.getPrimaryRegionId(), (String)mapping.getPrimaryAzId());
            String secondMappingId = OpenStackVolTypeMapping.getMappingAzId((String)mapping.getSecondRegionId(), (String)mapping.getSecondAzId());
            boolean azEqualCheck = primaryMappingId.equals(volTypeMapping.getPrimaryAzId()) && secondMappingId.equals(volTypeMapping.getSecondAzId());
            boolean bl = azReverseEqualCheck = secondMappingId.equals(volTypeMapping.getPrimaryAzId()) && primaryMappingId.equals(volTypeMapping.getSecondAzId());
            if (volTypeMapping.getType().equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue()) && (azEqualCheck || azReverseEqualCheck)) {
                csdrVolTypesList.add(volTypeMapping);
            }
            if (!volTypeMapping.getType().equals(instanceType.getFrontValue())) continue;
            vhaCshaVolTypesList.add(volTypeMapping);
        }
    }

    public static List<OpenStackAvailabilityZoneMapping> getCsdrMappingsList(List<OpenStackAvailabilityZoneMapping> mappings, String regionId) {
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E csdrType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION;
        ArrayList<OpenStackAvailabilityZoneMapping> csdrMappingsList = new ArrayList<OpenStackAvailabilityZoneMapping>();
        for (OpenStackAvailabilityZoneMapping mapping : mappings) {
            if (csdrType != ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)mapping.getType()) || regionId == null || !OpenStackCommonUtil.isRelatedAZMapping(mapping, regionId)) continue;
            csdrMappingsList.add(mapping);
        }
        return csdrMappingsList;
    }

    public static void getAZMapForVhaCshaCSDR(List<OpenStackVolTypeMapping> csdrVolTypesList, OpenStackVolTypeMapping volTypeMapping, OpenStackAvailabilityZoneMapping mapping, List<Map<String, Object>> maps, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        for (OpenStackVolTypeMapping volCsdrTypeMapping : csdrVolTypesList) {
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.equals((Object)volTypeMapping.getType()) && !volCsdrTypeMapping.getPrimaryAzId().equals(volTypeMapping.getPrimaryAzId()) && !volCsdrTypeMapping.getSecondAzId().equals(volTypeMapping.getPrimaryAzId())) continue;
            if (volTypeMapping.getPrimaryVolType() != null && volTypeMapping.getPrimaryVolType().equals(volCsdrTypeMapping.getPrimaryVolType())) {
                maps.addAll(OpenStackCommonUtil.getAZMap(csdrVolTypesList, volTypeMapping, mapping, volCsdrTypeMapping, instanceType));
            }
            if (volTypeMapping.getPrimaryVolType() == null || !volTypeMapping.getPrimaryVolType().equals(volCsdrTypeMapping.getSecondVolType())) continue;
            maps.addAll(OpenStackBasicUtil.getReverseAZMap(csdrVolTypesList, volTypeMapping, mapping, volCsdrTypeMapping, instanceType));
        }
    }

    public static List<Map<String, Object>> getAZMap(List<OpenStackVolTypeMapping> csdrVolTypesList, OpenStackVolTypeMapping volTypeMapping, OpenStackAvailabilityZoneMapping mapping, OpenStackVolTypeMapping volCsdrTypeMapping, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        ArrayList<Map<String, Object>> fitRingMaps = new ArrayList<Map<String, Object>>();
        for (OpenStackVolTypeMapping volOtherCsdrTypeMapping : csdrVolTypesList) {
            if (volTypeMapping.getSecondVolType() == null || !volTypeMapping.getSecondVolType().equals(volOtherCsdrTypeMapping.getPrimaryVolType()) || volCsdrTypeMapping.getSecondVolType() == null || volOtherCsdrTypeMapping.getSecondVolType() == null || !volCsdrTypeMapping.getSecondVolType().equals(volOtherCsdrTypeMapping.getSecondVolType())) continue;
            Map map = mapping.toMap();
            map.put("primary_region_name", map.get("primary_region"));
            map.put("second_region_name", map.get("second_region"));
            map.put("primary_az_name", map.get("primary_az"));
            map.put("second_az_name", map.get("second_az"));
            map.put("drHyperMetorType", volTypeMapping.getSecondVolType());
            map.put("sourceType", volTypeMapping.getPrimaryVolType());
            map.put("drType", volCsdrTypeMapping.getSecondVolType());
            map.put("priority", volCsdrTypeMapping.getPriority());
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.equals((Object)instanceType)) {
                OpenStackCommonUtil.putDrSecondInfo(volTypeMapping, map);
            }
            map.remove("primary_region");
            map.remove("second_region");
            map.remove("primary_az");
            map.remove("second_az");
            map.remove("type");
            fitRingMaps.add(map);
        }
        return fitRingMaps;
    }

    public static boolean isRelatedAZMapping(OpenStackAvailabilityZoneMapping mapping, String regionId) {
        if (mapping == null || regionId == null) {
            return false;
        }
        if (regionId.equals(mapping.getPrimaryRegionId())) {
            return true;
        }
        return regionId.equals(mapping.getSecondRegionId());
    }

    public static void getVolTypeSet(Set<ProtectObject> poList, Set<String> srcVolTypeSet, Set<String> drVolTypeSet, Set<String> drHyperVolTypeSet) {
        for (ProtectObject po : poList) {
            String volConfigStr = (String)po.getProps().get("volumeConfig");
            JSONArray array = JSONArray.fromObject((Object)volConfigStr);
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                JSONObject json = array.getJSONObject(i);
                srcVolTypeSet.add(json.getString("volumeType"));
                drVolTypeSet.add(json.getString("drVolumeType"));
                if (!json.containsKey((Object)"drHyperVolumeType")) continue;
                drHyperVolTypeSet.add(json.getString("drHyperVolumeType"));
            }
        }
    }

    public static void getVolumeTypeForVhaCsdr(List<Map<String, Object>> maps, String azIdentity, JSONObject json, ProtectObject po, String serviceType) {
        String srVolType = json.getString("volumeType");
        boolean isFindDrVolumeTpe = false;
        ArrayList<InstanceVolTypeMapping> drVolTypeList = new ArrayList<InstanceVolTypeMapping>();
        for (Map<String, Object> item : maps) {
            InstanceVolTypeMapping matchVolumeType;
            if (item == null) {
                throw new LegoCheckedException(0x300001L);
            }
            String azMap = OpenStackCommonUtil.getAzIdentity(item, serviceType);
            if (VerifyUtil.isEmpty((String)azMap) || !azMap.equals(azIdentity)) continue;
            String sourceType = (String)item.get("sourceType");
            String drHyperMetorType = (String)item.get("drHyperMetorType");
            String drType = (String)item.get("drType");
            int priority = (Integer)item.get("priority");
            if (sourceType.equals(srVolType)) {
                isFindDrVolumeTpe = true;
                matchVolumeType = new InstanceVolTypeMapping(srVolType, drType, drHyperMetorType, priority);
                drVolTypeList.add(matchVolumeType);
                continue;
            }
            if (!drHyperMetorType.equals(srVolType)) continue;
            isFindDrVolumeTpe = true;
            matchVolumeType = new InstanceVolTypeMapping(srVolType, drType, sourceType, priority);
            drVolTypeList.add(matchVolumeType);
        }
        if (!isFindDrVolumeTpe) {
            logger.error((Object)(srVolType + " doesn't have the corresponding drVolType,volume type az map:" + maps));
            throw new LegoCheckedException(1073948122L, new String[]{srVolType});
        }
        OpenStackBasicUtil.sortVolumeTypeByPriority(drVolTypeList);
        json.put((Object)"drVolumeType", (Object)((InstanceVolTypeMapping)drVolTypeList.get(0)).getDrVolumeType());
        logger.info((Object)("VM(" + po.getMoUuid() + ") drVolType is " + ((InstanceVolTypeMapping)drVolTypeList.get(0)).getDrVolumeType()));
        json.put((Object)"drHyperVolumeType", (Object)((InstanceVolTypeMapping)drVolTypeList.get(0)).getDrHyperMetorVolumeType());
        logger.info((Object)("VM(" + po.getMoUuid() + ") drHyperVolType is " + ((InstanceVolTypeMapping)drVolTypeList.get(0)).getDrHyperMetorVolumeType()));
    }

    private static String getAzIdentity(Map<String, Object> item, String serviceType) {
        String primaryRegionId = (String)item.get("primary_region_id");
        String primaryAzId = (String)item.get("primary_az_id");
        String secondRegionId = (String)item.get("second_region_id");
        String secondAzId = (String)item.get("second_az_id");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(serviceType)) {
            String drSecondRegionId = (String)item.get("dr_second_region_id");
            String drSecondAzId = (String)item.get("dr_second_az_id");
            return OpenStackBasicUtil.getSortStr(new String[]{OpenStackVolTypeMapping.getMappingAzId((String)secondRegionId, (String)secondAzId), OpenStackVolTypeMapping.getMappingAzId((String)primaryRegionId, (String)primaryAzId), OpenStackVolTypeMapping.getMappingAzId((String)drSecondRegionId, (String)drSecondAzId)});
        }
        return OpenStackVolTypeMapping.getAzIdentity((String)primaryRegionId, (String)primaryAzId, (String)secondRegionId, (String)secondAzId);
    }

    public static PoReplicaInfo getPoReplicationInfo(Map<String, PoReplicaInfo> poReplicaInfoMap) {
        for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
            List pairInfoList = poReplicaInfo.getPairInfos();
            if (VerifyUtil.isEmpty((Collection)pairInfoList)) continue;
            return poReplicaInfo;
        }
        return null;
    }

    public static boolean checkExistPoReplication(Map<String, PoReplicaInfo> poReplicaInfoMap) {
        boolean existReplicationInfo = false;
        if (!VerifyUtil.isEmpty(poReplicaInfoMap)) {
            for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
                List pairInfoList = poReplicaInfo.getPairInfos();
                if (VerifyUtil.isEmpty((Collection)pairInfoList)) continue;
                existReplicationInfo = true;
                break;
            }
        }
        return existReplicationInfo;
    }

    public static boolean checkCreateResult(List<CreateReplicationTaskResult> createResultList, Map<String, PoReplicaPairInfo> pairInfoMap) {
        if (VerifyUtil.isEmpty(createResultList)) {
            return false;
        }
        boolean flag = true;
        for (CreateReplicationTaskResult result : createResultList) {
            pairInfoMap.put(result.getPairInfo().getVolumeUuid(), result.getPairInfo());
            if (!result.isResultFlag()) {
                logger.error((Object)("CheckCreateResult:volumeUUID check Replication failed, volumeUUID = " + result.getPairInfo().getVolumeUuid()));
                flag = false;
            }
            logger.info((Object)("CheckCreateResult:volumeUUID check Replication succeed, volumeUUID = " + result.getPairInfo().getVolumeUuid() + "pairInfo=" + result.getPairInfo().toString()));
        }
        return flag;
    }

    public static List<ConsistentGroupReplicaInfo> getReplicas(ProtectGroup protectGroup) {
        return Arrays.asList("standbyside", "hypermetorside", "activeside").stream().map(side -> OpenStackCommonUtil.getReplicaBySide(protectGroup, side)).collect(Collectors.toList());
    }

    public static ConsistentGroupReplicaInfo getReplicaBySide(ProtectGroup protectGroup, String side) {
        Map props = protectGroup.getProps();
        ConsistentGroupReplicaInfo replica = new ConsistentGroupReplicaInfo();
        replica.setSide(side);
        if ("activeside".equals(side)) {
            replica.setMaster(true);
            replica.setRingUuid((String)props.get("prodRingID"));
            replica.setDrRingUuid((String)props.get("standbyDRRingUuid"));
            replica.setProjUuid((String)props.get("projectId"));
            replica.setRegionUuid((String)props.get("regionId"));
            replica.setCgUuid((String)props.get("replicaCgUuid"));
            replica.setDrProjUuid((String)props.get("drProjectId"));
            replica.setDrRegionUuid((String)props.get("drRegionId"));
            replica.setDrCgUuid((String)props.get("drReplicaCgUuid"));
        }
        if ("standbyside".equals(side)) {
            replica.setRingUuid((String)props.get("hyperDRRingID"));
            replica.setDrRingUuid((String)props.get("standbyDRRingUuid"));
            replica.setProjUuid((String)props.get("projectId"));
            replica.setRegionUuid((String)props.get("regionId"));
            replica.setCgUuid((String)props.get("hyperProRemoteCgUuid"));
            replica.setDrProjUuid((String)props.get("drProjectId"));
            replica.setDrRegionUuid((String)props.get("drRegionId"));
            replica.setDrCgUuid((String)props.get("hyperProRemotedrCgUuid"));
        } else if ("hypermetorside".equals(side)) {
            replica.setRingUuid((String)props.get("prodRingID"));
            replica.setDrRingUuid((String)props.get("hyperDRRingID"));
            if (OpenStackCommonUtil.isCsdrVhaMode(protectGroup)) {
                replica.setProjUuid((String)props.get("drProjectId"));
                replica.setRegionUuid((String)props.get("drRegionId"));
                replica.setDrProjUuid((String)props.get("drProjectId"));
                replica.setDrRegionUuid((String)props.get("drRegionId"));
            } else {
                replica.setProjUuid((String)props.get("projectId"));
                replica.setRegionUuid((String)props.get("regionId"));
                replica.setDrProjUuid((String)props.get("projectId"));
                replica.setDrRegionUuid((String)props.get("regionId"));
            }
            replica.setCgUuid((String)props.get("hyperProCgUuid"));
            replica.setDrCgUuid((String)props.get("hyperProdrCgUuid"));
        }
        return replica;
    }

    public static void closeRing(IVolumeService volumeService, List<ConsistentGroupReplicaInfo> replicas) {
        OpenStackCommonUtil.handleRing(replicas, arguments -> OpenStackCommonUtil.closeRing(volumeService, arguments[0], arguments[1], arguments[2], Boolean.TRUE.toString()));
    }

    public static void openRing(IVolumeService volumeService, List<ConsistentGroupReplicaInfo> replicas) {
        OpenStackCommonUtil.handleRing(replicas, arguments -> volumeService.openRing(arguments[1], arguments[0], arguments[2]));
    }

    private static void handleRing(List<ConsistentGroupReplicaInfo> replicas, Consumer<String[]> handler) {
        for (ConsistentGroupReplicaInfo replica : replicas) {
            String ringId;
            String regionId;
            String projectId;
            if (replica.isMaster()) {
                projectId = replica.getProjUuid();
                regionId = replica.getRegionUuid();
                ringId = replica.getRingUuid();
            } else {
                projectId = replica.getDrProjUuid();
                regionId = replica.getDrRegionUuid();
                ringId = replica.getDrRingUuid();
            }
            handler.accept(new String[]{projectId, regionId, ringId});
        }
    }

    public static void deleteRing(IVolumeService volumeService, List<ConsistentGroupReplicaInfo> replicas) {
        for (ConsistentGroupReplicaInfo replica : replicas) {
            String ringId;
            String regionId;
            String projectId;
            if (replica.isMaster()) {
                projectId = replica.getProjUuid();
                regionId = replica.getRegionUuid();
                ringId = replica.getRingUuid();
            } else {
                projectId = replica.getDrProjUuid();
                regionId = replica.getDrRegionUuid();
                ringId = replica.getDrRingUuid();
            }
            OpenStackCommonUtil.deleteRing(volumeService, projectId, regionId, ringId, Boolean.TRUE.toString());
            logger.info((Object)("Delete ring at " + replica.getSide() + " success. prodRingID:" + ringId));
        }
    }

    public static Map<String, List<String>> getRealStatusSideMapping(ProtectGroup protectGroup) {
        return OpenStackCommonUtil.getRealStatusSideMapping(protectGroup, true);
    }

    public static Map<String, List<String>> getRealStatusSideMapping(ProtectGroup protectGroup, boolean reenterable) {
        Map.Entry<Map<String, String>, List<VolumeReplicationCgInfo>> detail = OpenStackCommonUtil.queryVolumeReplicationCG(protectGroup);
        List<VolumeReplicationCgInfo> cgs = detail.getValue();
        List<VolumeReplicationCgInfo> unkownReplicationCgs = cgs.stream().filter(cg -> OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue().equals(cg.getReplicationStatus())).collect(Collectors.toList());
        List<VolumeReplicationCgInfo> standbyReplicationCgs = cgs.stream().filter(cg -> OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(cg.getReplicationStatus())).collect(Collectors.toList());
        List<VolumeReplicationCgInfo> normalReplicationCgs = cgs.stream().filter(cg -> !unkownReplicationCgs.contains(cg)).filter(cg -> !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(cg.getReplicationStatus())).collect(Collectors.toList());
        Map<String, String> cgIdSideMapping = detail.getKey();
        ArrayList unkownSide = new ArrayList();
        unkownReplicationCgs.forEach(cg -> unkownSide.add(cgIdSideMapping.get(cg.getId())));
        ArrayList standbySide = new ArrayList();
        standbyReplicationCgs.forEach(cg -> standbySide.add(cgIdSideMapping.get(cg.getId())));
        ArrayList normalSide = new ArrayList();
        normalReplicationCgs.forEach(cg -> normalSide.add(cgIdSideMapping.get(cg.getId())));
        HashMap<String, List<String>> statusSideMapping = new HashMap<String, List<String>>();
        statusSideMapping.put(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue(), unkownSide);
        statusSideMapping.put("standbyside", standbySide);
        statusSideMapping.put("activeside", normalSide);
        Map<String, List<String>> actualStatusMapping = reenterable ? OpenStackCommonUtil.syncReplicationSideMapping(protectGroup, statusSideMapping) : statusSideMapping;
        boolean empty = actualStatusMapping.isEmpty();
        if (empty) {
            logger.error((Object)("Get down grade status mapping failed. pg: " + protectGroup.getUuid()));
            throw new LegoCheckedException(1073947393L);
        }
        boolean illegal = Collections.singleton("standbyside").containsAll(actualStatusMapping.keySet());
        if (illegal) {
            logger.error((Object)("Both pair(s) under standby status. pg: " + protectGroup.getUuid()));
            throw new LegoCheckedException(1073948145L);
        }
        return actualStatusMapping;
    }

    public static Map<String, List<String>> syncReplicationSideMapping(ProtectGroup protectGroup, Map<String, List<String>> sideMapping) {
        String data;
        Map props = protectGroup.getProps();
        String prop = (String)props.get(DR_STAR_REPLICATION_SIDE_MAPPING);
        if (prop != null) {
            JSONObject json = JSONObject.fromObject((Object)prop);
            OpenStackCommonUtil.loadReplicationSideMapping(sideMapping, json);
        }
        if (!Objects.equals(data = JSONObject.fromObject(sideMapping).toString(), prop)) {
            props.put(DR_STAR_REPLICATION_SIDE_MAPPING, data);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
        }
        return sideMapping;
    }

    protected static void loadReplicationSideMapping(Map<String, List<String>> sideMapping, JSONObject data) {
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            if (sideMapping.containsKey(key)) {
                List sides = sideMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                List<String> items = sideMapping.get(key);
                new ArrayList((Collection)entry.getValue()).stream().filter(item -> !sides.contains(item)).forEach(items::add);
                continue;
            }
            sideMapping.put(key, (List<String>)entry.getValue());
        }
    }

    public static void cleanRingProps(ProtectGroup protectGroup, String ... keys) {
        HashSet<String> ringPropKeys = new HashSet<String>(Arrays.asList("prodRingID", "standbyDRRingUuid", "remoteDRHyperMetorStorageDevSn", "hyperProCgUuid", "hyperProdrCgUuid", "hyperProRemoteCgUuid", "hyperProRemotedrCgUuid", "remote_replicationInfo", "hypermetor_replicationInfo"));
        if (null != keys) {
            for (String key : keys) {
                ringPropKeys.add(key);
            }
        }
        OpenStackCommonUtil.cleanProtectGroupProps(protectGroup, ringPropKeys.stream());
    }

    public static void cleanProtectGroupProps(ProtectGroup protectGroup, Stream<String> keyStream) {
        keyStream.filter(Objects::nonNull).forEach(protectGroup.getProps()::remove);
    }

    public static Map<String, List<ConsistentGroupReplicaInfo>> castSideMappingToReplicaMapping(ProtectGroup protectGroup, Map<String, List<String>> statusSideMapping, List<ConsistentGroupReplicaInfo> replicas) {
        HashMap<String, List<ConsistentGroupReplicaInfo>> map = new HashMap<String, List<ConsistentGroupReplicaInfo>>();
        statusSideMapping.forEach((side, realSides) -> map.put((String)side, OpenStackCommonUtil.getReplicasBySides(replicas, realSides)));
        return map;
    }

    public static List<ConsistentGroupReplicaInfo> getReplicasBySides(List<ConsistentGroupReplicaInfo> replicas, List<String> sides) {
        return replicas.stream().filter(replica -> sides.contains(replica.getSide())).collect(Collectors.toList());
    }

    public static RollBackTaskInfo getRollBackTask(PoReplicaInfo poReplicaInfo, JSONObject json) {
        RollBackTaskInfo taskInfo = new RollBackTaskInfo();
        taskInfo.setExecutor(OpenStackVmResRollBackExecutor.class.getSimpleName());
        taskInfo.setExecuteParam(json.toString());
        taskInfo.setTaskId(poReplicaInfo.getMoUuid());
        taskInfo.setAlarmId(Long.valueOf(52625448L));
        taskInfo.setSourceUuid(OpenStackCommonUtil.getOpenstackUuidFromStr(poReplicaInfo.getProjUuid()));
        taskInfo.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        taskInfo.setAlarmParam(poReplicaInfo.getVmName());
        taskInfo.setTargetName(poReplicaInfo.getVmName());
        return taskInfo;
    }

    public static String getRealTimeCGReplicaStatus(ProtectGroup pg) {
        IDrExtendManager drExtendManager;
        VolumeReplicationCgInfo cgInfo;
        String proCgUuid = (String)pg.getProps().get("replicaCgUuid");
        String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        String projUuid = (String)pg.getProps().get("projectId");
        String regionUuid = (String)pg.getProps().get("regionId");
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        if (VerifyUtil.isEmpty((String)proCgUuid)) {
            logger.error((Object)("Pg have no cgUuid: " + pg.getName()));
        }
        if (null == (cgInfo = (drExtendManager = ManagerFactory.getInstance().getDrExtendManager(pg.getPoProviderSN())).queryRealtimeVolumeReplicationCG(regionUuid, tokenId, projUuid, proCgUuid, new int[0]))) {
            logger.error((Object)("The VolumeReplicationCgInfo is null: " + proCgUuid));
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ERROR.getValue();
        }
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
            logger.error((Object)("The VolumeReplicationCgInfo status error: " + cgInfo.getId() + ", " + cgInfo.getStatus()));
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ERROR.getValue();
        }
        return OpenStackCommonUtil.queryDRReplicaStatus(cgInfo.getReplicationStatus(), drExtendManager, drCgUuid, pg);
    }

    public static VolumeCreateInfo setDrVolumeMode(OpenStackVolume srcVolume, VolumeCreateInfo volCreateInfo) {
        String scsiMess;
        if (!VerifyUtil.isEmpty((Map)srcVolume.getMetadata()) && !VerifyUtil.isEmpty((String)(scsiMess = (String)srcVolume.getMetadata().get("hw:passthrough")))) {
            JSONObject metaJson = new JSONObject();
            metaJson.put((Object)"hw:passthrough", (Object)scsiMess);
            volCreateInfo.setMetadata(metaJson);
        }
        return volCreateInfo;
    }

    private static String queryDRReplicaStatus(String primaryReplicaStatus, IDrExtendManager drExtendManager, String drCgUuid, ProtectGroup pg) {
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue().equals(primaryReplicaStatus)) {
            return primaryReplicaStatus;
        }
        if (VerifyUtil.isEmpty((String)drCgUuid)) {
            logger.error((Object)("Pg have no drCgUuid: " + pg.getName()));
        }
        String optDrRegionUuid = (String)pg.getProps().get("drRegionId");
        String optDrProjUuid = (String)pg.getProps().get("drProjectId");
        String drTokenId = TokenUtil.getInstance().getTokenId(optDrProjUuid);
        VolumeReplicationCgInfo cgInfo = drExtendManager.queryRealtimeVolumeReplicationCG(optDrRegionUuid, drTokenId, optDrProjUuid, drCgUuid, new int[0]);
        if (null == cgInfo) {
            logger.error((Object)("The VolumeReplicationCgInfo is null: " + drCgUuid));
            return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ERROR.getValue();
        }
        return cgInfo.getReplicationStatus();
    }

    public static Set<String> getVolIdsOfProtectObjects(Set<ProtectObject> protectObjectSet, boolean includeBootVol) {
        List<String> allowStatus = Arrays.asList(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.REMOVED.getStatus(), OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
        HashSet<String> volIds = new HashSet<String>();
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            logger.error((Object)"Failed to get volIds from protectObjects.the protectObjectSet is null");
            return volIds;
        }
        for (ProtectObject po : protectObjectSet) {
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            String srcBootVolumeUuid = (String)po.getProps().get("VM_BOOTABLE_VOLUME");
            if (poReplicaInfo.getPairInfos().isEmpty()) continue;
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                boolean isBoot = false;
                if (!VerifyUtil.isEmpty((String)srcBootVolumeUuid) && srcBootVolumeUuid.equals(pairInfo.getVolumeUuid())) {
                    isBoot = true;
                }
                if (isBoot && !includeBootVol || !allowStatus.contains(pairInfo.getVolumeStatus())) continue;
                String volId = OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid());
                volIds.add(volId);
            }
        }
        return volIds;
    }

    public static void reAttachVol(String vmUuid, String volumeId, ProtectGroup pg) {
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        String projUuid = pg.getProperty("projectId");
        String regionUuid = pg.getProperty("regionId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        if (volumeService.isAttachVM(regionUuid, projUuid, vmUuid, volumeId)) {
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(volumeId);
            reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(true));
            novaMgr.reattachVolume(new ReattchParam(regionUuid, projUuid, tokenId), vmUuid, reconnVolumeInfo);
        }
    }

    public static List<OpenStackVolume> findAllDrVolumes(String instanceId) {
        ArrayList<OpenStackVolume> drVolList = new ArrayList<OpenStackVolume>();
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return drVolList;
        }
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null != instance) {
            if (VerifyUtil.isEmpty((String)instance.getProtectGroupId())) {
                return drVolList;
            }
            ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(instance.getProtectGroupId(), true);
            if (null != pg) {
                if (VerifyUtil.isEmpty((Collection)pg.getPolist())) {
                    logger.warn((Object)("No po for pg:" + pg.getName()));
                    return drVolList;
                }
                for (ProtectObject po : pg.getPolist()) {
                    Map props = po.getProps();
                    if (null == props) continue;
                    OpenStackCommonUtil.findDrVolume(drVolList, (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class));
                    OpenStackCommonUtil.findDrVolume(drVolList, (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class));
                }
                HashSet<String> dupSet = new HashSet<String>();
                Iterator iterator = drVolList.iterator();
                while (iterator.hasNext()) {
                    OpenStackVolume volume = (OpenStackVolume)iterator.next();
                    String dupKey = OpenStackCommonUtil.getVolumeDupKey(volume);
                    if (dupSet.contains(dupKey)) {
                        iterator.remove();
                        continue;
                    }
                    dupSet.add(dupKey);
                }
            }
        }
        return drVolList;
    }

    private static void findDrVolume(List<OpenStackVolume> drVolumeList, PoReplicaInfo poReplicaInfo) {
        if (null == poReplicaInfo) {
            return;
        }
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            if (VerifyUtil.isEmpty((String)drVolumeUuid)) {
                logger.info((Object)("The drVolumeUuid is empty: volumeUuid=" + pairInfo.getVolumeUuid()));
                continue;
            }
            OpenStackVolume drVolume = new OpenStackVolume();
            drVolume.setRegionUuid(poReplicaInfo.getDrRegionUuid());
            drVolume.setProjUuid(poReplicaInfo.getDrProjUuid());
            drVolume.setUuid(drVolumeUuid);
            String volumeName = pairInfo.getVolumeName();
            String drVolumeName = OpenStackCommonUtil.getNameBySuff(volumeName, "-DR");
            drVolume.setName(drVolumeName);
            drVolumeList.add(drVolume);
        }
    }

    public static String getVolumeDupKey(OpenStackVolume volume) {
        if (null == volume) {
            return null;
        }
        String dupKey = OpenStackCommonUtil.getIdFromUuid(volume.getRegionUuid()) + OpenStackCommonUtil.getIdFromUuid(volume.getProjUuid()) + OpenStackCommonUtil.getIdFromUuid(volume.getUuid());
        return dupKey;
    }

    public static void closeAndDeleteRing(ProtectGroup protectGroup, IVolumeService volumeService) {
        List<ConsistentGroupReplicaInfo> replicas = OpenStackCommonUtil.getReplicas(protectGroup);
        OpenStackCommonUtil.closeRing(volumeService, replicas);
        OpenStackCommonUtil.deleteRing(volumeService, replicas);
    }

    public static boolean checkDrNovaStatus(ProtectGroup protectGroup) {
        String drRegionUuid = (String)protectGroup.getProps().get("drRegionId");
        String drProjectUuid = (String)protectGroup.getProps().get("drProjectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drRegionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjectUuid);
        try {
            if (novaMgr == null) {
                novaMgr = new NovaManager();
            }
            novaMgr.getVm(drRegionUuid, drTokenId, drProjectUuid, VMUUID, 1);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                logger.error((Object)("CheckDrNovaStatus failed ( " + drRegionUuid + " ," + drProjectUuid + " ," + VMUUID + " ) failed."), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("CheckDrNovaStatus success ( " + drRegionUuid + " ," + drProjectUuid + " ," + VMUUID + " ) other exception."));
        }
        return true;
    }

    public static void checkPgVolumeCounts(ProtectGroup pg, int addVolumeSize) {
        OpenStackCommonUtil.checkPgVoumes(pg, addVolumeSize);
    }

    public static void checkPgVmCounts(ProtectGroup pg, int addVmSize) {
        OpenStackCommonUtil.checkPgVms(pg, addVmSize);
    }

    public static void checkPgVolumeCounts(String pgId, int addVolumeSize) {
        ProtectGroup pg = ((IOpenStackProtectionService)ServiceLocator.getInstance().getService(IOpenStackProtectionService.class)).getProtectGroupBasicInfo(pgId, true);
        OpenStackCommonUtil.checkPgVoumes(pg, addVolumeSize);
    }

    public static void checkPgVmCounts(String pgId, int addVmSize) {
        ProtectGroup pg = ((IOpenStackProtectionService)ServiceLocator.getInstance().getService(IOpenStackProtectionService.class)).getProtectGroupBasicInfo(pgId, true);
        OpenStackCommonUtil.checkPgVms(pg, addVmSize);
    }

    private static void checkPgVoumes(ProtectGroup pg, int addVolumeSize) {
        long limitNum = LegoConfig.getInstance().getNumber("protectgroup.volume.quantity.config", 512L);
        int volumeSize = pg.getPolist().stream().mapToInt(a -> JSONArray.fromObject(a.getProps().get("volumeConfig")).size()).sum();
        if ((long)(volumeSize += addVolumeSize) > limitNum) {
            logger.error((Object)"protectGroup volume is more than [%s]", new Object[]{String.valueOf(limitNum)});
            throw new SpecCheckedException("protectGroup_volume_quantity", limitNum, (long)volumeSize);
        }
    }

    private static void checkPgVms(ProtectGroup pg, int addVmSize) {
        long limitNum = LegoConfig.getInstance().getNumber("protectgroup.vm.quantity.config", 256L);
        int vmSize = pg.getPoCount() + addVmSize;
        if ((long)vmSize > limitNum) {
            logger.error((Object)"protectGroup vms is more than [%s]", new Object[]{String.valueOf(limitNum)});
            throw new SpecCheckedException("protectGroup_vms_quantity", limitNum, (long)vmSize);
        }
    }
}

