import threading
import abc


class CBSInstaller(object):
    def __init__(self):
        pass

    @abc.abstractmethod
    def install(self):
        return True

    @abc.abstractmethod
    def check(self):
        return True

    @abc.abstractmethod
    def rollback(self):
        return True


class CBSThreads(CBSInstaller):
    def __init__(self, karbor_nodes):
        super(CBSThreads, self).__init__()
        self.karbor_node_list = karbor_nodes
        self.install_result = dict()
        self.check_result = dict()
        self.rollback_result = dict()

    @abc.abstractmethod
    def install_thread(self, karbor_node):
        pass

    @abc.abstractmethod
    def check_thread(self, karbor_node):
        pass

    @abc.abstractmethod
    def rollback_thread(self, karbor_node):
        pass

    def exec_thread(self, target_exec):
        karbor_threads = []
        for karbor_node in self.karbor_node_list:
            karbor_t = threading.Thread(target=target_exec,
                                        args=(karbor_node,))
            karbor_threads.append(karbor_t)
        for t in karbor_threads:
            t.start()
        for t in karbor_threads:
            t.join()
        return True

    def install(self, do_rollback=False):
        if do_rollback:
            self.rollback()
        self.exec_thread(self.install_thread)
        for karbor_node in self.karbor_node_list:
            if not self.install_result.get(karbor_node.ip, False):
                return False
        return True

    def check(self):
        self.exec_thread(self.check_thread)
        for karbor_node in self.karbor_node_list:
            if not self.check_result.get(karbor_node.ip, False):
                return False
        return True

    def rollback(self):
        self.exec_thread(self.rollback_thread)
        for karbor_node in self.karbor_node_list:
            if not self.rollback_result.get(karbor_node.ip, False):
                return False
        return True
