from plugins.CSBS_VBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common import log as logger
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class CreateDmkAccount(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(CreateDmkAccount, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

          Perform installation & configuration.
        """
        try:
            self.dmk_client.create_cbs_account_for_upgrade()
        except Exception as e:
            logger.error("Failed to create DMK Account, "
                         "reason:{}.".format(str(e)))
            return Message(500, FCUException(645027))

        return Message(200)
