import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.message import Message

from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from plugins.CSBS_VBS.job.upgrade.tools.os_patch import InstallerOSPatch

logger.init("CSBS-VBS")


class InstallOSPatch(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(InstallOSPatch, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.os_patch = InstallerOSPatch(self.params_store.get_karbor_nodes())

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start to upgrade os patch on karbor nodes.")
        try:
            if not self.os_patch.install():
                raise Exception("Failed to upgrade os patch on karbor nodes.")
        except Exception as e:
            logger.error(f"Failed to upgrade os patch on "
                         f"karbor nodes, err_msg:{e}.")
            return Message(500, FCUException(645031))
        logger.info("Succeed to upgrade os patch on karbor nodes.")
        return Message(200)

    def rollback(self, engine_id, pod_id, regionid_list=None):
        logger.info("Start to rollback os patch on karbor nodes.")
        try:
            if not self.os_patch.rollback():
                raise Exception("Failed to rollback os patch on karbor nodes.")
        except Exception as e:
            logger.error(f"Failed to rollback os patch on "
                         f"karbor nodes, err_msg:{e}.")
            return Message(500, FCUException(645032))
        logger.info("Succeed to rollback os patch on karbor nodes.")
        return Message(200)
