import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class PreCheckKarbor(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """check karobor before upgrade

        """
        check_results = []

        try:
            check_config_dic = \
                self.params_store.get_check_config("PreCheckKarbor")
            check_results = \
                self.karbor_operation.check_services(
                    check_results, check_config_dic["KarborService"])

            check_results = \
                self.karbor_operation.check_connection_status(
                    check_results, check_config_dic["KarborConnection"])

            check_results = \
                self.karbor_operation.check_nodes_sys_status(
                    check_results, check_config_dic["KarborNodesSys"])

            check_results = \
                self.karbor_operation.check_node_certs_status(
                    check_results, check_config_dic["KarborCerts"])
        except Exception as e:
            logger.error("Check Karbor failed, reason: {}.".format(str(e)))
            return Message(500, FCUException(645016))

        return Message(200, check_results=check_results)
