# -*- coding:utf-8 -*-
import os

import yaml

import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.business.apig_util import APIGOperateApi
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


def get_config_content(file_path):
    file_object = open(file_path, encoding='utf-8')
    content = ""
    try:
        for line in file_object:
            content = "{0}{1}".format(content, line)
    except Exception as e:
        logger.error("Get file {} content failed, "
                     "err_msg:{}.".format(file_path, e))
    finally:
        file_object.close()
    return content


class RegisterApiGW(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RegisterApiGW, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.dmk_client = DMKClient(self.params_store)
        self.api_gw = APIGOperateApi()

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            # Get DMK public config
            logger.info("Start to login dmk, and get dmk public config.")
            self.dmk_client.login_dmk_by_admin_account()
            public_config = self.dmk_client.get_dmk_public_config()
            if not public_config:
                raise Exception("Get dmk public config failed.")
            logger.info("Login dmk success, get public "
                        "config: {}.".format(public_config))

            public_var = yaml.safe_load(public_config)
            api_gateway_domain_name = \
                public_var['g_current_region']['vbs']['api_gateway']
            service_domain_name = \
                public_var['g_current_region']['vbs']['service']

            as_api_config = \
                get_config_content("{}/{}".format(
                    os.path.dirname(os.path.realpath(__file__)),
                    "../../config/api_config.yaml"))
            if not as_api_config:
                raise Exception("Get api config failed.")
            as_api_config = as_api_config % (api_gateway_domain_name,
                                             service_domain_name)

            # Before registration, delete the information to ensure
            # that the old API is cleared.
            try:
                logger.info("Start to delete old api info.")
                self.api_gw.delete_apigateway(self.pod_id, as_api_config,
                                              self.region_id)
            except Exception as e:
                # No exception is thrown when a removal error occurs.
                logger.error("Remove api failed, err_msg={}.".format(str(e)))

            logger.info("Start to register api info.")
            self.api_gw.register_apigateway(self.pod_id, as_api_config,
                                            self.region_id)

            return Message(200)

        except Exception as e:
            logger.error(str(e))
            return Message(500, FCUException(645001))
