import time

import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")
CHECK_TIMES_LIMIT = 20
SLEEP_TIME = 60


class StatusCheck(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(StatusCheck, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Check karbor service status after upgrade.

        """
        try:
            self.karbor_operation.change_operation_service(tar_status="start")

            logger.info("Login dmk and call DMK to check Karbor.")
            check_times = 1
            while True:
                try:
                    action = "[Check] CSBS-VBS Karbor"
                    result = self.dmk_client.dmk_deploy_karbor(
                        action, self.upgrade_path.karbor_pkg_version)
                    if result:
                        logger.info("Check Karbor service successfully.")
                        break
                except Exception as e:
                    logger.warn("Failed to check the karbor service "
                                "using DMK, err_msg:{}.".format(e))

                if check_times >= CHECK_TIMES_LIMIT:
                    logger.error("Karbor service status is abnormal, "
                                 "check {} times.".format(check_times))
                    return Message(500, FCUException(645023))
                logger.info("Sleep {} seconds and retry to check "
                            "karbor service, retry times:{}.".
                            format(SLEEP_TIME, check_times))
                time.sleep(SLEEP_TIME)
                check_times += 1

            # reset max sync time interval for gaussdb to be 10 minutes
            self.karbor_operation.set_max_sync_time_interval_allowed(10)
            # execute fix_architecture command on the first node
            self.karbor_operation.fix_cpu_vendor_architecture()
            return Message(200)
        except Exception as e:
            logger.error("Failed to upgrade Karbor, reason:{}.".format(str(e)))
            return Message(500, FCUException(645023))
