from plugins.CSBS_VBS.common.ssh_client import SshClient
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.check_result import CheckResult

import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class TurnOffAutoBak(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(TurnOffAutoBak, self).__init__(project_id, pod_id, regionid_list)
        self.ssh_client = SshClient()
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """turn off karbor auto backup

        """
        logger.info("Start to turn off Karbor Automatic Backup.")
        item_dict = self.params_store.get_check_config("TurnOffAutoBak")
        check_results = []
        try:
            self.delete_icagent_file(self.karbor_operation.karbor_node_list)

            ret = self.karbor_operation.change_operation_service(
                tar_status="stop")

            if not ret:
                logger.info("Failed to turn off auto backup function.")
                result = CheckResult(
                    itemname_ch=item_dict['itemname_ch'],
                    itemname_en=item_dict['itemname_en'],
                    status=item_dict['failure_status'],
                    error_msg_cn=item_dict["error_msg_cn"],
                    error_msg_en=item_dict["error_msg_en"],
                    suggestion_cn=item_dict["suggestion_cn"],
                    suggestion_en=item_dict["suggestion_en"]
                )
            else:
                logger.info("Turn off automatic backup function success.")
                result = CheckResult(itemname_ch=item_dict["itemname_ch"],
                                     itemname_en=item_dict["itemname_en"],
                                     status=item_dict["succeed_status"])

            check_results.append(result)
            return Message(200, check_results=check_results)

        except Exception as e:
            logger.error("Failed to turn off Karbor automatic backup, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645025))

    def delete_icagent_file(self, node_list):
        logger.info("Begin to delete icagent file on Karbor node.")
        agent_path = "/home/moicagent/tools/pyscript/plugins/extenal"
        for node in node_list:
            ssh_client = self.ssh_client.get_ssh_client(node)
            backup_cmd = "/usr/bin/cp -rf {}/CBS/check_service_status.sh " \
                         "/home/djmanager/check_service_" \
                         "status.sh_bak".format(agent_path)
            delete_cmd = "rm -f {}/CBS/check_service_" \
                         "status.sh".format(agent_path)
            delete_cmd1 = "rm -f {}/6.5.0/CBS/check_service_" \
                          "status.sh".format(agent_path)
            delete_cmd2 = "rm -f {}/6.3/CBS/check_service_" \
                          "status.sh".format(agent_path)

            cmds = [backup_cmd, delete_cmd, delete_cmd1, delete_cmd2]
            for cmd in cmds:
                self.ssh_client.ssh_exec_command_return(ssh_client, cmd)
            logger.info("Delete icagent file on karbor node:{} "
                        "success.".format(node.ip))

            delete_pyc = "find /usr/lib/python2.7/ -name *.pyc | xargs rm -f"
            self.ssh_client.ssh_exec_command_return(ssh_client, delete_pyc)
            logger.info("Delete pyc files on karbor node:{} "
                        "success.".format(node.ip))

            self.ssh_client.ssh_close(ssh_client)
