import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UpgradeKarbor(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UpgradeKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            logger.info("Login dmk and call DMK to upgrade Karbor.")
            action = "[Upgrade] CSBS-VBS Karbor"
            result = self.dmk_client.dmk_deploy_karbor(
                action, self.upgrade_path.karbor_pkg_version)
            if result:
                logger.info("Upgrade Karbor successfully.")
            else:
                logger.error("Failed to upgrade Karbor.")
                return Message(500, FCUException(645011))

            # stop karbor operation service
            self.karbor_operation.change_operation_service(tar_status="stop")

            self.karbor_operation.set_max_sync_time_interval_allowed(60)
        except Exception as e:
            logger.error("Failed to upgrade Karbor, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645011))
        return Message(200)
