# -*- coding:utf-8 -*-
import time

import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.message import Message

from plugins.CSBS_VBS.common.upgrade.params import ParamsTools
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from plugins.CSBS_VBS.job.upgrade.tools.upload_os_patch_pkg import UploadPkg

logger.init("CSBS-VBS")


class UploadOSPatchPkg(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadOSPatchPkg, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.param_tool = ParamsTools(self.project_id)
        self.max_retry = 5

    def execute(self, project_id, pod_id, regionid_list=None):
        pkg_path, pkg_name = self.param_tool.get_pkg_path_and_pkg_name(
            pkg_suffix="_Patch_aarch64.tar.gz")
        logger.info(f"Start to upload os patch package to karbor nodes, "
                    f"pkg path:{pkg_path}, pkg name:{pkg_name}.")
        retry_count = 0
        while retry_count < self.max_retry:
            try:
                upload_pkg = UploadPkg(self.params_store.get_karbor_nodes(),
                                       pkg_path, pkg_name)
                if not upload_pkg.install():
                    raise Exception('Failed to upload os patch package '
                                    'to karbor node.')
                break
            except Exception as e:
                retry_count += 1
                logger.error(f"Err_msg:{e}, sleep 60sec to retry, "
                             f"retry times:{retry_count}.")
                time.sleep(60)
        else:
            logger.error("Failed to upload os patch package to karbor node.")
            return Message(500, FCUException(645030))
        logger.info("Succeed to upload os patch package to karbor nodes.")
        return Message(200)
