# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.CSBS_VBS.common import karbor_threads
from plugins.CSBS_VBS.common.ssh_client import SshClient


class ClearOSPatch(karbor_threads.CBSThreads):
    def __init__(self, karbor_nodes):
        super(ClearOSPatch, self).__init__(karbor_nodes)
        self.ssh_client = SshClient()
        self.patch_path = "/home/djmanager/os_patch"

    def _clear_os_patch(self, karbor_node):
        karbor_client = self.ssh_client.get_ssh_client(karbor_node)
        cmds = [
            f"rm -rf {self.patch_path}"
        ]
        for cmd in cmds:
            result = self.ssh_client.ssh_exec_command_return(karbor_client,
                                                             cmd)
            logger.info(result)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                self.ssh_client.ssh_close(karbor_client)
                raise Exception(f"Failed to execute the cmd: {cmd}, "
                                "please check.")
        self.ssh_client.ssh_close(karbor_client)

    def install_thread(self, karbor_node):
        flag = True
        try:
            self._clear_os_patch(karbor_node)
        except Exception as e:
            flag = False
            logger.error(str(e))
        self.install_result[karbor_node.ip] = flag

    def check_thread(self, karbor_node):
        self.check_result[karbor_node.ip] = True

    def rollback_thread(self, karbor_node):
        self.rollback_result[karbor_node.ip] = True
