# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSBS_VBS.cipher_change.scripts.base import BaseSubJob
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.common.upgrade.params import ParamsTools
from utils.common.check_result import CheckResult
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class PreCheckCipherType(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckCipherType, self).__init__(project_id, pod_id,
                                                 regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.param_tool = ParamsTools(project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        try:
            cipher_type = self.param_tool.get_cipher_type()

            karbor_cipher_type = self.karbor_operation.get_cipher_type()
            if karbor_cipher_type != cipher_type.cur_cipher_type:
                return Message(500, FCUException(645038, karbor_cipher_type,
                                                 cipher_type.cur_cipher_type))
        except Exception as e:
            logger.error(f"Execute error:{e}.")
            return Message(500, FCUException(645039, str(e)))

        logger.info("Checking the cipher type succeed..")
        return Message(200, check_results=[CheckResult(status="success")])
