# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSBS_VBS.cipher_change.scripts.base import BaseSubJob
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.common.upgrade.params import ParamsTools
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class SwitchCipherType(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(SwitchCipherType, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.param_tool = ParamsTools(project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        try:
            cipher_type = self.param_tool.get_cipher_type()
            # Switch OS cipher type
            self.karbor_operation.switch_os_cipher(cipher_type.tar_cipher_type)

            result = self.karbor_operation.change_cipher_type(cipher_type.tar_cipher_type)
            if not result:
                return Message(500, FCUException(645040, cipher_type.tar_cipher_type))

            karbor_cipher_type = self.karbor_operation.get_cipher_type()
            if karbor_cipher_type != cipher_type.tar_cipher_type:
                raise Exception(f"The cipher type of the CSBS-VBS karbor node "
                                f"is different from that of the target cipher "
                                f"type, karbor cipher type "
                                f"is: {karbor_cipher_type}, target cipher "
                                f"type is: {cipher_type.tar_cipher_type}.")
        except Exception as e:
            logger.error(f"Execute error:{e}.")
            return Message(500, FCUException(645041, str(e)))

        logger.info("The cipher type has been switched successfully.")
        return Message(200)
