# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("CSBS-VBS")


class BaseSubJob(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        if not (regionid_list and isinstance(regionid_list, (list, tuple))):
            raise Exception("The parameter of regionid_list cannot be empty "
                            "and parameter type must be list or tuple."
                            "regionid_list is {}, type is {}".
                            format(str(regionid_list), type(regionid_list)))
        self.regionid_list = regionid_list
        super(BaseSubJob, self).__init__(project_id, pod_id, regionid_list)
        self.region_id = self.regionid_list[0]

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform resource pre-check before installation,
        this interface is called by the execute interface,
        The tool framework does not directly call this interface.
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform job job failed rollback.
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform job failed retry.
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Check before task execution.
        """
        return Message(200)
