CSBS_PROVIDER_ID = 'fc4d5750-22e7-4798-8a46-f48f62c4c1da'
VBS_PROVIDER_ID = '1dc03359-1301-467b-9972-1a7599ae791d'
KARBOR_USER = 'djmanager'
VM_NAME = 'csbs_vm01'
VPC_NAME = 'csbs_vpc'
SUBNET_NAME = 'csbs_subnet'
KEYPAIR_NAME = 'csbs_keypair'
ECS_PRODUCT_TYPE = 'ecs'
EVS_PRODUCT_TYPE = 'evs'
EVS_NAME = 'vbs_disk'
EVS_SIZE = 1
VPC_PRODUCT_TYPE = 'vpc'
OPT_TYPE_ON = "start"
OPT_TYPE_OFF = "stop"

CSBS_POLICY_NAME_PRE = "csbs_autoplan"
VBS_POLICY_NAME_PRE = "vbs_autoplan"
POLICY_EXPIRED_TIME = 5

MINIMUM_QUOTA = 102400

BACKUP_SERVICE_NAME = "CSBS-VBS"

PKG_SUFFIX_X86 = '_CBS_Karbor_X86.zip'
PKG_SUFFIX_ARM = '_CBS_Karbor_ARM.zip'

VMS_NAME = {
    "KARBOR1": 'Service-CSBS',
    "KARBOR2": 'Service-CSBS2',
    "KARBOR3": 'Service-CSBS3',
    "KARBOR_HA1": 'Service-CSBS',
    "KARBOR_HA2": 'Service-CSBSdr'
}


class RegisterSDRData(object):
    def __init__(self, region_id, ext_float_ip):
        self.__csbs_id = "csbs"
        self.__vbs_id = "vbs"
        self.__region_id = region_id
        self.__ext_float_ip = ext_float_ip
        self.__sdr_data()

    def __sdr_data(self):
        self.csbs_data = {
            "meterId": self.__csbs_id,
            "resourceType": self.__csbs_id,
            "service": "csbs",
            "csbiName": "CSBS",
            "enable": True,
            "regionId": self.__region_id,
            "dataSource":
                f"https://{self.__ext_float_ip}:8799/v1/meters?"
                f"service_type={self.__csbs_id}&resource_type={self.__csbs_id}"
                f"&limit={{0}}&index={{1}}&start={{2}}&end={{3}}",
            "activeDataSource": "",
            "folder": "csbs",
            "className": "CommonPluginImpl",
            "version": "v2",
            "cycleTime": 3600000,
            "generationDelayTime": 900000,
            "statistics": False,
            "limit": 1000,
            "collectThreadNum": 5
        }
        self.vbs_data = {
            "meterId": self.__vbs_id,
            "resourceType": self.__vbs_id,
            "service": "vbs",
            "csbiName": "VBS",
            "enable": True,
            "regionId": self.__region_id,
            "dataSource":
                f"https://{self.__ext_float_ip}:8799/v1/meters?"
                f"service_type={self.__vbs_id}&resource_type={self.__vbs_id}"
                f"&limit={{0}}&index={{1}}&start={{2}}&end={{3}}",
            "activeDataSource": "",
            "folder": "vbs",
            "className": "CommonPluginImpl",
            "version": "v2",
            "cycleTime": 3600000,
            "generationDelayTime": 900000,
            "statistics": False,
            "limit": 1000,
            "collectThreadNum": 5
        }


class RegisterToMOInfo(object):
    def __init__(self, region_id):
        self.__csbs_id = "csbs"
        self.__vbs_id = "vbs"
        self.__byte_to_gb = 1073741824
        self.__region_id = region_id
        self.__product_action()
        self.__metrics_info()

    def __product_action(self):
        self.csbs_vbs_action_list = [
            {
                "service_type": self.__csbs_id,
                "action": "apply"
            },
            {
                "service_type": self.__csbs_id,
                "action": "modify"
            },
            {
                "service_type": self.__csbs_id,
                "action": "delete"
            },
            {
                "service_type": self.__vbs_id,
                "action": "apply"
            },
            {
                "service_type": self.__vbs_id,
                "action": "modify"
            },
            {
                "service_type": self.__vbs_id,
                "action": "delete"
            }
        ]

    def __metrics_info(self):
        self.csbs_and_vbs_metric_info = {
            "metrics": [
                {"service_id": self.__csbs_id,
                 "name": "csbs.csbs",
                 "display_name": "{\"zh_CN\":\"云服务器备份\","
                                 "\"en_US\":\"CSBS\"}",
                 "unit": "{\"zh_CN\":\"GB-小时\",\"en_US\":\"GB-Hour\"}",
                 "region_id": self.__region_id,
                 "type": "flavor",
                 "cdr_parse_rule":
                     f"parseFloat(Math.round((data.split(\"|\")[13].trim()"
                     f"/{self.__byte_to_gb}) * Math.pow(10, 6)) / "
                     f"Math.pow(10, 6).toFixed(6))",
                 "rate_parse_rule": "data.split(\"|\")[7].trim()",
                 "cloud_service_type_code": "hws.service.type.csbs",
                 "cloud_service_type_name":
                     "{\"zh_CN\":\"云服务器备份\","
                     "\"en_US\":\"CSBS\"}",
                 "resource_type_code": "hws.resource.type.csbs",
                 "resource_type_name":
                     "{\"zh_CN\":\"云服务器备份\","
                     "\"en_US\":\"CSBS\"}",
                 "cdr_folder_name": "csbs",
                 "request_url":
                     "/rest/metering/mometeringservice/v1/healthcheck",
                 "request_template":
                     "{\"X-Auth-Token\":\"${token}\","
                     "\"Content-Type\":\"application/json\"}| ",
                 "response_template":
                     "{\"retCode\":\"00000000\","
                     "\"flavors\":["
                     "{\"resourceType\":\"${resourceType}\","
                     "\"regionId\":\"${regionId}\","
                     "\"specType\":\"flavor\","
                     "\"meterId\":\"${flavorMeterId}\","
                     "\"specName\":\"server_backup\","
                     "\"specDetail\":"
                     "\"{\\\"zh_CN\\\":\\\"备份容量\\\","
                     "\\\"en_US\\\":\\\"Backup Capacity\\\"}\"},"
                     "{\"resourceType\":\"${resourceType}\","
                     "\"regionId\":\"${regionId}\","
                     "\"specType\":\"flavor\","
                     "\"meterId\":\"${flavorMeterId}\","
                     "\"specName\":\"server_backup_copy\","
                     "\"specDetail\":"
                     "\"{\\\"zh_CN\\\":\\\"复制容量\\\","
                     "\\\"en_US\\\":\\\"Duplication Capacity\\\"}\"}]}"
                 },
                {"service_id": self.__vbs_id,
                 "name": "vbs.vbs",
                 "display_name": "{\"zh_CN\":\"云硬盘备份\","
                                 "\"en_US\":\"VBS\"}",
                 "unit": "{\"zh_CN\":\"GB-小时\",\"en_US\":\"GB-Hour\"}",
                 "region_id": self.__region_id,
                 "type": "flavor",
                 "cdr_parse_rule":
                     f"parseFloat(Math.round((data.split(\"|\")[13].trim()"
                     f"/{self.__byte_to_gb}) * Math.pow(10, 6)) / "
                     f"Math.pow(10, 6).toFixed(6))",
                 "rate_parse_rule": "data.split(\"|\")[7].trim()",
                 "cloud_service_type_code": "hws.service.type.vbs",
                 "cloud_service_type_name":
                     "{\"zh_CN\":\"云硬盘备份\","
                     "\"en_US\":\"VBS\"}",
                 "resource_type_code": "hws.resource.type.vbs",
                 "resource_type_name":
                     "{\"zh_CN\":\"云硬盘备份\","
                     "\"en_US\":\"VBS\"}",
                 "cdr_folder_name": "vbs",
                 "request_url":
                     "/rest/metering/mometeringservice/v1/healthcheck",
                 "request_template":
                     "{\"X-Auth-Token\":\"${token}\","
                     "\"Content-Type\":\"application/json\"}| ",
                 "response_template":
                     "{\"retCode\":\"00000000\","
                     "\"flavors\":["
                     "{\"resourceType\":\"${resourceType}\","
                     "\"regionId\":\"${regionId}\","
                     "\"specType\":\"flavor\","
                     "\"meterId\":\"${flavorMeterId}\","
                     "\"specName\":\"vbs\","
                     "\"specDetail\":"
                     "\"{\\\"zh_CN\\\":\\\"备份容量\\\","
                     "\\\"en_US\\\":\\\"Backup Capacity\\\"}\"},"
                     "{\"resourceType\":\"${resourceType}\","
                     "\"regionId\":\"${regionId}\","
                     "\"specType\":\"flavor\","
                     "\"meterId\":\"${flavorMeterId}\","
                     "\"specName\":\"vbs_copy\","
                     "\"specDetail\":"
                     "\"{\\\"zh_CN\\\":\\\"复制容量\\\","
                     "\\\"en_US\\\":\\\"Duplication Capacity\\\"}\"}]}"
                 }
            ]
        }
