import utils.common.log as logger
from plugins.CSBS_VBS.job.ab_test.base import BaseTest
from utils.common.message import Message
from utils.common.exception import FCUException

logger.init("CSBS-VBS")


class CleanResource(BaseTest):
    def __init__(self, engine_id, pod_id, regionid_list=None):
        self.test_job_name = "Sub_Job_CleanResource"
        super(CleanResource, self).__init__(engine_id)

    def execute(self, engine_id, pod_id, regionid_list=None):
        try:
            self.execute_test_job_tasks()
        except Exception as err:
            logger.trace()
            logger.error("Execute test job Sub_Job_CleanResource failed,"
                         " msg: {}.".format(err))
            return Message(500, FCUException(645010))
        else:
            logger.info('Execute test job({}) '
                        'success.'.format(self.test_job_name))
            return Message(200)
