import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.message import Message

from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from plugins.CSBS_VBS.job.upgrade.tools.clear_os_patch import ClearOSPatch

logger.init("CSBS-VBS")


class ClearOSPatchFile(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ClearOSPatchFile, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.karbor_node_list = self.params_store.get_karbor_nodes()
        self.clear_os_patch = ClearOSPatch(self.karbor_node_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start to clear os patch on karbor nodes.")
        try:
            if not self.clear_os_patch.install():
                raise Exception("Failed to clear os patch file "
                                "on karbor nodes.")
        except Exception as e:
            logger.error(f"Failed to clear os patch file on "
                         f"karbor nodes, err_msg:{e}.")
            return Message(500, FCUException(645043))
        logger.info("Succeed to clear os patch file on karbor nodes.")
        return Message(200)
