# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSBS_VBS.common.constant import BACKUP_SERVICE_NAME
from plugins.CSBS_VBS.common.ssh_client import SshClient
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.common.upgrade.params import ParamsTools
from plugins.CSBS_VBS.common.util import auto_retry
from plugins.CSBS_VBS.common.util import check_url_param
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.message import Message

logger.init("CSBS")


class ConfigOCAlarm(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ConfigOCAlarm, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.service_name = "CSBS-VBS"
        self.param_tool = ParamsTools(self.project_id)
        self.karbor_operation = KarborOperation(self.project_id)
        self.ssh_client = SshClient()
        self.mo_util2 = ManageOneUtil2()
        self.thirdpart_account, self.thirdparty_pwd = \
            self.mo_util2.get_thirdparty_infor(self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            region_name = self.param_tool.get_region_name_by_region_id(
                self.region_id)
            karbor_ip_list = self.param_tool.get_karbor_ip_list(self.region_id)
            karbor_float_ip = self.param_tool.get_karbor_float_ip()
            self._add_xaas_white_list(region_name, karbor_ip_list, karbor_float_ip)
            self._config_alarm_endpoint()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, f"Failed to config oc alarm, "
                                f"err_msg:{e}")
        logger.info("Succeed to config oc alarm.")
        return Message(200)

    @auto_retry(max_retry_times=5, delay_time=60)
    def _add_xaas_white_list(self, region_name, karbor_ip_list, karbor_float_ip):
        logger.info("Start to add xaas white list.")
        result = self.mo_util2.add_xaas_white_list(
            params_list=[self.project_id, BACKUP_SERVICE_NAME, karbor_ip_list,
                         "", "", region_name],
            rest_protocol="1",
            snmp_protocol="",
            float_ip=karbor_float_ip)
        if not result:
            raise Exception("Failed to add xaas white list.")
        logger.info("Succeed to add xaas white list.")

    def _config_alarm_endpoint(self):
        oc_alarm_endpoint = f"{self.param_tool.get_oc_url(self.region_id)}" \
                            f"/oc/v2.3"
        # 校验endpoint
        check_url_param(oc_alarm_endpoint)

        logger.info(f"Start to set_alarm_endpoint, "
                    f"alarm endpoint: {oc_alarm_endpoint}.")
        cmd = f"set_alarm_endpoint --alarm_url {oc_alarm_endpoint}"
        karbor_client = self.ssh_client.get_ssh_client(
            self.param_tool.get_karbor_node_list()[0])
        self.ssh_client.ssh_send_command_expect(
            karbor_client, cmd, "user name", 30)
        self.ssh_client.ssh_send_command_expect(
            karbor_client, self.thirdpart_account, "password", 30)
        result = self.ssh_client.ssh_send_command_expect(
            karbor_client, self.thirdparty_pwd, "Successfully", 30)
        logger.info(result)
        self.ssh_client.ssh_close(karbor_client)
        if self.ssh_client.failed_to_return(result, "Successfully",
                                            karbor_client):
            raise Exception("Failed to config alarm endpoint for karbor node.")
        logger.info("Succeed to config alarm endpoint for karbor node.")
