# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSBS_VBS.common.constant import RegisterSDRData
from plugins.CSBS_VBS.common.constant import RegisterToMOInfo
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.common.util import auto_retry
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.business.manageone_util import ManageOneUtil
from utils.business.param_util import ParamUtil
from utils.business.sdr_util import SDRApi
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class RegisterMetricAndSDR(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RegisterMetricAndSDR, self).__init__(
            project_id, pod_id, regionid_list)
        self.param_util = ParamUtil()
        self.mo_util = ManageOneUtil()
        self.sdr = SDRApi(self.project_id, self.region_id)
        self.register_sdr_data = RegisterSDRData(
            self.region_id, self.params_store.get_karbor_float_ip())
        self.register_mo_info = RegisterToMOInfo(self.region_id)
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            # register_product_action
            for action in self.register_mo_info.csbs_vbs_action_list:
                if not self._register_product_action(self.pod_id, action):
                    logger.error(f"Register product action failed, "
                                 f"action info:{action}.")
                    return Message(500, "Failed to register product action.")

            result = self._register_meter_metrics(
                self.pod_id, self.register_mo_info.csbs_and_vbs_metric_info)
            if not result:
                return Message(500, "Failed to register meter metrics.")

            logger.info("Start to register SDR.")
            self.sdr.reg_plugin(self.register_sdr_data.csbs_data)
            self.sdr.reg_plugin(self.register_sdr_data.vbs_data)
            logger.info("Succeed to register SDR.")

            result = self.karbor_operation.change_meter_switch(tar_status="on")
            if not result:
                return Message(500, "Failed to turn on meter switch.")

        except Exception as e:
            logger.error(f"Failed to register metrics, err_msg:{str(e)}.")
            return Message(500, FCUException(645029))
        logger.info("Register SDR all finished.")
        return Message(200)

    @auto_retry(max_retry_times=5, delay_time=60)
    def _register_meter_metrics(self, pod_id, metric_info):
        result = self.mo_util.register_meter_metrics(pod_id, metric_info)
        if result:
            logger.info("Register metric information successfully.")
            return result

    @auto_retry(max_retry_times=5, delay_time=60)
    def _register_product_action(self, pod_id, product_action):
        result = self.mo_util.register_product_action(pod_id, product_action)
        if result:
            logger.info("Register product action successfully.")
            return result
