import utils.common.log as logger
from plugins.CSBS_VBS.common.constant import BACKUP_SERVICE_NAME
from plugins.CSBS_VBS.common.upgrade.params import ParamsTools
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class RollbackCMDB(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackCMDB, self).__init__(project_id, pod_id, regionid_list)
        self.service_name = BACKUP_SERVICE_NAME
        self.cipher_type = "CipherType"
        self.cmdb_util = ManageOneCmdbUtil(project_id)
        self.param_tool = ParamsTools(project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._rollback_csbs_to_cmdb()
        except Exception as e:
            logger.error("Failed executing register CMDB, "
                         "errmsg: {}.".format(e))
            return Message(500, FCUException(645022))
        logger.info("The backup service information has been "
                    "register succeed on CMDB.")
        return Message(200)

    def _rollback_csbs_to_cmdb(self):
        # 从CMDB获取注册信息
        cmdb_service_name = f"{self.service_name}_{self.region_id}"
        logger.info(f"Start to obtain {self.service_name} service "
                    f"info from CMDB.")
        service_info_list = self.cmdb_util.get_cloud_service_info(
            region_code=self.region_id,
            index_name=self.service_name,
            name=cmdb_service_name)
        if not service_info_list:
            raise Exception(f"Failed to obtain {self.service_name} info.")
        logger.info(f"The cloud service information obtained "
                    f"from the CMDB is: {service_info_list}.")

        # 组织注册数据
        karbor_version = self.param_tool.get_karbor_version_from_conf()
        cloud_service_info = dict()
        cloud_service_info["version"] = karbor_version.original_version
        cloud_service_info["originalVersion"] = karbor_version.target_version
        cloud_service_info["name"] = cmdb_service_name
        for service_info in service_info_list:
            if not service_info.get("name") == cmdb_service_name:
                continue
            cloud_service_info["indexName"] = service_info.get("indexName")
            cloud_service_info["name"] = service_info.get("name")
            extend_info_list = []
            for extend_info in service_info.get("extendInfos"):
                extend_info_list.append(extend_info)
            cloud_service_info["extendInfos"] = extend_info_list

        if not cloud_service_info:
            raise Exception("Failed to construct CMDB data.")

        # 注册CMDB
        logger.info(f"Start to register cloud service info to CMDB, "
                    f"cloud service info is: {cloud_service_info}.")
        self.cmdb_util.set_cloud_service_info(
            region_code=self.region_id,
            cloud_service_info=cloud_service_info)
        logger.info(f"Succeed to register {self.service_name} cmdb.")
