import utils.common.log as logger
from plugins.CSBS_VBS.common.ssh_client import SshClient
from plugins.CSBS_VBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UpgradeKarbor(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UpgradeKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.dmk_client = DMKClient(self.params_store)
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            logger.info("Login dmk and call DMK to upgrade Karbor.")
            # 修改28098端口被其他服务当作临时端口占用
            self.fix_ip_local_port_range_conf()

            action = "[Upgrade] CSBS-VBS Karbor"
            result = self.dmk_client.dmk_deploy_karbor(
                action, self.upgrade_path.karbor_pkg_version)
            if result:
                logger.info("Upgrade Karbor successfully.")
            else:
                logger.error("Failed to upgrade Karbor.")
                return Message(500, FCUException(645011))

            # stop karbor operation service
            self.karbor_operation.change_operation_service(tar_status="stop")

            self.karbor_operation.set_max_sync_time_interval_allowed(60)
        except Exception as e:
            logger.error("Failed to upgrade Karbor, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645011))
        return Message(200)

    def fix_ip_local_port_range_conf(self):
        cmd = 'sed -i "s/10240/50000/g" /karbor/CSBS/services/base/root_sudo/modify_os_configuration.sh'
        logger.info("Start to fix ip_local_port_range conf.")
        fix_failed = []
        for node in self.karbor_operation.karbor_node_list:
            karbor_client = self.ssh_client.get_ssh_client(node)
            result = self.ssh_client.ssh_exec_command_return(
                karbor_client, cmd)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                logger.error(f"Failed to execute the command on node, node ip: {node.ip}, the cmd:{cmd}.")
                fix_failed.append(node.ip)
                self.ssh_client.ssh_close(karbor_client)
                continue
            logger.info(f"Succeed to execute the command on node, node ip: {node.ip}.")
            self.ssh_client.ssh_close(karbor_client)
        if fix_failed:
            logger.warn(f"Failed to modify the configuration of some nodes, node ip:{fix_failed}.")
        logger.info("The ip_local_port_range is fixed.")
