import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UploadKarborPkg(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadKarborPkg, self).__init__(project_id, pod_id,
                                              regionid_list)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Upload Karbor upgrade package to karbor nodes
        """
        try:
            logger.info("Login dmk and call DMK to upload Karbor upgrade pkg.")
            action = "[Upload] CSBS-VBS Karbor Package"
            result = self.dmk_client.dmk_deploy_karbor(
                action, self.upgrade_path.karbor_pkg_version)
            if result:
                logger.info("Upload Karbor upgrade pkg to VM successfully.")
                return Message(200)
            else:
                return Message(500, FCUException(645005))
        except Exception as e:
            logger.error("Upload karbor package to Karbor nodes error, "
                         "err_msg: {}.".format(str(e)))
            return Message(500, FCUException(645005))
