# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.CSBS_VBS.common import karbor_threads
from plugins.CSBS_VBS.common.ssh_client import SshClient


class InstallerOSPatch(karbor_threads.CBSThreads):
    def __init__(self, karbor_nodes):
        super(InstallerOSPatch, self).__init__(karbor_nodes)
        self.ssh_client = SshClient()
        self.patch_path = "/home/djmanager/os_patch"

    def _untar_package(self, karbor_node):
        karbor_client = self.ssh_client.get_ssh_client(karbor_node)
        cmds = [
            f"cd {self.patch_path}",
            "tar -zxf 'OceanStor BCManager '*.tar.gz",
            "find euler_patch -name '*.sh' | xargs dos2unix"
        ]
        for cmd in cmds:
            result = self.ssh_client.ssh_exec_command_return(karbor_client,
                                                             cmd)
            logger.info(result)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                self.ssh_client.ssh_close(karbor_client)
                raise Exception(f"Failed to execute the cmd: {cmd}, "
                                "please check.")
        self.ssh_client.ssh_close(karbor_client)

    def _operate_os_patch(self, karbor_node, operate="patch"):
        karbor_client = self.ssh_client.get_ssh_client(karbor_node)
        cmds = [
            f"cd {self.patch_path}/euler_patch",
            f"sh secret_rpm_patch.sh {operate}"
        ]
        for cmd in cmds:
            result = self.ssh_client.ssh_exec_command_return(karbor_client,
                                                             cmd)
            logger.info(result)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                self.ssh_client.ssh_close(karbor_client)
                raise Exception(f"Failed to execute the cmd: {cmd}, "
                                "please check.")
        self.ssh_client.ssh_close(karbor_client)

    def install_thread(self, karbor_node):
        flag = True
        try:
            self._untar_package(karbor_node)
            self._operate_os_patch(karbor_node, operate="patch")
        except Exception as e:
            flag = False
            logger.error(str(e))
        self.install_result[karbor_node.ip] = flag

    def check_thread(self, karbor_node):
        self.check_result[karbor_node.ip] = True

    def rollback_thread(self, karbor_node):
        flag = True
        try:
            self._untar_package(karbor_node)
            self._operate_os_patch(karbor_node, operate="rollback")
        except Exception as e:
            flag = False
            logger.error(str(e))
        self.rollback_result[karbor_node.ip] = flag
