# -*- coding:utf-8 -*-
import os

import utils.common.log as logger
from plugins.CSBS_VBS.common import karbor_threads
from plugins.CSBS_VBS.common.ssh_client import SshClient


class UploadPkg(karbor_threads.CBSThreads):
    def __init__(self, karbor_nodes, pkg_path, pkg_name):
        super(UploadPkg, self).__init__(karbor_nodes)
        self.ssh_client = SshClient()
        self.file_path = os.path.join(pkg_path, pkg_name)
        self.patch_path = "/home/djmanager/os_patch"

    def _clear_work_dir(self, karbor_node):
        karbor_client = self.ssh_client.get_ssh_client(karbor_node)
        cmds = [
            f"rm -rf {self.patch_path}",
            f"mkdir -p {self.patch_path}",
            f"chown -R djmanager:openstack {self.patch_path}"
        ]
        for cmd in cmds:
            result = self.ssh_client.ssh_exec_command_return(karbor_client,
                                                             cmd)
            logger.info(result)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                self.ssh_client.ssh_close(karbor_client)
                raise Exception(f"Failed to execute the cmd: {cmd}, "
                                "please check.")
        self.ssh_client.ssh_close(karbor_client)

    def _upload_package(self, karbor_node):
        if not os.path.exists(self.file_path):
            raise Exception("The OS patch package does not exist.")
        self.ssh_client.put(karbor_node.ip,
                            karbor_node.user,
                            karbor_node.user_pwd,
                            self.file_path,
                            self.patch_path)

    def install_thread(self, karbor_node):
        flag = True
        try:
            self._clear_work_dir(karbor_node)
            self._upload_package(karbor_node)
        except Exception as e:
            flag = False
            logger.error(str(e))
        self.install_result[karbor_node.ip] = flag

    def check_thread(self, karbor_node):
        self.check_result[karbor_node.ip] = True

    def rollback_thread(self, karbor_node):
        self.rollback_result[karbor_node.ip] = True
