#!/bin/bash

logOut()
{
    if [[ $# != 3 ]];then
        echo "Incorrect number of input parameters."
        sed -i s/$iamPwd/xxx/g /var/log/messages
        sed -i s/$adminPwd/xxx/g /var/log/messages
        exit 1
    fi
    
    local netWorkType=$1
    local managementIP=$2
    local tokenStr=$3
    if [[ $netWorkType = "ipv4" ]];then
        ${ToolPath}/SecurityTool dmk delete https://$managementIP:8090/v3/auth/tokens "" "X-Auth-Token:$tokenStr" > /dev/null 2>&1
    else
        ${ToolPath}/SecurityTool dmk delete https://[$managementIP]:8090/v3/auth/tokens "" "X-Auth-Token:$tokenStr" > /dev/null 2>&1
    fi
}

registerCert()
{
    if [[ $# != 6 ]];then
        echo "Incorrect number of input parameters."
        sed -i s/$iamPwd/xxx/g /var/log/messages
        sed -i s/$adminPwd/xxx/g /var/log/messages
        exit 1
    fi

    local ToolPath="/opt/huawei-data-protection/ebackup/sbin";
    local netWorkType=$(cat /opt/huawei-data-protection/ebackup/conf/hcpconf.ini | grep -w NetworkType | awk -F '=' '{print $2}')
    local tmpFile="./RegisterCertToManageone.log"

    #login
    export LD_LIBRARY_PATH=/opt/huawei-data-protection/ebackup/libs
    data='{"auth":{"identity":{"methods":["password"],"password":{"user":{"name":"admin","password":"'$adminPwd'","iam_type":0}}}}}'
    if [[ $netWorkType = "ipv4" ]];then
        floatIP=$(grep -w listen /opt/huawei-data-protection/ebackup/microservice/ebk_lb/bin/nginx/conf/nginx.conf|grep -w 8090|awk '{print $2}'|awk -F ':' '{print $1}')
        ${ToolPath}/SecurityTool dmk post https://$floatIP:8090/v3/auth/tokens "$data" "Accept:application/json" > $tmpFile 2>&1
    else
        floatIP=$(grep -w listen /opt/huawei-data-protection/ebackup/microservice/ebk_lb/bin/nginx/conf/nginx.conf|grep -w 8090|awk '{print $2}'|awk -F '[' '{print $2}'|awk -F ']' '{print $1}')
        ${ToolPath}/SecurityTool dmk post https://[$floatIP]:8090/v3/auth/tokens "$data" "Accept:application/json" > $tmpFile 2>&1
    fi

    if [[ $? != 0 ]];then
        echo "get token failed, host=$floatIP" > $tmpFile
        cat $tmpFile
        sed -i s/$iamPwd/xxx/g /var/log/messages
        sed -i s/$adminPwd/xxx/g /var/log/messages
        exit 1
    fi

    local certUrl=$1
    local regionID=$2
    local iamUser=$3
    local omUrl=$6
    local tokenStr=$(cat $tmpFile | grep Subject-Token | awk -F ':' '{print $2}' | sed 's/ //')
    
    #register
    data='{"Settings":[{"ConfDomain":"UnifyCert","ConfItem":"ManageOneAddr","ConfValue":"'$certUrl'"},{"ConfDomain":"UnifyCert","ConfItem":"ManageOneOCAddr","ConfValue":"'$omUrl'"},{"ConfDomain":"UnifyCert","ConfItem":"CurrentRegion","ConfValue":"'$regionID'"},{"ConfDomain":"UnifyCert","ConfItem":"OpenstackIAMUserName","ConfValue":"'$iamUser'"},{"ConfDomain":"UnifyCert","ConfItem":"OpenstackIAMUserPassword","ConfValue":"'$iamPwd'"}]}'
    if [[ $netWorkType = "ipv4" ]];then
        internalIP=$(grep -w listen /opt/huawei-data-protection/ebackup/microservice/ebk_lb/bin/nginx/conf/nginx.conf|grep -w 8090|awk '{print $2}'|awk -F ':' '{print $1}')
        ${ToolPath}/SecurityTool dmk patch https://$internalIP:8090/v1/srv_governance_inner/settings "$data" "X-Auth-Token:$tokenStr" > $tmpFile 2>&1
    else
        internalIP=$(grep -w listen /opt/huawei-data-protection/ebackup/microservice/ebk_lb/bin/nginx/conf/nginx.conf|grep -w 8090|awk '{print $2}'|awk -F '[' '{print $2}'|awk -F ']' '{print $1}')
        ${ToolPath}/SecurityTool dmk patch https://[$internalIP]:8090/v1/srv_governance_inner/settings "$data" "X-Auth-Token:$tokenStr" > $tmpFile 2>&1
    fi
    if [[ $? != 0 ]];then
        echo "register cert failed, host=$internalIP" >> $tmpFile
        logOut $netWorkType $floatIP $tokenStr
        cat $tmpFile
        sed -i s/$iamPwd/xxx/g /var/log/messages
        sed -i s/$adminPwd/xxx/g /var/log/messages
        exit 1
    fi

    logOut $netWorkType $floatIP $tokenStr

    rm -fr $tmpFile >/dev/null 2>&1
}

iamPwd=$4
adminPwd=$5
registerCert $*
sed -i s/$iamPwd/xxx/g /var/log/messages
sed -i s/$adminPwd/xxx/g /var/log/messages