# -*- coding: utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.CommonUtil import check_system_pwd
from plugins.CSDR_CSHA_VHA.common.CommonUtil import check_value_null
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_all_server_nodes
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from utils.business.project_util import ProjectApi
from utils.common.code2Msg import code2Msg


def params_check(project_id):
    """插件参数校验接口函数

    :param: project_id
    :return: 成功：True, ''， 失败：False，错误信息，格式：
    {[region_id]key : err_msg1, [region_id]key : err_msg2}
    """

    # 待校验参数列表
    logger.info("Start VHA params_check task.")
    source_server_ip_key = "source_site_eReplication_physical_ip"
    source_server_business_key = "source_site_server_business_user_pwd"
    source_server_root_key = "source_site_server_root_pwd"
    target_server_ip_key = "target_site_eReplication_physical_ip"
    target_server_business_key = "target_site_server_business_user_pwd"
    target_server_root_key = "target_site_server_root_pwd"
    console_business_key = "source_site_console_business_user_pwd"
    console_root_key = "source_site_console_root_pwd"
    project_dict = ProjectApi().get_project_conditions(project_id)
    is_primary = project_dict.get("PrimaryRegion")
    is_global_con_dr = project_dict.get("GlobalConDR")
    is_partial_upgrade = project_dict.get("CloudPlatform6")
    source_check_list = [source_server_ip_key, source_server_business_key,
                         source_server_root_key]
    target_check_list = [target_server_ip_key, target_server_business_key,
                         target_server_root_key]
    console_check_list = [console_business_key, console_root_key]
    if is_primary:
        check_list = source_check_list + target_check_list
        if is_partial_upgrade:
            check_list += console_check_list
    elif is_global_con_dr:
        check_list = target_check_list + []
        if is_partial_upgrade:
            check_list += console_check_list
    else:
        check_list = target_check_list
    # 记录非空且存在的key
    true_keys = []
    check_result = HandleParamCheck()
    params = ParamUtil().get_need_check_cloud_params(project_id, "VHA")
    # 校验所有参数值是否为空
    for key in check_list:
        if key not in list(params.keys()):
            logger.error(f"Can not find the param key: {key}.")
            check_result.set_check_result(
                param_keys=[key], status=500, error_msg=code2Msg(665004))
        elif check_value_null(params.get(key)):
            logger.error(f"The key value is None: {key}.")
            check_result.set_check_result(
                param_keys=[key], status=500, error_msg=code2Msg(665005))
        else:
            true_keys.append(key)
    if is_primary:
        check_result = check_server_params(
            source_server_ip_key, "DRManager", source_server_business_key,
            source_server_root_key, params, true_keys, source_check_list,
            check_result)
    check_result = check_server_params(
        target_server_ip_key, "DRManager", target_server_business_key,
        target_server_root_key, params, true_keys, target_check_list,
        check_result)
    if (is_primary or is_global_con_dr) and is_partial_upgrade:
        check_result = check_console_params(
            project_id, params, true_keys, check_result)
    if len(check_result.check_list) == 0:
        check_result.set_check_result(
            param_keys=check_list, status=200, error_msg='')
    return check_result


def check_server_params(
        host_key, ssh_user, ssh_pwd_key, sudo_pwd_key, params, true_keys,
        check_list, check_result):
    check_result_list = list()
    host = params.get(host_key)
    ssh_pwd = params.get(ssh_pwd_key)
    sudo_pwd = params.get(sudo_pwd_key)
    login1, check1 = check_system_pwd(
        host, ssh_user, ssh_pwd_key,
        sudo_pwd_key, check_result, params, true_keys)
    check_result_list.append(check1)
    if login1:
        all_ips = get_all_server_nodes(host, ssh_user, ssh_pwd, sudo_pwd)
        if len(all_ips) not in [2, 4] or host not in all_ips:
            logger.error(
                f"Query eReplication ip from {host} failed.")
            check_result.set_check_result(
                param_keys=check_list, status=500, error_msg=code2Msg(665006))
        else:
            all_ips.remove(host)

            if all_ips:
                for ip in all_ips:
                    login2, check2 = check_system_pwd(
                        ip, ssh_user, ssh_pwd_key, sudo_pwd_key,
                        check_result, params, true_keys)
                    check_result_list.append(check2)
                if False not in check_result_list:
                    check_result.set_check_result(
                        param_keys=check_list,
                        status=200, error_msg="")
            else:
                check_result.set_check_result(
                    param_keys=check_list,
                    status=200, error_msg="")
    return check_result


def check_console_params(project_id, params, true_keys, check_result):
    console_business_key = "source_site_console_business_user_pwd"
    console_root_key = "source_site_console_root_pwd"
    # 校验密码参数
    vm_info = ParamUtil().get_vm_info_by_vm_name(
        project_id, "Console-eReplication01")
    if not vm_info:
        logger.info("Console-eReplication01 is not existed.")
        check_result.set_check_result(
            param_keys=[console_business_key, console_root_key], status=500,
            error_msg=code2Msg(675011))
        return check_result
    console_ip1 = vm_info[0].get('ip')

    vm_info = ParamUtil().get_vm_info_by_vm_name(
        project_id, "Console-eReplication02")
    if not vm_info:
        logger.info("Console-eReplication02 is not existed.")
        check_result.set_check_result(
            param_keys=[console_business_key, console_root_key], status=500,
            error_msg=code2Msg(675011))
        return check_result
    console_ip2 = vm_info[0].get('ip')
    logger.info("Success get all nodes' ip.")

    # 校验外部参数值的正确性, 目前需要的是校验console的系统密码是否正确
    # 校验server的密码, 能连通且不为空才校验，
    login1, check1 = check_system_pwd(console_ip1, "csdr_admin",
                                      console_business_key,
                                      console_root_key,
                                      check_result, params, true_keys)
    login2, check2 = check_system_pwd(console_ip2, "csdr_admin",
                                      console_business_key,
                                      console_root_key,
                                      check_result, params, true_keys)
    if check1 and check2:
        check_result.set_check_result(
            param_keys=[console_business_key, console_root_key], status=200,
            error_msg="")
    return check_result
