# -*- coding:utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.CipherBase import CipherBase
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_service_type, \
    get_server_params
from plugins.CSDR_CSHA_VHA.common.Validater import judge_check_step_result
from utils.common.check_result import CheckResult
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class CheckServerEnv(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(CheckServerEnv, self).__init__(
            project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_type = get_service_type(self.project_id)

        server_params = get_server_params(
            self.project_id, self.region, self.service_type)
        self.server_ip1 = server_params["server_ip1"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = server_params[
            "server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_check_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        try:
            logger.info("Start check service environment process.")
            check_result = list()
            if not self.server_ip1:
                logger.error("Get server ip failed.")
                check = CheckResult(
                    itemname_ch="获取节点IP", itemname_en="Get server ip",
                    status="failure", error_msg_cn=FCUException("665006"))
                check_result.append(check)
                return Message(200, check_results=check_result)
            cipher_base = CipherBase(
                self.project_id, self.server_ip1, self.server_business_user,
                self.server_business_user_pwd, self.server_root_pwd)
            check_result = cipher_base.check_environment()
            cipher_base.check_cipher_type()
            logger.info("Check environment finished.")
            return Message(200, check_results=check_result)
        except FCUException as e:
            logger.error(f"Check service environment failed, "
                         f"error message is {str(e)}.")
            check_result = CheckResult(
                itemname_ch="运行环境校验",
                itemname_en="Check the Running Environment",
                status="failure", error_msg_cn=e)
            return Message(200, check_results=[check_result])
        except Exception as e:
            logger.error(f"Check service environment failed, "
                         f"error message is {str(e)}.")
            ex = FCUException('665002', str(e))
            check_result = CheckResult(
                itemname_ch="运行环境校验",
                itemname_en="Check the Running Environment",
                status="failure", error_msg_cn=ex)
            return Message(200, check_results=[check_result])

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :return: Message对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return:
        """

        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行注册，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)
