# -*- coding:utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.DataMigrateBase import DataMigrateBase
from plugins.CSDR_CSHA_VHA.common.Validater import judge_check_step_result
from utils.common.check_result import CheckResult
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class VersionCheck(StepBaseInterface):
    """校验数据迁移源站点和目标站点容灾服务版本是否一致"""

    def __init__(self, project_id, pod_id, regionid_list):
        super(VersionCheck, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_check_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        try:
            logger.info("Start check DR service version process.")
            data_migrate_base = DataMigrateBase(
                self.project_id, self.pod_id, self.regionid_list)

            check_result = \
                data_migrate_base.check_dr_service_version()
            logger.info("Check DR service version finished.")
            return Message(200, check_results=check_result)
        except FCUException as e:
            logger.error(
                f"Version check failed, error message is {str(e)}")
            check_result = CheckResult(
                itemname_ch="容灾服务版本号检查",
                itemname_en="Checking the DR software Version",
                status="failure", error_msg_cn=e)
            return Message(200, check_results=[check_result])
        except Exception as e:
            logger.error(
                f"Version check failed, error message is {str(e)}")
            ex = FCUException('665002', str(e))
            check_result = CheckResult(
                itemname_ch="容灾服务版本号检查",
                itemname_en="Checking the DR software Version",
                status="failure", error_msg_cn=ex)
            return Message(200, check_results=[check_result])

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :return: Message对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return:
        """

        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行注册，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)
