# -*- coding:utf-8 -*-

import utils.common.log as logger
from plugins.CSDR_CSHA_VHA.common.AutoRetry import retry
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_all_server_nodes
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_server_params
from plugins.CSDR_CSHA_VHA.common.CommonUtil import get_service_type
from plugins.CSDR_CSHA_VHA.common.ServerProcessor import ServerProcessor
from plugins.CSDR_CSHA_VHA.common.Validater import judge_check_step_result
from utils.common.check_result import CheckResult
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

logger.init("eReplication")


class CheckServerEnv(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(CheckServerEnv, self).__init__(
            project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region = regionid_list[0]
        self.service_type = get_service_type(self.project_id)

        server_params = get_server_params(
            self.project_id, self.region, self.service_type)
        self.server_ip1 = server_params["server_ip1"]
        self.server_business_user = server_params["server_business_user"]
        self.server_business_user_pwd = server_params[
            "server_business_user_pwd"]
        self.server_root_pwd = server_params["server_root_pwd"]

    def pre_check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)

    @retry(3, 20, 20, (FCUException, Exception),
           validate=judge_check_step_result)
    def execute(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """

        logger.info("Start check process.")
        results = list()
        if not self.server_ip1:
            logger.error("Get server ip failed.")
            check = CheckResult(
                itemname_ch="获取节点IP", itemname_en="Get server ip",
                status="failure", error_msg_cn=FCUException("665008"))
            results.append(check)
            return Message(200, check_results=results)

        # 初始化参数信息
        all_ips = get_all_server_nodes(
            self.server_ip1, self.server_business_user,
            self.server_business_user_pwd, self.server_root_pwd)
        if len(all_ips) not in [2, 4] or self.server_ip1 not in all_ips:
            logger.error(
                f"Query eReplication ip from {self.server_ip1} failed.")
            check = CheckResult(
                itemname_ch="获取对端节点IP",
                itemname_en="Get the peer server ip", status="failure",
                error_msg_cn=FCUException(665006))
            results.append(check)
            return Message(200, check_results=results)

        for ip in all_ips:
            processor1 = ServerProcessor(
                ip, self.server_business_user, self.server_business_user_pwd,
                self.server_root_pwd)
            net_check_list = processor1.check_server_connection()
            if len(net_check_list) == 0:
                # 网络通的情况下再进行后续检查
                results.append(
                    CheckResult(
                        itemname_ch=f"检查网络连接[{ip}]",
                        itemname_en=f"Check network connection[{ip}]",
                        status="success"))
                results.extend(processor1.check_env(project_id))
            else:
                results.extend(net_check_list)
        logger.info("Check environment end.")
        return Message(200, check_results=results)

    def rollback(self, project_id, pod_id, regionid_list):
        """标准调用接口：执行回滚

        :return: Message对象
        """

        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """标准调用接口：重试

        :return:
        """

        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """插件内部接口：执行注册，该接口由execute接口调用，

        工具框架不会直接调用此接口
        :return:
        """

        return Message(200)
