#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname ${CURRENT_DIR})
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/base_upgrade.log"


function check_pkg_arch() {
    os_arch=$(uname -i)
    x86_file_num=$(find "${LINE_ROOT}" -type f -name "*x86_64*" | wc -w)
    aar64_file_num=$(find "${LINE_ROOT}" -type f -name "*aarch64*" | wc -w)
    if [[ $x86_file_num -gt $aar64_file_num ]]; then
        pkg_arch="x86_64"
    else
        pkg_arch="aarch64"
    fi
    if [[ ${pkg_arch} != ${os_arch} ]]; then
        log_error "The ${pkg_arch} pakcage does not match the ${os_arch} os."
        return 1
    fi
    return 0
}

function main() {
    check_pkg_arch; CHECK_RESULT $?
}

main
log_info "Check arch success."
exit 0
