#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/huawei/dj/install.log"
source $(dirname ${cur_dir})/utils.sh
UTIL_CONF=$(dirname $(dirname ${cur_dir}))/conf/util.conf

function modify_pam_for_euler2_sp8()
{
    if [ -f /etc/euleros-release ]
    then
        cat /etc/euleros-release | grep "2.0" | grep "SP8" 1>/dev/null 2>/dev/null
        if [ $? -eq 0 ]
        then
            sed -i 's/^account     required      pam_faillock.so/#account     required      pam_faillock.so/g' /etc/pam.d/system-auth
        fi
    fi
}

function set_djmanager_for_sudo()
{
    mkdir -p "/etc/sudoers.d"
    touch /etc/sudoers.d/openstack
    chmod 400 /etc/sudoers.d/openstack
    sed -i "/Defaults    requiretty/c #Defaults    requiretty" /etc/sudoers
    cat /etc/sudoers | grep  '^#includedir /etc/sudoers.d$' > /dev/null 2>&1
    if [ $? -eq 0 ];then
        log_info "#includedir /etc/sudoers.d is exist in file /etc/sudoers."
        return 0
    fi
    echo "#includedir /etc/sudoers.d" >> "/etc/sudoers"
}


function check_log_directory_permission()
{
    local log_path='/var/log/huawei/dj'
    rm -rf $log_path
    mkdir -m 750 -p $log_path
    mkdir -p $log_path/services/system
    mkdir -p $log_path/services/operate
    chown -hR root:openstack ${log_path}
    chmod -R 750 $log_path/services
}


function set_local_port_range()
{
    local port_info="net.ipv4.ip_local_port_range = 10240   65000"
    sed -i '/net.ipv4.ip_local_port_range =*/d' /etc/sysctl.conf
    echo "${port_info}" >> /etc/sysctl.conf
}


function set_share_memory()
{
    # set share memory segement
    sed -i '/kernel.shmmax=*/d' /etc/sysctl.conf
    sed -i '/kernel.shmall=*/d' /etc/sysctl.conf
    totalMemKB=`cat /proc/meminfo | grep MemTotal | awk '{print $2}'`
    totalMemBit=`expr ${totalMemKB} \* 1024` 
    half_totlaMemBit=`expr ${totalMemBit} / 2`
    echo "kernel.shmmax=${half_totlaMemBit}" >> /etc/sysctl.conf
    echo "kernel.shmall=${half_totlaMemBit}" >> /etc/sysctl.conf
    sysctl -p >/dev/null
    log_info "Set required system share memory OK."
    return 0
}


function set_ip_forward()
{
    sed -i '/net.ipv4.ip_nonlocal_bind=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.ip_forward=*/d' /etc/sysctl.conf
    sed -i '/net.ipv6.conf.all.forwarding=*/d' /etc/sysctl.conf
    sed -i '/net.ipv6.ip_nonlocal_bind=*/d' /etc/sysctl.conf
    echo "net.ipv4.ip_nonlocal_bind=1"  >> /etc/sysctl.conf
    echo "net.ipv4.ip_forward=1"  >> /etc/sysctl.conf
    echo "net.ipv6.conf.all.forwarding=0"  >> /etc/sysctl.conf
    echo "net.ipv6.ip_nonlocal_bind=1"  >> /etc/sysctl.conf
    sysctl -p > /dev/null
    log_info "Set net.ipv4.ip_forward OK."
    return 0
}


function set_sys_timezone()
{
    # Set system timezone
    acttimez=`get_info.py --timezone`
    if [ $? -ne 0 ] || [ "$acttimez" = "None" ];then
        log_error "Achieve the (timezone) parameter from ini file failed..."
        return 1
    fi
    timezoneFile="/usr/share/zoneinfo/$acttimez"
    if [ ! -f $timezoneFile ];then
        log_error "The timezone file setting by user does not exist..."
        return 1
    fi
    rm -f /etc/localtime && ln -sf /usr/share/zoneinfo/$acttimez  /etc/localtime
    if [ $? -ne 0 ];then
        log_error "Set timezone failed..."
        return 1
    fi
    hwclock -w
    log_info "Set required system timezone OK."
    return 0
}


function set_hostname()
{
    # Set hostname 
    HOSTNM=`get_info.py --hostname`
    HOSTIP=`get_info.py --manage_ip`
    if [ $? -ne 0 ] || [ "${HOSTNM}" = "None" ];then
        log_error "Achieve the parameter (hostname) from ini file failed..."
        return 1
    fi
    hostname ${HOSTNM}
    echo ${HOSTNM} > /etc/hostname
    echo ${HOSTNM} > /etc/HOSTNAME
    config_hosts ${HOSTIP} ${HOSTNM}
    log_info "Set required hostname OK."
    return 0    
}

# add os user
function add_user()
{
    groupadd -g 51001 openstack  > /dev/null 2>&1
    useradd -u 51001 -g openstack -s /sbin/nologin -d /home/openstack -m openstack > /dev/null 2>&1
    sed '/umask/d' /home/openstack/.profile && echo "umask 027" >> /home/openstack/.profile
    for group in $(grep "GROUPS" /etc/default/useradd  | cut -d= -f2 | sed "s/,/  /");do groupmod -R openstack ${group};done
    mkdir -p /home/openstack && chown -h openstack:openstack /home/openstack && chmod 700 /home/openstack
    log_info "Add user openstack OK."

    groupadd -g 51002 dbgrp  > /dev/null 2>&1
    useradd -u 51002 -g dbgrp -d /home/gaussdba -m -s /sbin/nologin gaussdba > /dev/null 2>&1
    sed '/umask/d' /home/gaussdba/.profile && echo "umask 027" >> /home/gaussdba/.profile
    mkdir -p /home/gaussdba && chown -h gaussdba:dbgrp /home/gaussdba && chmod 700 /home/gaussdba
    log_info "Add user gaussdba OK."

    useradd -u 51003 -g openstack -d /home/djmanager -m djmanager > /dev/null 2>&1
    usermod -G wheel djmanager
    sed '/umask/d' /home/djmanager/.profile && echo "umask 027" >> /home/djmanager/.profile
    for group in $(grep "GROUPS" /etc/default/useradd  | cut -d= -f2 | sed "s/,/  /");do groupmod -R djmanager ${group};done
    mkdir -p /home/djmanager && chown -h djmanager:openstack /home/djmanager && chmod 700 /home/djmanager
    log_info "Add user djmanager  OK."
    return 0
}


function set_syslog()
{
    if [ -d /etc/rsyslog.d ];then
        /usr/bin/cp -f $(dirname $(dirname ${cur_dir}))/conf/rsyslog_csbs.conf /etc/rsyslog.d/dj.conf
        service rsyslog restart
    fi
    log_info "Set system log OK."
    return 0
}


function create_cfg_dir()
{
    mkdir -p /opt/huawei/dj/{etc,bin,cfg,inspect,DJSecurity,inst,paas,tools}
    chown -h root:openstack /opt/huawei/dj/{etc,bin,cfg,inspect,DJSecurity,inst,paas,tools}
    chmod 750 /opt/huawei/dj/{etc,bin,cfg,inspect,DJSecurity,inst,paas,tools}
    chown -h root:openstack /usr/bin/get_info.py && chmod 550 /usr/bin/get_info.py
    chown -h root:openstack /usr/bin/karbor_ping && chmod 550 /usr/bin/karbor_ping
    chown -h root:openstack /usr/bin/python* && chown -h root:openstack /usr/lib*/*python*
    return 0
}


function create_start_list_file()
{
    bin_dir=/opt/huawei/dj/bin
    cd $(dirname $0)
    cp -f ${cur_dir}/DJserviceControl.sh ${bin_dir}
    cp -f ${cur_dir}/DJControl.sh ${bin_dir}
    cd - >/dev/null
    if [ ! -e "${bin_dir}/DJserviceControl.sh" ];then
        log_error "DJserviceControl.sh not exist in system."
        return 1
    fi
    if [ ! -e "${bin_dir}/DJControl.sh" ];then
        log_error "DJControl.sh not exist in system."
        return 1
    fi
    chmod 500 ${bin_dir}/DJserviceControl.sh
    chmod 550 ${bin_dir}/DJControl.sh
    rm -f /usr/bin/DJserviceControl && ln -s ${bin_dir}/DJControl.sh /usr/bin/DJserviceControl
    return 0
}


function make_auto_start_file()
{
    local start_file="/etc/init.d/DJControl"
    echo '#!/bin/bash'>$start_file
    echo '# chkconfig: 2345 10 90'>>$start_file
    echo '/opt/huawei/dj/bin/DJserviceControl.sh $@ &'>>$start_file
    echo 'exit 0'>>$start_file
    #to config
    chmod 750 $start_file
    #check result
    `/sbin/chkconfig --add DJControl`
    local ret=`/sbin/chkconfig --list DJControl`
    if [ -n "$ret" ];then
         log_info "Auto start config success:$ret"
         log_info "Auto start file config success:$ret_f"
         return 0
    fi
    log_info "Auto start config failed:$ret <===> $ret_f"
    return 1
}


function generate_pwd()
{
    line=$(grep -n '\[SYSTEM\]' /opt/huawei/dj/cfg/sys.ini|cut -d: -f1)

    gaussdb_admin_pwd_en=$(get_pwd "gaussdb_admin_pwd" ${UTIL_CONF})
    gaussdb_admin_pwd_info="gaussdb_admin_pwd=${gaussdb_admin_pwd_en}"
    ret=`zgrep gaussdb_admin_pwd /opt/huawei/dj/cfg/sys.ini`
    if [[ ${ret} == "" ]];then
        sed -i "${line}a${gaussdb_admin_pwd_info}" /opt/huawei/dj/cfg/sys.ini
    fi

    rabbitmq_pwd_en=$(get_pwd "rabbitmq_pwd" ${UTIL_CONF})
    rabbitmq_pwd_info="rabbitmq_pwd=${rabbitmq_pwd_en}"
    ret=`zgrep rabbitmq_pwd /opt/huawei/dj/cfg/sys.ini`
    if [[ ${ret} == "" ]];then
        sed -i "${line}a${rabbitmq_pwd_info}" /opt/huawei/dj/cfg/sys.ini
    fi

    default_user_pwd_en=$(get_pwd "default_user_pwd" ${UTIL_CONF})
    default_user_pwd_info="default_user_pwd=${default_user_pwd_en}"
    ret=`zgrep default_user_pwd /opt/huawei/dj/cfg/sys.ini`
    if [[ ${ret} == "" ]];then
        sed -i "${line}a${default_user_pwd_info}" /opt/huawei/dj/cfg/sys.ini
    fi
}


# fix ICMP Timestamp Request Remote Date Disclosure
function icmp_timestamp_drop()
{
    iptables -C INPUT -p icmp --icmp-type timestamp-request -j DROP >>/dev/null 2>&1
    if [ $? -ne 0 ];then
        iptables -A INPUT -p icmp --icmp-type timestamp-request -j DROP
    fi
    iptables -C OUTPUT -p icmp --icmp-type timestamp-reply -j DROP >>/dev/null 2>&1
    if [ $? -ne 0 ];then
        iptables -A OUTPUT -p icmp --icmp-type timestamp-reply -j DROP
    fi
    return 0
}

function set_system_ntp_config()
{
    sed -i '/maxdist/d' /etc/ntp.conf
    sed -i '1 i\tos maxdist 30' /etc/ntp.conf
    if [[ $? -ne 0 ]];then
        log_error "Add maxdist value failed."
        return 1
    fi
    service ntpd restart
    log_info "Add maxdist value successfully."

    cat /etc/crontab | grep "/sbin/hwclock -w"
    if [[ $? -ne 0 ]];then
        sed -i '$a */10 * * * * root /sbin/hwclock -w' /etc/crontab
        if [[ $? -ne 0 ]];then
            log_error "Set hwclock crontab failed."
            return 1
        fi
    fi
    service crond restart
    log_info  "Set hwclock crontab successfully."
    return 0
}

check_log_directory_permission; CHECK_RESULT $? "Check log directory permission failed."
add_user; CHECK_RESULT $? "add user failed."
set_local_port_range; CHECK_RESULT $? "Set local port range failed."
set_share_memory; CHECK_RESULT $? "Set share memory failed."
set_ip_forward; CHECK_RESULT $? "Set ip forward failed."
set_sys_timezone; CHECK_RESULT $? "Set sys timezone failed."
set_hostname; CHECK_RESULT $? "Set hostname failed."
set_syslog; CHECK_RESULT $? "Set syslog failed."
create_cfg_dir; CHECK_RESULT $? "Create cfg dir failed."
create_start_list_file; CHECK_RESULT $? "Create start list file failed."
make_auto_start_file; CHECK_RESULT $? "Make auto start file failed."
generate_pwd; CHECK_RESULT $? "Generate pwd failed."
set_djmanager_for_sudo; CHECK_RESULT $? "Set djmanager auth failed."
icmp_timestamp_drop; CHECK_RESULT $? "Drop icmp timestamp failed."
modify_pam_for_euler2_sp8; CHECK_RESULT $? "Modify pam for euler2 sp8 failed."
set_system_ntp_config; CHECK_RESULT $? "Set system ntp config failed."
exit 0
